/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.nio.Connection;
import com.hazelcast.nio.SocketReadable;
import com.hazelcast.nio.SocketWritable;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DefaultData;
import java.nio.ByteBuffer;

public final class Packet
implements SocketWritable,
SocketReadable {
    public static final byte VERSION = 4;
    public static final int HEADER_OP = 0;
    public static final int HEADER_RESPONSE = 1;
    public static final int HEADER_EVENT = 2;
    public static final int HEADER_WAN_REPLICATION = 3;
    public static final int HEADER_URGENT = 4;
    public static final int HEADER_BIND = 5;
    private static final short PERSIST_VERSION = 1;
    private static final short PERSIST_HEADER = 2;
    private static final short PERSIST_PARTITION = 3;
    private static final short PERSIST_SIZE = 4;
    private static final short PERSIST_VALUE = 5;
    private static final short PERSIST_COMPLETED = Short.MAX_VALUE;
    private Data data;
    private short header;
    private int partitionId;
    private transient Connection conn;
    private int valueOffset;
    private int size;
    private short persistStatus;

    public Packet() {
    }

    public Packet(Data data) {
        this(data, -1);
    }

    public Packet(Data data, int partitionId) {
        this.data = data;
        this.partitionId = partitionId;
    }

    public Connection getConn() {
        return this.conn;
    }

    public void setConn(Connection conn) {
        this.conn = conn;
    }

    public void setHeader(int bit) {
        this.header = (short)(this.header | 1 << bit);
    }

    public boolean isHeaderSet(int bit) {
        return (this.header & 1 << bit) != 0;
    }

    public short getHeader() {
        return this.header;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public boolean isUrgent() {
        return this.isHeaderSet(4);
    }

    @Override
    public boolean writeTo(ByteBuffer destination) {
        if (!this.writeVersion(destination)) {
            return false;
        }
        if (!this.writeHeader(destination)) {
            return false;
        }
        if (!this.writePartition(destination)) {
            return false;
        }
        if (!this.writeSize(destination)) {
            return false;
        }
        if (!this.writeValue(destination)) {
            return false;
        }
        this.setPersistStatus((short)Short.MAX_VALUE);
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer source) {
        if (!this.readVersion(source)) {
            return false;
        }
        if (!this.readHeader(source)) {
            return false;
        }
        if (!this.readPartition(source)) {
            return false;
        }
        if (!this.readSize(source)) {
            return false;
        }
        if (!this.readValue(source)) {
            return false;
        }
        this.setPersistStatus((short)Short.MAX_VALUE);
        return true;
    }

    private boolean readVersion(ByteBuffer source) {
        if (!this.isPersistStatusSet((short)1)) {
            if (!source.hasRemaining()) {
                return false;
            }
            byte version = source.get();
            this.setPersistStatus((short)1);
            if (4 != version) {
                throw new IllegalArgumentException("Packet versions are not matching! Expected -> 4, Incoming -> " + version);
            }
        }
        return true;
    }

    private boolean writeVersion(ByteBuffer destination) {
        if (!this.isPersistStatusSet((short)1)) {
            if (!destination.hasRemaining()) {
                return false;
            }
            destination.put((byte)4);
            this.setPersistStatus((short)1);
        }
        return true;
    }

    private boolean readHeader(ByteBuffer source) {
        if (!this.isPersistStatusSet((short)2)) {
            if (source.remaining() < 2) {
                return false;
            }
            this.header = source.getShort();
            this.setPersistStatus((short)2);
        }
        return true;
    }

    private boolean writeHeader(ByteBuffer destination) {
        if (!this.isPersistStatusSet((short)2)) {
            if (destination.remaining() < 2) {
                return false;
            }
            destination.putShort(this.header);
            this.setPersistStatus((short)2);
        }
        return true;
    }

    private boolean readPartition(ByteBuffer source) {
        if (!this.isPersistStatusSet((short)3)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.partitionId = source.getInt();
            this.setPersistStatus((short)3);
        }
        return true;
    }

    private boolean writePartition(ByteBuffer destination) {
        if (!this.isPersistStatusSet((short)3)) {
            if (destination.remaining() < 4) {
                return false;
            }
            destination.putInt(this.partitionId);
            this.setPersistStatus((short)3);
        }
        return true;
    }

    private boolean readSize(ByteBuffer source) {
        if (!this.isPersistStatusSet((short)4)) {
            if (source.remaining() < 4) {
                return false;
            }
            this.size = source.getInt();
            this.setPersistStatus((short)4);
        }
        return true;
    }

    private boolean writeSize(ByteBuffer destination) {
        if (!this.isPersistStatusSet((short)4)) {
            if (destination.remaining() < 4) {
                return false;
            }
            this.size = this.data.totalSize();
            destination.putInt(this.size);
            this.setPersistStatus((short)4);
        }
        return true;
    }

    private boolean writeValue(ByteBuffer destination) {
        if (!this.isPersistStatusSet((short)5)) {
            if (this.size > 0) {
                boolean done;
                int bytesWrite;
                int bytesNeeded;
                int bytesWritable = destination.remaining();
                if (bytesWritable >= (bytesNeeded = this.size - this.valueOffset)) {
                    bytesWrite = bytesNeeded;
                    done = true;
                } else {
                    bytesWrite = bytesWritable;
                    done = false;
                }
                byte[] byteArray = this.data.toByteArray();
                destination.put(byteArray, this.valueOffset, bytesWrite);
                this.valueOffset += bytesWrite;
                if (!done) {
                    return false;
                }
            }
            this.setPersistStatus((short)5);
        }
        return true;
    }

    private boolean readValue(ByteBuffer source) {
        if (!this.isPersistStatusSet((short)5)) {
            byte[] bytes;
            if (this.data == null) {
                bytes = new byte[this.size];
                this.data = new DefaultData(bytes);
            } else {
                bytes = this.data.toByteArray();
            }
            if (this.size > 0) {
                boolean done;
                int bytesRead;
                int bytesNeeded;
                int bytesReadable = source.remaining();
                if (bytesReadable >= (bytesNeeded = this.size - this.valueOffset)) {
                    bytesRead = bytesNeeded;
                    done = true;
                } else {
                    bytesRead = bytesReadable;
                    done = false;
                }
                source.get(bytes, this.valueOffset, bytesRead);
                this.valueOffset += bytesRead;
                if (!done) {
                    return false;
                }
            }
            this.setPersistStatus((short)5);
        }
        return true;
    }

    public int size() {
        return (this.data != null ? this.data.totalSize() : 0) + 11;
    }

    public Data getData() {
        return this.data;
    }

    public void setData(Data data) {
        this.data = data;
    }

    public boolean done() {
        return this.isPersistStatusSet((short)Short.MAX_VALUE);
    }

    public void reset() {
        this.data = null;
        this.persistStatus = 0;
    }

    private void setPersistStatus(short persistStatus) {
        this.persistStatus = persistStatus;
    }

    private boolean isPersistStatusSet(short status) {
        return this.persistStatus >= status;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Packet{");
        sb.append("header=").append(this.header);
        sb.append(", isResponse=").append(this.isHeaderSet(1));
        sb.append(", isOperation=").append(this.isHeaderSet(0));
        sb.append(", isEvent=").append(this.isHeaderSet(2));
        sb.append(", partitionId=").append(this.partitionId);
        sb.append(", conn=").append(this.conn);
        sb.append('}');
        return sb.toString();
    }
}

