module.exports = {
    'root': true,

    'env': {
        // browser global variables.
        'browser': true,
        // Node.js global variables and Node.js-specific rules.
        'node': true,
        // jquery global variables.
        'jquery': true,
        // defines require() and define() as global variables as per the amd spec.
        'amd': true,
        'shared-node-browser': true
    },

    'globals': {
        _: true,
        _paq: true,
        requirejs: true,
        Backbone: true,
        ox: true,
        moment: true,
        Modernizr: true
    },

    'extends': ['eslint:recommended'],

    'rules': {
        // POSSIBLE ERRORS
        //
        // The following rules point out areas where you might have made mistakes.
        //
        // http://eslint.org/docs/rules/index.html#possible-errors

        // disallow assignment in conditional expressions
        'no-cond-assign': 0,

        // disallow use of console in the node environment
        'no-console': 0,

        // disallow use of constant expressions in conditions
        'no-constant-condition': 0,

        // disallow control characters in regular expressions
        'no-control-regex': 0,

        // disallow use of debugger
        'no-debugger': 1,

        // disallow double-negation boolean casts in a boolean context
        'no-extra-boolean-cast': 0,

        // disallow unnecessary parentheses
        'no-extra-parens': [2, "functions"],

        // BEST PRACTICES
        // http://eslint.org/docs/rules/#best-practices

        // treat var statements as if they were block scoped
        'block-scoped-var': 2,

        // specify curly brace conventions for all control statements
        'curly': [2, 'multi-line'],

        // require default case in switch statements
        'default-case': 2,

        // encourages use of dot notation whenever possible
        'dot-notation': [2, { 'allowKeywords': false }],

        // require the use of === and !==
        'eqeqeq': 2,

        // disallow the use of alert, confirm, and prompt
        'no-alert': 1,

        // disallow use of arguments.caller or arguments.callee
        'no-caller': 2,

        // disallow division operators explicitly at beginning of regular expression
        'no-div-regex': 2,

        // disallow else after a return in an if
        'no-else-return': 2,

        // disallow use of eval()
        'no-eval': 2,

        // disallow adding to native types
        'no-extend-native': 2,

        // disallow unnecessary function binding
        'no-extra-bind': 2,

        // disallow fallthrough of case statements
        'no-fallthrough': [2, { "commentPattern": "falls through" }],

        // disallow the use of leading or trailing decimal points in numeric literals
        'no-floating-decimal': 2,

        // disallow use of eval()-like methods
        'no-implied-eval': 2,

        // disallow usage of __iterator__ property
        'no-iterator': 2,

        // disallow use of labeled statements
        'no-labels': 2,

        // disallow unnecessary nested blocks
        'no-lone-blocks': 2,

        // disallow creation of functions within loops
        'no-loop-func': 2,

        // disallow use of multiple spaces
        'no-multi-spaces': [2, { exceptions: { "VariableDeclarator": true } }],

        // disallow use of multiline strings
        'no-multi-str': 2,

        // disallow reassignments of native objects
        'no-native-reassign': 2,

        // disallow use of new operator for Function object
        'no-new-func': 2,

        // disallows creating new instances of String,Number, and Boolean
        'no-new-wrappers': 2,

        // disallow use of octal escape sequences in string literals, such as
        // var foo = 'Copyright \251';
        'no-octal-escape': 2,

        // disallow usage of __proto__ property
        'no-proto': 2,

        // disallow use of assignment in return statement
        'no-return-assign': 2,

        // disallow use of `javascript:` urls.
        'no-script-url': 2,

        // disallow comparisons where both sides are exactly the same
        'no-self-compare': 2,

        // disallow use of comma operator
        'no-sequences': 2,

        // restrict what can be thrown as an exception
        'no-throw-literal': 2,

        // disallow usage of expressions in statement position
        'no-unused-expressions': 2,

        // disallow unnecessary .call() and .apply()
        'no-useless-call': 2,

        // disallow use of void operator
        'no-void': 2,

        // disallow usage of configurable warning terms in comments: e.g. todo
        'no-warning-comments': [0, { 'terms': ['todo', 'fixme', 'xxx'], 'location': 'start' }],

        // disallow use of the with statement
        'no-with': 2,

        // require use of the second argument for parseInt()
        'radix': 2,

        // require immediate function invocation to be wrapped in parentheses
        'wrap-iife': [2, 'any'],

        // require or disallow Yoda conditions
        'yoda': 2,

        // VARIABLES
        // http://eslint.org/docs/rules/#variables

        // disallow shadowing of names such as arguments
        'no-shadow-restricted-names': 2,

        // disallow use of undefined when initializing variables
        'no-undef-init': 2,

        // disallow declaration of variables that are not used in the code
        'no-unused-vars': 2,

        // STYLE
        // http://eslint.org/docs/rules/#stylistic-issues

        // enforce spacing inside array brackets
        'array-bracket-spacing': [2, "never"],

        // disallow or enforce spaces inside of single line blocks
        'block-spacing': [2, "always"],

        // enforce one true brace style
        'brace-style': [2, '1tbs', {'allowSingleLine': true }],

        // enforce spacing before and after comma
        'comma-spacing': [2, {'before': false, 'after': true}],

        // enforce one true comma style
        'comma-style': [2, 'last'],
        'comma-dangle': 'error',

        // require or disallow padding inside computed properties
        'computed-property-spacing': [2, 'never'],

        // enforce newline at the end of file, with no multiple empty lines
        'eol-last': 2,

        // this option sets a specific tab width for your code
        'indent': [2, 4, {'SwitchCase': 1}],

        // specify whether double or single quotes should be used in JSX attributes
        'jsx-quotes': 2,

        // enforces spacing between keys and values in object literal properties
        'key-spacing': [2, {"beforeColon": false, "afterColon": true, "mode": "minimum"}],

        // disallow mixed 'LF' and 'CRLF' as linebreaks
        'linebreak-style': [2, "unix"],

        // specify the maximum depth callbacks can be nested
        'max-nested-callbacks': [2, 7],

        // require a capital letter for constructors
        'new-cap': [2, {'capIsNew': false, newIsCap: false}],

        // disallow the omission of parentheses when invoking a constructor with no arguments
        'new-parens': 2,

        // disallow use of the Array constructor
        'no-array-constructor': 2,

        // disallow if as the only statement in an else block
        'no-lonely-if': 2,

        // disallow multiple empty lines
        'no-multiple-empty-lines': [2, {'max': 2}],

        // disallow nested ternary expressions
        'no-nested-ternary': 2,

        // disallow use of the Object constructor
        'no-new-object': 2,

        // disallow space between function identifier and application
        'no-spaced-func': 2,

        // disallow trailing whitespace at the end of lines
        'no-trailing-spaces': 2,

        // disallow the use of Boolean literals in conditional expressions
        'no-unneeded-ternary': 2,

        // require or disallow padding inside curly braces
        'object-curly-spacing': [2, "always", {
            "objectsInObjects": true,
            "arraysInObjects": true
        }],

        // specify whether double or single quotes should be used
        'quotes': [2, 'single', 'avoid-escape'],

        // enforce spacing before and after semicolons
        'semi-spacing': [2, {'before': false, 'after': true}],

        // require or disallow use of semicolons instead of ASI
        'semi': [2, 'always'],

        // This rule will enforce consistency of spacing around keywords and keyword-like tokens
        'keyword-spacing': "error",

        // require or disallow space before blocks
        'space-before-blocks': 2,

        // require or disallow space before function opening parenthesis
        'space-before-function-paren': [2, {'anonymous': 'always', 'named': 'never'}],

        // require or disallow spaces inside parentheses
        'space-in-parens': [2, 'never'],

        // require spaces around operators
        'space-infix-ops': 2,

        // Require or disallow spaces before/after unary operators
        'space-unary-ops': 2
    }
}
