/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.build.utils;

import com.openexchange.build.utils.Definitions;
import java.util.regex.Matcher;

public class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final int revisionMajor;
    private final int revisionMinor;

    public Version(int major) {
        this(major, 0, 0);
    }

    public Version(int major, int minor, int patch) {
        this(major, minor, patch, 0);
    }

    public Version(int major, int minor, int patch, int revision) {
        this(major, minor, patch, revision, 0);
    }

    public Version(int major, int minor, int patch, int revisionMajor, int revisionMinor) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.revisionMajor = revisionMajor;
        this.revisionMinor = revisionMinor;
    }

    public static Version parse(String version) throws Exception {
        Matcher matcher = Definitions.VERSION_AND_REVISION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new Exception("Can not parse version: \"" + version + "\".");
        }
        if (null == matcher.group(2) && null == matcher.group(3) && null == matcher.group(4)) {
            return new Version(Integer.parseInt(matcher.group(1)));
        }
        if (null == matcher.group(4)) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)));
        }
        if (null == matcher.group(5)) {
            return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)));
        }
        return new Version(Integer.parseInt(matcher.group(1)), Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(3)), Integer.parseInt(matcher.group(4)), Integer.parseInt(matcher.group(5)));
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getRevisionMajor() {
        return this.revisionMajor;
    }

    public int getRevisionMinor() {
        return this.revisionMinor;
    }

    private void appendRevision(StringBuilder sb) {
        sb.append(this.revisionMajor);
        if (0 != this.revisionMinor) {
            sb.append('.');
            sb.append(this.revisionMinor);
        }
    }

    public String getVersionWithoutRevision() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.patch);
        return sb.toString();
    }

    public String getRevision() {
        StringBuilder sb = new StringBuilder();
        this.appendRevision(sb);
        return sb.toString();
    }

    @Override
    public int compareTo(Version o) {
        if (this.major != o.major) {
            return Integer.valueOf(this.major).compareTo(o.major);
        }
        if (this.minor != o.minor) {
            return Integer.valueOf(this.minor).compareTo(o.minor);
        }
        if (this.patch != o.patch) {
            return Integer.valueOf(this.patch).compareTo(o.patch);
        }
        if (this.revisionMajor != o.revisionMajor) {
            return Integer.valueOf(this.revisionMajor).compareTo(o.revisionMajor);
        }
        return Integer.valueOf(this.revisionMinor).compareTo(o.revisionMinor);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + this.revisionMajor;
        result = 31 * result + this.revisionMinor;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        if (this.patch != other.patch) {
            return false;
        }
        if (this.revisionMajor != other.revisionMajor) {
            return false;
        }
        return this.revisionMinor == other.revisionMinor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        sb.append('.');
        sb.append(this.minor);
        sb.append('.');
        sb.append(this.patch);
        sb.append('-');
        this.appendRevision(sb);
        return sb.toString();
    }
}

