/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Alexander Quast <alexander.quast@open-xchange.com>
 */

ox.gui.initToolBarNewWindowDistributionlist = function() {

    var $p = ox.gui.initToolBarNewWindow();
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Mail Window
         */
        "window_distributionlist": {
            "save": {
                title: _("Save"),
                icons: ["save.png"],
                big: true
            },
            "add": {
                title: _("Add from addressbook"),
                icons: ["member_add.png"],
                big: true
            },
            "custom": {
                title: _("Custom form"),
                icons: ["distributionlist_extcontact.png"],
                big: true
            },
            "delete": {
                title: _("Delete"),
                icons: ["member_remove.png"],
                selection: "contact",
                requires : ["some"],
                big: true
            },
            "editName": {
                title: _("Edit name"),
                selection: "contact",
                requires: function(ability, selection, cont) {
                    if (!ability.one) return false;
                    distruBigGrid.storage.newIterate(selection, emptyFunction,
                        function(i, data) { cont(data.external); });
                }
            },
            "editEmail": {
                title: _("Edit e-mail"),
                selection: "contact",
                requires: function(ability, selection, cont) {
                    if (!ability.one) return false;
                    distruBigGrid.storage.newIterate(selection, emptyFunction,
                        function(i, data) { cont(data.external); });
                }
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.distributionlist = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-distribution-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-distributionlist-main", _("&Distribution List")).addTo(toolbar);
    
    // Section 1, save distributionlist
    section = new ox.gui.PanelMenuSection(_("Distribution List")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_distributionlist, "contact_new", ["save"]);

    // Section 2, add/remove/custom contact
    section = new ox.gui.PanelMenuSection(_("Contact")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_distributionlist, "contact_new",
        ["add", "custom", "delete", "editName", "editEmail"]);
    
    // Section 3, cancel
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_distributionlist, "contact_new", ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    register("SubSelected", function() {
        ox.ToolBarController.processSelection("contact", false,
                distruBigGrid.selection.getSelected(), true);
    });
    
    // event mapping
    var events = {
        "contact_new-save" : "OX_SAVE_OBJECT",
        "contact_new-add" : "OX_Object_Distributionlist_Internal_Contact",
        "contact_new-custom" : "OX_Object_Distributionlist_External_Mail",
        "contact_new-delete" : "OX_Object_Distributionlist_Delete",
        "contact_new-editName": "OX_Object_Distributionlist_EditName",
        "contact_new-editEmail": "OX_Object_Distributionlist_EditEmail",
        "contact_new-cancel" : "OX_Cancel_Object"
    }
  
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function(id) {
        
        // regex matches
        var m;
        
        // defined by event?
        if (events[id] !== undefined) {
            // trigger
            triggerEvent(events[id]);
            return true;
        }
    });
    
    ox.desktop.validate();
    
    ox.ToolBarController.processSelection("contact", false, [], true);
    ox.ToolBarController.processSelection("default", false, [], true);
    setTimeout(function(){triggerEvent("SubSelected");}, 10);
};