/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 * 
 */

ox.gui.initConfigTree = function () {
	
	// register in global repository
	var configTree = ox.widgets.configTree = new ox.gui.Tree("ox-sidepanel-configuration").
	css({ padding: "10px 0px 10px 0px" }).
	addTo(ox.widgets.sidepanelViewControl);
	
	ox.widgets.sidepanelViews.configuration = configTree;
	
    configTree.showRootNode = false;
    
    configTree.customize = function (node) {
        var icon;
        if (node.data.innerNode) {
            node.selectable = false;
            icon = "/img/folder/settings_folder_" + (node.statusOpen ? "open.gif" : "closed.gif");
        } else {
            icon = "/img/folder/settings.gif";
        }
        return { src: ox.gui.themePath + icon, html: node.data.domNode || addTranslated(node.name) };
    };
    
    configTree.addListener("widget:select", function (event) {    	
        var data = this.nodeIndex[event.data].data;
        if (data.onClick) {
            data.onClick();
        } else {
            configuration_askforSave(function () {
                triggerEvent("OX_Switch_View", event.data);
            });
        }
    });
	
    // must initialize the config tree right now, since plugins might call for it
    configTree.setRootNode({ id: "configuration", name: "Configuration", /*i18n*/ innerNode: true });
    configTree.add({ parent: "configuration", id: "configuration/import", name: "Import" /*i18n*/ });
    configTree.add({ parent: "configuration", id: "configuration/settings", name: "Options" /*i18n*/ });
    configTree.add({ parent: "configuration", id: "configuration/tags", name: "Categories" /*i18n*/ });

    // Module Portal
    if (configGetKey("modules.portal.module")) {
        configTree.add({ parent: "configuration", id: "configuration/portal", name: "Start Page", /*i18n*/ innerNode: true });
        configTree.add({ parent: "configuration/portal", id: "configuration/portal/layout", name: "Layout" /*i18n*/ });
        if (ox.api.config.get("modules.uwaWidgets.enabled") === true) {
            configTree.add({ parent: "configuration/portal", id: "configuration/portal/external", name: "UWA Modules" /*i18n*/ });
        }
    }

    // Module Mail
    if (configGetKey("modules.mail.module") === true || configGetKey("modules.mail.module") !== null && configGetKey("modules.mailaccount.module")) {
        configTree.add({ parent: "configuration", id: "configuration/mail", name: "E-Mail", /*i18n*/ innerNode: true });
        if (configGetKey("modules.mail.module")) {
            configTree.add({ parent: "configuration/mail", id: "configuration/mail/preferences", name: "Preferences" /*i18n*/ });
            configTree.add({ parent: "configuration/mail", id: "configuration/mail/signatures", name: "Signatures" /*i18n*/ });
        }
    }

    // Module Calendar
    if (configGetKey("modules.calendar.module")) {
        configTree.add({ parent: "configuration", id: "configuration/calendar", name: "Calendar", /*i18n*/ innerNode: true });
        configTree.add({ parent: "configuration/calendar", id: "configuration/calendar/preferences", name: "Preferences" /*i18n*/ });
        if (configGetKey("modules.calendar.calendar_teamview")) {
            configTree.add({ parent: "configuration/calendar", id: "configuration/calendar/teams", name: "Teams" /*i18n*/ });
        }
    }

    // Module Contacts
    if (configGetKey("modules.contacts.module")) {
        configTree.add({ parent: "configuration", id: "configuration/contacts", name: "Contacts", /*i18n*/ innerNode: true });
        configTree.add({ parent: "configuration/contacts", id: "configuration/contacts/preferences", name: "Preferences" /*i18n*/ });
    }

    // Module Tasks
    if (configGetKey("modules.tasks.module")) {  
        configTree.add({ parent: "configuration", id: "configuration/tasks", name: "Tasks", /*i18n*/ innerNode: true });
        configTree.add({ parent: "configuration/tasks", id: "configuration/tasks/preferences", name: "Preferences" /*i18n*/ });
    }

    // Module InfoStore
    if (configGetKey("modules.infostore.module")) {
        configTree.add({ parent: "configuration", id: "configuration/infostore", name: "InfoStore", /*i18n*/ innerNode: true });
        configTree.add({ parent: "configuration/infostore", id: "configuration/infostore/preferences", name: "Preferences" /*i18n*/ });
    }
    
    configTree.selection.classSelected = "background-color-PMG-selection-elements";
    
};