/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 * @ignore
 */

// DEVELOPMENT IN PROGRESS // SUBJECT TO PERMANENT CHANGE!


ox.gui.StatefulContainer = ox.gui.Container.extend({
/** @lends ox.gui.StatefulContainer.prototype */
    
    getClass: function() { return "ox.gui.StatefulContainer"; },
    
    /** 
     * A container that manages its state.
     * @constructs
     * @extends ox.gui.Container
     * @param {String} id An optional unique id for the widget.
     */
    construct: function(id) {
        
        // call super class constructor (inherit from Container)
        this._super(this.autoId(id, "statContainer"));
        
        // local constructor
        this.currentState = "";
        this.currentChild = null;
        this.childIndex = {};
    },
    
    /**
     * Determines that state of the container.
     * @returns {String} A string representation of the current state.
     */
    getState: function() {
        var states = [], widget = this;
        // move down
        states = states.concat(this.getChildState(this));
        // move up
        while (widget) {
            // is a stateful container
            if (widget instanceof ox.gui.StatefulContainer && widget.currentState != "") {
                // add current
                states.push(widget.id + ":" + widget.currentState);
            }
            // climb up
            widget = widget.parent;
        }
        // return result
        return states.join(";");
    },
    
    /**
     * @private
     */
    getChildState: function(widget) {
        var states = [];
        if (widget instanceof ox.gui.Container || widget == ox.gui) {
            for (var i = 0; i < widget.children.length; i++) {
                var child = widget.children[i];
                if (child instanceof ox.gui.StatefulContainer && child.currentState != "") {
                    // add current
                    states.push(child.id + ":" + child.currentState);
                }
                states = states.concat(this.getChildState(child));
            }
        }
        return states;
    },
    
    /**
     * Sets the state of the container.
     * @param {String} A string representation of the new state.
     */
    setState: function(state) {
        var stateDescriptor = [];
        // is string?
        if (Object.isString(state)) {
            var pairs = state.split(';');
            for (var i = 0; i < pairs.length; i++) {
                var pair = pairs[i].split(':');
                var key = pair[0] || "", value = pair[1] || "";
                stateDescriptor[key.toLowerCase()] = value;
            }
        } else {
            stateDescriptor = state;
        }
        var lowerID = this.id.toLowerCase();
        if (stateDescriptor[lowerID] !== undefined) {
            this.currentState = stateDescriptor[lowerID];
            delete stateDescriptor[lowerID];
        }
        // loop children
        this.setStateRec(this, stateDescriptor);
    },
    
    /**
     * @private
     */
    setStateRec: function(widget, stateDescriptor) {
        // is container?
        if (widget instanceof ox.gui.Container || widget == ox.gui) {
            // loop children
            for (var i = 0; i < widget.children.length; i++) {
                var child = widget.children[i];
                // is a stateful container
                if (child instanceof ox.gui.StatefulContainer) {
                    child.setState(stateDescriptor);
                } else {
                    // recursion
                    this.setStateRec(child, stateDescriptor);
                }
            }
        }
    }
});
