/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

var UWAWidget = (function () {

    var NV_HOST = 'www.netvibes.com';
    var NV_PATH = '/';
    var NV_STATIC = '';
    var NV_MODULES = 'nvmodules.netvibes.com';

    var ifproxyUrl = location.href.replace(/ox\.html(.*)$/, "") + "proxy.html";
    
    var UWAWidget = function (parameters) {
        this.url_params = {};
        this.configuration = {    title : "UWA Widget",
                                height: "250px",
                                border: "0px",
                                color:    "#000000",
                                displayTitle: false,
                                displayFooter: false,
                                autoresize: false    };
        for (key in parameters) {
           this[key] = parameters[key];
        }
        if(typeof this.container === undefined) {
            triggerEvent('OX_New_Error', 2 ,"No container defined for one or more UWA widgets");
        }
        if(typeof this.moduleUrl === undefined) {
            triggerEvent('OX_New_Error', 2 ,"No URI defined for one or more UWA widgets");
        }    
        if(typeof this.id === undefined) {
            triggerEvent('OX_New_Error', 2 ,"No id defined for one or more UWA widgets");
        }          
        this.moduleId = this.id.replace(/\s/g, "_") + (new Date()).getTime();
        this.iframe;
        this.renderWidget();  
        this.updateLayout();
    };
    
    UWAWidget.prototype = {
    
        setConfiguration : function (oConfiguration){
            for(var sProp in oConfiguration) {
              this.configuration[sProp] = oConfiguration[sProp];
             }
            this.updateLayout();        
        },
        setBorderWidth : function (){
            
        },
        setBorder : function (){
            
        },
        setColor : function (){
            
        },
        setTitle : function (){
            
        },
        setHeight : function (sHeight){
            this.configuration.height = sHeight;
            this.updateLayout();
        },
        setCommUrl : function (){
            
        },
        setDatas : function (){
            
        },
        setPreferencesValues : function (url_params){
            this.url_params = url_params;
            this.updateIframeUrl();
        },
        diplayTitle : function (){
            
        },
        displayFooter : function (){
            
        },
        updateIframeUrl : function (){
            this.iframe.src = this.getIframeUrl();
        },
        getIframeUrl : function (){
            var sUrl = "";
            if (typeof this.standalone == "boolean" && this.standalone) {
                sUrl = this.moduleUrl;
            } else {
                sUrl = "http://" + NV_MODULES + "/widget/frame/?id=" + 
                this.moduleId + "&uwaUrl=" + encodeURIComponent(this.moduleUrl) + 
                "&ifproxyUrl=" + encodeURIComponent(ifproxyUrl);
            }
            if (this.url_params && this.url_params.length != 0) {
                for (var sParam in this.url_params) {
                    var param = this.url_params[sParam];
                    // take care of garbage
                    if (!param || typeof param !== "string" || isEmpty(trimStr(param))) {
                        continue;
                    }
                    sUrl += (sUrl.match("\\?") ? "&" : "?") + sParam + "=" + param.format();
                }
            }
            return sUrl;
        },
        updateLayout : function (){
            //this.iframe.style.height = this.configuration.height;
            this.iframe.style.border =  this.configuration.border;
            this.iframe.style.color = this.configuration.color;
            this.iframe.setAttribute('height', this.configuration.height);
            this.iframe.setAttribute('frameBorder', 0);
            this.iframe.setAttribute('scrolling', 'auto');
            this.iframe.style.width = '100%';
        },
        renderWidget : function (){
            this.iframe = newnode("iframe", 0, { src: this.getIframeUrl(), id: "frame_" + this.moduleId });
            this.container.appendChild(this.iframe);
        }
    };
    
    return UWAWidget;
    
}());