/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 *
 */

var hidetreeelements = {};
var menupluginelementtree = {};
var menupluginelementsavailable = {};

function MenuNodes() {}
MenuNodes.contexts = {};
MenuNodes.DYNAMIC=null;
MenuNodes.FIXED=null;
register("Loaded",function() {
    MenuNodes.DYNAMIC = {};
    MenuNodes.FIXED = {};
});

MenuNodes.Section = function(id, text, index, dynamic) {
    if (MenuNodes.Section.sections[id]) {
        return MenuNodes.Section.sections[id];
    }
    MenuNodes.Section.sections[id] = this;
    this.id = id;
    this.children = [];
    this.menu = MenuNodes.createSmallButtonContext(this.id, text,
        "MenuNodes.Section");
};
MenuNodes.Section.prototype.add = function(button) {
    this.children.push(button);
    button.addTo(this);
    this.update();
};
MenuNodes.Section.prototype.update = function() {
    if (this.menu.node.parent) this.menu.node.parent.validate();
};
MenuNodes.Section.prototype.show = function(view) {
    changeDisplay(view, this.id);
    if (   currentfullpath == view
        || String(currentfullpath).substring(0, view.length + 1) == view + "/")
    {
        this.update();
    }
};
MenuNodes.Section.prototype.hide = function(view) {
    changeDisplay(view, this.id, true);
};
MenuNodes.Section.update = function() {
    for (var i in MenuNodes.Section.sections) {
        MenuNodes.Section.sections[i].update();
    }
};
MenuNodes.Section.sections = {};

menuarrows["MenuNodes.Section"] = {};
register("OX_SELECTED_ITEMS_CHANGED", MenuNodes.Section.update);
register("OX_menu_Change_Height", MenuNodes.Section.update);
register("OX_Switched", MenuNodes.Section.update);

MenuNodes.Button = function(text) {
    this.text = text;
    var Self = this;
    this.click_cb = function() { if (Self.click) { Self.click(); } };
    this.disabledClick_cb = function() {
        if (Self.disabledClick) {
            Self.disabledClick();
        }
    };
};
MenuNodes.Button.prototype.addTo = function(section) {
    this.section = section;
    this.id = "MenuNodes.Button." + MenuNodes.Button.id++; 
    this.button = MenuNodes.createSmallButton(section.menu, this.id, this.text,
        MenuNodes.imageURL(this.icon), MenuNodes.imageURL(this.disabledIcon),
        this.click_cb, this.disabledClick_cb);
};
MenuNodes.Button.prototype.setEnabled = function(enabled) {
    this.button.setEnabled(Boolean(enabled));
};
MenuNodes.Button.prototype.getEnabled = function() {
    return this.button.isEnabled();
};
MenuNodes.Button.id = 0;
MenuNodes.imageURL = function(url) {
    if (url.charAt(0) == "/") {
        return urlify(url.substring(1));
    }
    return getFullImgSrc(url);
};

MenuNodes.undoTheme = function(path) {
    if (!MenuNodes.themeRegExp) {
        MenuNodes.themeRegExp = new RegExp("^" +
            escapeRegExp(getFullImgSrc("")) + "(.*)$");
    }
    return path.replace(MenuNodes.themeRegExp, "$1");
};

MenuNodes.createBigButtonContext = function (id, title, icon, action) {
    var section = new ox.gui.PanelMenuSection(title);
    var item = ox.widgets.toolBar.menuItems[id] = new ox.gui.MenuItem({
        id: id,
        title: title instanceof I18nString ? title : _(title),
        icons: [MenuNodes.undoTheme(icon)],
        big: true,
        action: action
    });
    section.add(item);
    return item;
};
MenuNodes.createSmallButtonContext = function(id, title, module) {
    if (MenuNodes.contexts[id]) return MenuNodes.contexts[id];
    return MenuNodes.contexts[id] =
        { node: new ox.gui.PanelMenuSection(title) };
};
MenuNodes.createSmallButton = function(context, id, title, icon, disabledIcon,
                                       action, disabled_action)
{
    var button = new ox.gui.MenuItem({
        id: id,
        title: title instanceof I18nString ? title : _(title),
        pathPrefix: MenuNodes.undoTheme(icon) == icon ? "" : undefined,
        icons: disabledIcon ? [MenuNodes.undoTheme(icon),
                               MenuNodes.undoTheme(disabledIcon)]
                            : [MenuNodes.undoTheme(icon)],
        action: function() {
            if (button.isEnabled()) {
                action.apply(this, arguments);
                return true; // action taken
            } else if (disabled_action) {
                disabled_action.apply(this, arguments);
                return true; // action taken
            } else {
                return false; // no action
            }
        }
    });
    context.node.add(button);
    return button;
};
addMenuNode = emptyFunction;

function menu_display_contents(module,modulecontent,enabled, id) {
    if (modulecontent in MenuNodes.contexts) {
        MenuNodes.contexts[modulecontent].node.each(function(button) {
            if (button.id == id) button.setEnabled(Boolean(enabled));
        });
        return;
    }
}

function addHideTreeNode(node, parent) {
    if (node && parent) {
        var tmpObject = {
            node: node,
            parent: parent
        };
        hidetreeelements[node.id] = tmpObject;
        try {
            parent.removeChild(node);
        } catch (e) {
            // pssst
        }
    } else {
        if (debug) {
            console.error("addHideTreeNode(node, parent). Empty parameter! ", node, parent);
        }
    }
}
function appendNode(id,cd2) {
    var mynode =hidetreeelements[id];
    if(mynode) {
        if(!menupluginelementsavailable[id]) {
            mynode.parent.appendChild(mynode.node);    
        } else {
            var nodeafter=null;
            for(var i=0;i<mynode.parent.childNodes.length;i++) {
                nodeafter=mynode.parent.childNodes[i];
                if(nodeafter.nodeType==1) {
                    if(nodeafter.id) {
                        if(menupluginelementsavailable[nodeafter.id] && menupluginelementsavailable[nodeafter.id].index !== undefined) {
                            if(mynode.index<=menupluginelementsavailable[nodeafter.id].index) { break; }
                        } else { break; }
                    } else { break; }
                }
            }
            mynode.parent.insertBefore(mynode.node,nodeafter);
        }
        if(!cd2 && (mynode.node.style.display=="none" || mynode.node.style.display=="NONE")) {
            if(mynode.node.tagName == "DIV") { mynode.node.style.display = "block"; }
            else { mynode.node.style.display = ""; }
        }
    } else if ($ALL(id)) {
        if(!cd2 && ($ALL(id).style.display=="none" || $ALL(id).style.display=="NONE")) {
            if($ALL(id).tagName == "DIV") { $ALL(id).style.display = "block"; }
            else { $ALL(id).style.display = ""; }
        }
    }
    refillImages(id);
}
function refillImages(id) {
    if($ALL(id)) {
        var elements=$ALL(id).getElementsByTagName("img");
        for(var i=0;i<elements.length;i++) {
            //if(init.images[elements[i].id] && init.images[elements[i].id] != elements[i].src && (!elements[i].src || elements[i].src.match(/img\/dummy.gif/))) {
            if(init.images[elements[i].id] && init.images[elements[i].id] != elements[i].src) {
                elements[i].src=init.images[elements[i].id];
            }
        }
    }
}
function removeNode(id,cd2) {
    var mynode =hidetreeelements[id];
    if(mynode) { 
        try {
            mynode.parent.removeChild(mynode.node);
            if(!cd2 && (mynode.node.style.display!="none" || mynode.node.style.display!="NONE")) {
                mynode.node.style.display = "none";
            }    
        } catch (e) {}
    } else if ($ALL(id)) {
        if(!cd2 && ($ALL(id).style.display!="none" || $ALL(id).style.display!="NONE")) {
            $ALL(id).style.display = "none"; 
        }
    }
}
function showNode(id,changedisplay) {
    appendNode(id,changedisplay);
}
function hideNode(id,changedisplay) {
    removeNode(id,changedisplay);
}
function rebuildTree() {
    // vars
    var contentArea = $("contentarea"),
        configComplete = $("configComplete"),
        everything = $("everything");
    
    addHideTreeNode(everything, $("testit3333"));
    addHideTreeNode($("portal"), contentArea);
    
    if (configGetKey("modules.mail.module")) {
        addHideTreeNode($("mail.list"), contentArea);
        addHideTreeNode($("mail.hsplit"), contentArea);
        addHideTreeNode($("mail.vsplit"), contentArea);
    }
    if (configGetKey("modules.calendar.module")) {
        addHideTreeNode($("calendarTeamDay"), contentArea);
        addHideTreeNode($("calendarWorkweek"), contentArea);
        addHideTreeNode($("calendarWeek"), contentArea);
        addHideTreeNode($("calendarMonth"), contentArea);
        addHideTreeNode($("calendarAppointmentDetail"), contentArea);
        addHideTreeNode($("calendarList"), contentArea);
    }
    if (configGetKey("modules.contacts.module")) {
        addHideTreeNode($("contacts"), contentArea);
        addHideTreeNode($("contactCards"), contentArea);
        addHideTreeNode($("contactsList"), contentArea);
        addHideTreeNode($("contactDetails"), contentArea);
    }
    if (configGetKey("modules.infostore.module")) {
        addHideTreeNode($("infostore_list"), contentArea);
        addHideTreeNode($("infostore_split"), contentArea);
    }
    if (configGetKey("modules.tasks.module")) {
        addHideTreeNode($("taskslist"), contentArea);
        addHideTreeNode($("taskssplit"), contentArea);
    }
    if (configGetKey("modules.messaging.module")) {
        addHideTreeNode($("messaging"), contentArea);
    }
    addHideTreeNode($("folder_props"), contentArea);
    addHideTreeNode($("config"), configComplete);
    addHideTreeNode($("config_tags"), configComplete);
    addHideTreeNode($("config_import"), configComplete);
    addHideTreeNode($("config_calendar_team"), configComplete);
    addHideTreeNode($("config_calendar"), configComplete);
    addHideTreeNode($("config_contact"), configComplete);
    addHideTreeNode($("config_infostore"), configComplete);
    addHideTreeNode($("config_mail_signatures"), configComplete);
    addHideTreeNode($("config_mail"), configComplete);
    addHideTreeNode($("config_portal"), configComplete);
    addHideTreeNode($("config_tasks"), configComplete);
    addHideTreeNode($("modal-dialog"), everything);
    addHideTreeNode($("disable_confirm_window"), $("modal-dialog"));
    addHideTreeNode($("alert_window"), $("disable_confirm_window"));
    addHideTreeNode($("create_window"), $("disable_confirm_window"));
    addHideTreeNode($("conflict_window"), $("disable_confirm_window"));
    addHideTreeNode($("rightshandling_window"), $("modal-dialog"));
    addHideTreeNode($("acceptdeny_object"), everything);
    addHideTreeNode($("global_about"), $("modal-dialog"));
    addHideTreeNode($("subscribe_folder"), $("modal-dialog"));
    addHideTreeNode($("floatingdivParticipants"), everything);
    addHideTreeNode($("reminderWindow"), everything);
    
    autorefill();
}
function autorefill() {    
    showNode("menu_options_menu");
    showNode("configComplete");
}
function changeImgPath(newPath) {
    for (var i in init.images) {
        init.images[i] = init.images[i].replace(/\/default\//g, "/"+newPath+"/");
    }
}
register("Loaded",rebuildTree);