/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Stefan Preuss <stefan.preuss@open-xchange.com>
 *
 */

register("Loaded", function() {
    var menu = globalContextMenus.attachments = new ContextMenu();
    var open = new MenuItem(_("Open"), function() {
        triggerEvent(menunestedmessage ? "OX_Attachment_Open_Nested"
                                       : "OX_Attachment_Open");
    });
    open.setIcon("img/menu/attachment_open.gif",
                 "img/menu/attachment_open_d.gif");
    menu.addItem(open);
    
    var save = new MenuItem(_("Save as"),
        function() { triggerEvent('OX_Attachment_Save'); });
    save.setIcon("img/menu/attachment_save.gif",
                 "img/menu/attachment_save_d.gif");
    menu.addItem(save);

    // save in infostore
    var info = new MenuItem(_("Save in InfoStore"),
        function() { triggerEvent('OX_Attachment_SaveInfoStore'); });
    info.setIcon("img/infostore/infostore_save.gif",
                 "img/infostore/infostore_save_d.gif");
    info.disabled_action = function() {
        if (configGetKey("modules.infostore.module")) return false;
        triggerEvent("Feature_Not_Available", "modules/infostore/mail/save_to_infostore", window);
    };
    menu.addItem(info);
    
    menu.onShow = function() {
        var enabled = !menudisableattachment;
        open.setEnabled(enabled);
        save.setEnabled(!menudisableattachment && 
                (activemodule == "mail" || activemodule == "mail_detail"));
        info.setEnabled(enabled && configGetKey("modules.infostore.module"));
        info.setVisible(corewindow.ox.upsell.isVisible("infostore"));
    };
    
    ox.api.window.core.triggerEvent("OX_Context_Menu_Ready", window);
});

var mail_message, selectedAttachments = [];

function showIcalVcard(selAttach) { 
    var isIcal = true;
    if (isVcard(selAttach.content_type)) {
        var ds = "com.openexchange.mail.vcard";
        var dh = { identifier: "com.openexchange.contact.json", args: [] };
        isIcal = false;
    } else {
        var ds = "com.openexchange.mail.ical";
        var dh = { identifier: "com.openexchange.ical.json", args: [] };
    }
    var myObject = { datasource: { args: [
        { "com.openexchange.mail.conversion.fullname": mail_message.folder_id },
        { "com.openexchange.mail.conversion.mailid": mail_message.id },
        { "com.openexchange.mail.conversion.sequenceid": selAttach.id } 
    ], identifier: ds }, datahandler: dh };

    (new JSONX()).put(AjaxRoot + "/conversion?action=convert&session=" +
        session, myObject, null,
        function (reply) {
            if (!isIcal) {
                var data = reply.data[0];
                if (data.mark_as_distributionlist === true) {
                    // open distribution list
                	ox.api.contact.composeDistributionList({
                		data: data
                	});
                } else {
                 // open contact
                    ox.api.contact.compose({
                        data: data
                    });
                }
            } else {
            	// open appointment
            	var data = {
            		oFromMail: reply.data[0],
                    sFromModule: "calendar"
            	};
            	ox.api.calendar.compose({
        			data: data
        		});
            }      
        }
    );
}

function isIcal(ct) {
    return corewindow.ox.upsell.isVisible("calendar") && ct && ct.match(/text\/(x\-)?(calendar|ical)/i); // || ct.match(/application\/(ics)/i);
}
function isVcard(ct) {
    return corewindow.ox.upsell.isVisible("contacts") && ct && ct.match(/text\/(x\-)?(vcard|directory)/i);
}

function createNewContactfromMail(mailAddressObject,folder) {
	function createContact(module,notneeded,object) {
		// open compose dialog with prefilled fields
		ox.api.contact.compose({
			params: jQuery.extend(object || {}, {
				folder: object.folder_id
			})
		});
//		var addParams = "";
//		for (i in object) {
//			addParams += "&"+i+"="+encodeURIComponent(object[i]);
//		}
//		corewindow.openContactPopup('modul=new&folder='+object.folder_id+addParams,'newContact.html');
	}
    corewindow.rightshandler.checkRights("contacts",(folder || configGetKey("folder.contacts")),mailAddressObject,createContact);
}

/**
 * Parse all <a> links within the node and replace any direct link which maches
 * to the current hostname with a new link to the local infostore.
 * @param ih The document node
 */
var hrefregexp = null;
function parseDirectLinksInMails(ih) {
    if (hrefregexp === null) {
        hrefregexp= new RegExp((window.location.protocol+"//"+window.location.host).replace(/^https?:/, "https?:"));
        if (ox.api.config.get("ui.mail.directlinkregexp") != null) {
            hrefregexp= new RegExp(ox.api.config.get("ui.mail.directlinkregexp").format());
        }
    }
    
    if (IE === 7) {
        // IE7 is a load of sh..
        // @todo: remove as soon as IE7 support has been canceled
        // Have to use the old way because IE7 obviously has a problem using replaceWith
        // in combination with jQuery objects :(
        var ahref = ih.getElementsByTagName("a");
        for (var i=0; i < ahref.length;) {
            var link = ahref[i];        
            if (!link.getAttribute("href")) {
                // no valid href, continue
                i++; 
                continue;
            }
            link.removeAttribute("target");  // clean-up target first
            var module = link.href.match(/[#&]m=([^#&]+)/);
            var folder = link.href.match(/[#&]f=([^#&]+)/);
            var id = link.href.match(/[#&]i=([^#&]+)/);
            if (link.href.match(hrefregexp) && module && folder) {
                // ok, seems like we found a direct link pointing to the right ox 
                link.parentNode.insertBefore(newnode("img", { marginRight: "5px"}, 
                        { src: getFullImgSrc("img/menu/close_linking.gif"), align: "absmiddle"},
                        null, (ih.nodeType == 9 ? ih : null)), link);
                link.parentNode.insertBefore(newnode("img", { marginRight: "5px"}, 
                        { src: getFullImgSrc("icons/16/" + module[1] + ".png"), align: "absmiddle"},
                        null, (ih.nodeType == 9 ? ih : null)), link);
                link.style.color="red";
                link.style.textDecoration="underline";
                link.style.cursor="pointer";
                link.removeAttribute("href");
                jQuery(link).text(_("Follow Link...").toString());
                link.onclick = (function(mo, fo, io) {
                         return function(e) { 
                             parent.corewindow.setTimeout(function() { 
                                parent.corewindow.triggerEvent("OX_Direct_Linking", mo, {"folder": fo, "id": io});
                             }, 0);
                             if (e) {
                                stopEvent(e);
                             }
                             return false;
                         }
                     })(module[1], folder[1], id && id[1] ? id[1] : null);  
                              
            } else if (link.getAttribute("href").match(new RegExp("^(" + window.location.href + ")?#")) != null) {
                link.setAttribute("onclick", "return false");
                // due to an mozilla bug we run into problems with anchors in dynamic written pages 
                // mozilla doesn't recognize that and try to load the whole page instead
                // using this hack to jump to the anchors manually
                for (var ia=0; ia < ih.anchors.length; ia++) {
                    if (link.getAttribute("href").match(new RegExp("^(" + window.location.href + ")?#"+ih.anchors[ia].name))) {
                        link.onclick = (function(myDoc, myAnchor) {
                            return function(e) {
                                 myAnchor.scrollIntoView(true);
                                 return false;
                            };
                        })(ih, ih.anchors[ia]);
                        break;
                    }
                }
            } else {
                // any other links should always open in a new window
                link.target = "_blank";
            }
          i++;
        }
        
    } else {
        // the preferred way working with
        // every other smart browser :-)
        jQuery("a[href]", ih).each(function(index) {
            var link = jQuery(this);
            
            var href = link.attr("href");
            var module = href.match(/[#&]m=([^#&]+)/);
            var folder = href.match(/[#&]f=([^#&]+)/);
            var id = href.match(/[#&]i=([^#&]+)/);
            if (href.match(hrefregexp) && module && folder) {
                var object = { module: module[1], folder: folder[1], id: (id && id.length ? id[1] : null) };
                if (object.module === "task") {
                    object.module = "tasks";
                }
                link.replaceWith(
                        jQuery("<div/>").css({
                            color: "red",
                            textDecoration: "underline",
                            padding: "5px 20px 5px 5px",
                            display: "inline-block",
                            cursor: "pointer",
                            border: "1px solid silver",
                            MozBorderRadius: "5px",
                            WebkitBorderRadius: "5px",
                            borderRadius: "5px 5px 5px 5px"
                        }).append(
                                jQuery("<img/>")
                                .attr({ src: getFullImgSrc("img/menu/close_linking.gif"), align: "absmiddle" })
                                .css({ paddingRight: "10px" })
                        ).append(
                                jQuery("<img/>")
                                .attr({ src: getFullImgSrc("icons/16/" + object.module + ".png"), align: "absmiddle" })
                                .css({ paddingRight: "5px" })
                        ).append(
                                jQuery("<span/>").text(_("Follow Link...").toString())
                        ).click(
                                function () {
                                    parent.corewindow.triggerEvent("OX_Direct_Linking", 
                                            object.module, { "folder": object.folder, "id": object.id });
                                }
                        )
                );
                link.removeAttr("target");
                
            } else if (href.match(new RegExp("^(" + window.location.href + ")?#")) != null) {
                var foundAnchor = false;
                // due to an mozilla bug we run into problems with anchors in dynamic written pages 
                // mozilla doesn't recognize that and try to load the whole page instead
                // using this hack to jump to the anchors manually
                jQuery.each(ih.anchors, function(index, anchor) {
                    if (href.match(new RegExp("^(" + window.location.href + ")?#" + anchor.name))) {
                        foundAnchor = true;
                        link.bind("click", { anchor: anchor }, function(e) {
                            e.data.anchor.scrollIntoView(true);
                            return false;
                        });
                    }
                });
                if (!foundAnchor) {
                    link.bind("click", function (e) { return false; });
                }
            } else if ((href.match(/^mailto:(.+)/) || []).length === 2) {
                var params = href.match(/^mailto:(.+)/)[1];
                var obj = { to: params.split("?")[0] };
                if (params.split("?").length > 1) {
                    obj = jQuery.extend(obj, ox.util.deserialize(params.split("?")[1]));
                    if (obj.body) {
                        obj.mailtext = obj.body.replace("\r\n", "<br>");
                        delete obj.body;
                    }
                }
                link.bind("click", { data: obj }, function(e) {
                    ox.api.mail.compose( { data: e.data.data });
                    return false;
                });
            } else {
                link.attr("target", "_blank");
            };
        });
    }

	corewindow.triggerEvent("ProcessMailContent", ih);
	return ih;
}

function getMailAccountIdByFolder(folder) {	
	var addr = null;
	if (String(folder).match(/^default(\d+)?/) != null) {
		var t = String(folder).match(/^default(\d+)?/)[0];
		addr = t.substring("default".length, t.length);
	}
	return addr;
}

function getMailAccountEmailAddress(id) {
	var addr = null, data;
	if ((data = ox.api.account.get(id))) {
		addr = data.primary_address;
	}
	return addr;
}

ox.mail.itip = {
    options: {
        // shown as
        n_shownAs: [ _("Booked"), _("Tentative"), _("Absent on business"),
                     //#. appointment availability
                     _("Free") ],
        n_shownAsClass: [ "reserved", "temporary", "absent", "free" ],
        n_confirm: ["", "\u2713", "x", "?"],
        n_confirmClass: ["", "accepted", "declined", "tentative"],
        parseRegExp: /;\s*method\s*=\s*(?:([-!#-'*+.0-9A-Z^-~]*)|"([\cA-\b\cK\cL\cN-\x1f!#-[\]-\x7f]*)")/i
    },
    parseMessage: function(options) {
        
        var message = options.message,
            cb = options.callback,
            iMIPAttachments = (message.attachments_html
                    || message.attachments_html_noimage || message.attachments_plain);
        ox.mail.itip.msgctx = message.folder_id + "." + message.id;
        if (iMIPAttachments && corewindow.ox.upsell.isVisible("calendar")) {
            var imipObject = {};
            var join = new Join(function() {
                if (ox.mail.itip.msgctx === message.folder_id + "." + message.id) {
                    ox.mail.itip.msgctx = undefined;
                    cb(isEmpty(imipObject) ? undefined : imipObject);
                }
                ox.mail.itip.msgctx = undefined;
            });
            var last = join.add();
            
            function analyze(iMIPAttachment) {
                (new JSONX()).put(
                    AjaxRoot + "/calendar/itip?action=analyze&dataSource=com.openexchange.mail.ical&descriptionFormat=html&session=" + session,
                    { "com.openexchange.mail.conversion.fullname": message.folder_id ,
                     "com.openexchange.mail.conversion.mailid": message.id,
                     "com.openexchange.mail.conversion.sequenceid": iMIPAttachment.id
                    }, 
                    null,
                    join.add(function(reply) {
                        if (reply && reply.data.length) {
                            if (("annotations" in reply.data[0]) 
                                    && !("appointment" in reply.data[0].annotations)) {
                                // todo: more than one messages are possible!!!
                                options.message.imipWarnings = [ reply.data[0].annotations[0].message ];
                            } else {
                                imipObject.iMIPAttachment = iMIPAttachment;
                                imipObject.data = reply.data;
                                imipObject.message = message;
                            }
                        }
                    }),
                    join.alt(function(reply) {
                        // ignore errors
                        return true;
                    })
                );
            }
            
            // check for imip / itip attachment
            for (var i = 0; i < iMIPAttachments.length; i++) {
                var match = ox.mail.itip.options.parseRegExp.exec(iMIPAttachments[i].content_type);
                if (match) {
                    analyze(iMIPAttachments[i]);
                    break;
                }
            }
            
            last();
        } else {
            ox.mail.itip.msgctx = undefined;
            cb();
        }
    },
    
    paint: function(options) {
        var node = options.node.empty();
        var data = options.data[0];
        var message = options.message;
        var iMIPAttachment = options.iMIPAttachment;
        
        function getDateInterval(data) {
            var length = (data.end_date - data.start_date) / 864e5 >> 0;
            if (data.full_time && length > 1) {
                // \u2013= &ndash;
                return formatDate(data.start_date, "date") + " \u2013 " + formatDate(data.end_date - 1, "date");
            } else {
                return formatDate(data.start_date, "date");
            }
        }
        
        function getTimeInterval(data) {
            var length;
            if (data.full_time) {
                length = (data.end_date - data.start_date) / 864e5 >> 0;
                return length <= 1 ? "Whole day" : length + " days";
            } else {
                return formatDate(data.start_date, "time") + " \u2013 " + formatDate(data.end_date, "time");
            }
        }
        
        function getRecurrenceString(data) {
            var tmp = new SeriesObject(data, true);
            var recurrenceString = tmp.getSeriesString();
            return getDateInterval(data)  + (recurrenceString != "" ? " \u2013 " + recurrenceString : "");
        }
        
        function getNote(data) {
            return jQuery.trim(data.note || "")
                .replace(/\n{3,}/g, "\n\n")
                .replace(/</g, "&lt;")
                .replace(/(https?\:\/\/\S+)/g, '<a href="$1" target="_blank">$1</a>');
        }
        
        function getConfirmations (data) {
            var hash = {};
            // internal users
            jQuery.each(data.users || [], function (i, obj) {
                hash[String(obj.id)] = {
                    status: obj.confirmation || 0,
                    comment: obj.confirmmessage || ""
                };
            });
            // external users
            jQuery.each(data.confirmations || [], function (i, obj) {
                hash[obj.mail] = {
                    status: obj.status || 0,
                    comment: obj.confirmmessage || ""
                };
            });
            return hash;
        }
        
        function getConfirmationSymbol(status) {
            return ox.mail.itip.options.n_confirm[status || 0];
        }
        function getConfirmationClass(status) {
            return ox.mail.itip.options.n_confirmClass[status || 0];
        }
        
        function getShownAsClass(data) {
            return ox.mail.itip.options.n_shownAsClass[(data.shown_as || 1) - 1];
        }
        
        function getShownAs(data) {
            return ox.mail.itip.options.n_shownAs[(data.shown_as || 1) - 1];
        }
        
        var actions = { };
        for (var i=data.actions.length; i >= 0; i--) {
            var action = data.actions[i];
            switch(action) {
                case "accept":
                    actions["accept"] = _("Accept");
                    break;
                case "decline":
                    actions["decline"] = _("Decline");
                    break;
                case "tentative":
                    actions["tentative"] = _("Tentative");
                    break;
                case "delete":
                    actions["delete"] = _("Delete");
                    break;
                case "create":
                    actions["create"] = _("Create");
                    break;
                case "update":
                    actions["update"] = _("Update");
                    break;
                case "accept_party_crasher":
                    actions["accept_party_crasher"] = _("Accept extra participant");
                    break;
                case "accept_and_replace":
                    actions["accept_and_replace"] = _("Accept and replace exception");
                    break;
                case "accept_and_ignore_conflicts":
                    actions["accept_and_ignore_conflicts"] = _("Accept and ignore conflicts");
                    break;
                case "refresh":
                    actions["refresh"] = _("Ask for new invitation");
                    break;
                case "send_appointment":
                    actions["send_appointment"] = _("Invite again");
                    break;
                case "declinecounter":
                    actions["declinecounter"] = _("Decline counter proposal");
                    break;
            }
        }
        var actual = {};
        if (data.annotations) {
            // it's a 
            actual = data.annotations[0].appointment;
        } else if (data.changes[0].deletedAppointment) {
            // it's a deletion
            actual = data.changes[0].deletedAppointment;
        } else {
            // new or changed
            actual = data.changes[0].newAppointment;
        }
        
        // append introduction
        if ((data.changes || [[]])[0].introduction) {
            node.append(
                jQuery("<div>").addClass("changes")
                .css({ marginTop: 0 })
                .html(data.changes[0].introduction)
            );
        }
        
        node.append(
            jQuery("<div>").addClass("date")
            .append(
                jQuery("<div>").addClass("interval").text(getTimeInterval(actual))
            ).append(
                jQuery("<div>").addClass("day").text(getRecurrenceString(actual))
            )
        ).append(
            jQuery("<div>").addClass("title clear-title").text(actual.title || "")
        ).append(
            jQuery("<div>").addClass("location").text(actual.location || "\u00A0")
        ).append(
            function(index, html) {
                try {
                    var node = jQuery("<div>").addClass("actions");
                    jQuery.each(actions, function(idx, action) {
                        var tmp = jQuery("<a>")
                            .attr({ href: "#" })
                            .addClass("action link")
                            .text(action.toString())
                            .click(function(e) {
                                (new JSONX()).put(AjaxRoot + "/calendar/itip?action=" + idx 
                                        + "&dataSource=com.openexchange.mail.ical&session=" + session,
                                    { "com.openexchange.mail.conversion.fullname": message.folder_id ,
                                      "com.openexchange.mail.conversion.mailid": message.id,
                                      "com.openexchange.mail.conversion.sequenceid": iMIPAttachment.id
                                    }, 
                                    null, 
                                    function(data) {
                                        // remove message if deletion was ok
                                        if (data) {
                                            //deleteMails(message.folder_id, [ message ]);
                                            
                                            //#. Status message will be shown when the confirmation status has been saved
                                            //#. after clicking on any confirmation button in an itip mail
                                            ox.UINotifier.ok(_("Confirmation status has been saved."));
                                        }
                                    }
                                );
                                return false;
                            });
                        node.append(tmp);
                        delete(tmp);
                    });
                    return node;
                } catch (e) {
                    // ignore
                } finally {
                    delete(node);
                }
            }
        ).append(
            function(index, html) {
                try {
                    var node = jQuery();
                    if (data.changes[0].diffDescription) {
                        node = jQuery("<div>").addClass("changes");
                        jQuery.each(data.changes[0].diffDescription, function(index, diff) {
                            node.append(jQuery("<div>").addClass("change").html(diff));
                        });
                    }
                    return node;
                } catch (e) {
                    // ignore
                } finally {
                    delete(node);
                }
            }
        ).append(
            jQuery("<div>").addClass("note").html(getNote(actual))
        ).append(
            function(index, html) {
                
                // iterate through participants
                function drawParticipant(obj, hash) {
                    // initialize vars
                    var key = obj.mail || obj.id,
                        conf = hash[key] || { status: 0, comment: "" },
                        confirm = getConfirmationSymbol(conf.status),
                        statusClass = getConfirmationClass(conf.status),
                        isPerson = hash[key] || obj.folder_id,
                        personClass = isPerson ? "person" : "",
                        display_name, name, node, name_lc,
                        mail_lc = String(obj.mail).toLowerCase();
                    // external participant?
                    if (obj.type === 5) {
                        // beautify
                        name_lc = String(obj.display_name).toLowerCase();
                        if (name_lc === mail_lc) {
                            name = display_name = mail_lc;
                        } else {
                            name = obj.display_name ? obj.display_name + " <" + mail_lc + ">" : mail_lc;
                            display_name = obj.display_name || mail_lc;
                        }
                    } else {
                        name = display_name = obj.display_name || String(obj.mail).toLowerCase();
                    }
                    node = jQuery("<div>").addClass("participant")
                        .append(jQuery("<span>").addClass(personClass).text(name))
                        .append(jQuery("<span>").addClass("status " + statusClass).text(" " + confirm));
                    // has confirmation comment?
                    if (conf.comment !== "") {
                        node.append(jQuery("<span>").addClass("comment").text(conf.comment));
                    }
                    return node;
                }
                
                var list = actual.participants || [], i = list.length,
                    participants = i > 1 ? jQuery("<div>").addClass("participants") : jQuery(),
                    confirmations = {};

                // has more than one participant?
                if (i > 1) {
                    confirmations = getConfirmations(actual);
                    
                    var solvedUsers = (function () {
                        var tmp = { external: [], internal: [] };
                        jQuery.each(list, function(i, obj) {
                            tmp[ obj.type === 5 ? "external" : "internal" ].push(obj);
                        });
                        return tmp;
                    })();
                    
                    function draw(users) {
                        // Evil :( Map cache result to internal object
                        for (var i in users) {
                            var user = users[i];
                            for (var ia=0; ia < (solvedUsers.internal || []).length; ia++) {
                                var comp = user.type + "." + (user.mail || user.id);
                                var user2 = solvedUsers.internal[ia];
                                if (user2.type + "." + (user2.mail || user2.id) === comp) {
                                    if (user.display_name) {
                                        user2.display_name = user.display_name;
                                    }
                                    if (user.email1 && user.type !== 1) {
                                        user2.mail = user.email1;
                                    }
                                }
                            }
                        }
                        
                        participants.append(jQuery("<div>")
                                .addClass("label").text("Participants"));
    
                        var plist = jQuery("<div>").addClass("participant-list").appendTo(participants);
                        
                        // internal users
                        jQuery.each(solvedUsers.internal, function(idx, obj) {
                            if (obj.type === 1) {
                                plist.append(drawParticipant(obj, confirmations));
                            }
                        });
                        
                        // external users
                        jQuery.each(solvedUsers.external, function(idx, obj) {
                            plist.append(drawParticipant(obj, confirmations));
                        });
                        
                        // groups
//                        jQuery.each(solvedUsers.internal, function(idx, obj) {
//                            if (obj.type === 2) {
//                                plist.append(drawParticipant(obj, confirmations));
//                            }
//                        });
                        
                        // internal users
                        jQuery.each(solvedUsers.internal, function(idx, obj) {
                            if (obj.type === 3) {
                                plist.append(drawParticipant(obj, confirmations));
                            }
                        });
                        
                    }
                   
                    internalCache.getObjects(solvedUsers.internal || [], draw);
                    return participants;
                }
            }
        ).append(
            function(index, html) {
                try {
                    var details = jQuery("<div>")
                        .append(
                            jQuery("<div>").addClass("label").text("Details")
                        ).append(
                                jQuery("<span>").addClass("detail-label").text(_("Show as").toString() + ":\u00A0")
                        ).append(
                            jQuery("<span>").addClass("detail shown_as " + getShownAsClass(actual)).text("\u00A0")
                        ).append(
                            jQuery("<span>").addClass("detail shown_as_label " + getShownAsClass(actual)).text(" " + getShownAs(actual))
                        ).append(
                                jQuery("<br>")
                        ).append(
                            function(index, html) {
                                try {
                                    var node = jQuery();
                                    var text = jQuery();
                                    if (actual.creation_date) {
                                        node = jQuery("<div>").append(
                                            jQuery("<span>").addClass("detail-label").text(_("Created").toString() + ":\u00A0")
                                        ).append(
                                            text = jQuery("<span>").addClass("detail").text(formatDate(actual.creation_date, "datetime").toString())
                                        );
                                        if (actual.created_by) {
                                            internalCache.getUsers([ actual.created_by  ], function(data) {
                                                text.text(text.text() + " - "  + data[ actual.created_by ].display_name);
                                            });
                                        }
                                    }
                                    return node;
                                } catch (e) { 
                                    // ignore
                                } finally {
                                    delete(node);
                                    delete(text);
                                }
                            }
                        );
                    return details;
                } catch (e) {
                    // ignore
                } finally{
                    delete(details);
                }
            }
        );
        
        if (options.success) {
            options.success();
        }
        
        // clean-up
        delete(iMIPAttachment);
        delete(message);
        delete(data);
        delete(node);
    }
};


fileloaded();