/**
 *
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 *
 */

// shortcuts
var Tour = ox.api.help.Tour;

// ----------------------------------------------------

Tour.register({ id: "OX6intro", title: _("Quick Tour"), src: "ox6tour.js", plugin: NAME });

//----------------------------------------------------

/*
 * Add to help menu
 */
register("Ready", function() {
    // call tour manager
    triggerEvent("ToursDefined");
    // funny cross check for other plugin
    if (ox.api.config.get(["modules", "com.openexchange.help", "module"], false) === false) {
        // add tours to help menu
        var menu = globalContextMenus.help;
        // loop
        jQuery.each(Tour.list(), function (id, tour) {
            menu.addItem(new MenuItem(tour.title, function () {
                Tour.load(id);
            }));
        });
    }
    // start intro tour on first start (only if configured to do so)
    if (ox.api.config.get("gui.wizard.firstrun") !== false) {
      ox.JSON.get(AjaxRoot + "/config/ui/introtour/startOnFirstRun/?session=" + session,
        function(reply) {
          if (reply != null) {
            if (reply.data == true) {
              Tour.load("OX6intro");
              ox.api.config.set("gui.wizard.firstrun", false);
            }
          }
        });
    }
});

register("OX_WIZARD_OPEN", function() {
    // close tour
    Tour.instances["OX6intro"].stop();
});

