/**
 * Returns the currently selected contacts.
 * @type Array
 * @return An array of contact IDs as used by OXCache.newRequest()
 */
function getContacts() {
    if (currentpath2[1] == "cards") return contactsSelection2.getSelected();
    if (contactGrid) return contactGrid.selection.getSelected();
    if (typeof contactDetailId == "object") return [contactDetailId];
    return [{ folder_id: activefolder, id: contactDetailId }];
}

function availableModule(name) {
    var availableModules = configGetKey("availableModules");
    for (var i in availableModules) {
        if (availableModules[i] == name) return true;
    }
    return false;
}

var pluginName = "com.openexchange.eas.provisioning.ui";

// provide event
register("Feature_SyncWithMobile", function () {
    if (configGetKey(["modules", "com.openexchange.usm.eas", "active"])) {
        com_openexchange_mobility_provisioning.show();
    } else {
        triggerEvent("Feature_Not_Available", "modules/usm/eas");
    }
});

// The menu

var menu = new MenuNodes.Section("com.openexchange.synchronization",
    _("Synchronization"), -1);
var menubutton = new MenuNodes.Button(_("Mobile phone"));
menubutton.icon = "/plugins/" + pluginName + "/images/call.png";
menubutton.disabledIcon = "/plugins/" + pluginName + "/images/call_d.png";
menubutton.click = function() { triggerEvent("Feature_SyncWithMobile"); };
menu.add(menubutton);
if (!configGetKey(["modules", "com.openexchange.usm.eas", "active"])) {
    menubutton.button.options.mousedown = function() {
        triggerEvent("Feature_Not_Available", "modules/usm/eas");
    };
    menubutton.setEnabled(false);
}
menu.show("portal");

var availableServices = {
    telephone: {
        action: "telephone",
        name: _("SMS (WinMobile, iPhone)"),
        listCaption: _("Select a phone number or edit the phone number in the field below."),
        inputCaption: _("Phone number to send mobile configuration link to:"),
        defaultFields: ["cellular_telephone1", "cellular_telephone2"],
        cleanupRegex: /[^0-9#*+]/g,
        cleanupReplacement: "",
        regex: /^[+0][0-9]*$/,
        regexErrorMessage: _("Invalid mobile phone number."),
        fields: [
            "cellular_telephone1", "cellular_telephone2", "telephone_ip",
            "telephone_business1", "telephone_business2", "telephone_callback",
            "telephone_car", "telephone_company", "telephone_home1",
            "telephone_home2", "telephone_other", "telephone_isdn",
            "telephone_pager", "telephone_primary", "telephone_radio",
            "telephone_telex", "telephone_ttytdd", "telephone_assistant"
        ],
        labels: [
            //#. cellular_telephone1
            _("Mobile"),
            //#. cellular_telephone2
            _("Mobile 2"),
            //#. telephone_ip
            _("IP phone"),
            //#. telephone_business1
            _("Business"),
            //#. telephone_business2
            _("Business 2"),
            //#. telephone_callback
            _("Callback"),
            //#. telephone_car
            _("Car phone"),
            //#. telephone_company
            _("Company"),
            //#. telephone_home1
            _("Private"),
            //#. telephone_home2
            _("Private 2"),
            //#. telephone_other
            _("Other"),
            //#. telephone_isdn
            _("ISDN"),
            //#. telephone_pager
            _("Pager"),
            //#. telephone_primary
            _("Primary"),
            //#. telephone_radio
            _("Radio"),
            //#. telephone_telex
            _("Telex"),
            //#. telephone_ttytdd
            _("TTY/TDD"),
            //#. telephone_assistant
            _("Assistant")
        ]
    },
    email: {
        action: "email",
        name: _("E-Mail (WinMobile, iPhone, iPad)"),
        listCaption: _("Select an E-Mail address or edit the address in the field below."),
        inputCaption: _("Address to send mobile configuration link to:"),
        defaultFields: ["email1", "email2", "email3"],
        regex: /^[^@]+@.+\..+$/,
        regexErrorMessage: _("Invalid E-Mail address."),
        fields: ["email1", "email2", "email3"],
        labels: [
            //#. email1
            _("Business"),
            //#. email2
            _("Private"),
            //#. email3
            _("Other")
        ]
    }
};

function displayHTML(root, url) {
    jQuery.ajax({ url: url, dataType: "text" }).then(function(data) {
        root.innerHTML = data;
        var spans = jQuery(root).find("span.guimenu");
        spans.filter(":contains(OX_DOMAINNAME)").text(ox.api.config.get(
            ["modules", "com.openexchange.usm.eas", "hostname"],
            location.host));
    });
}

//----------------------------------------------

var Class = function() {

	this.contact = null;
	
	this.lightbox = newnode("div", {
		position: "fixed", 
		top: "50%", left: "0px", width: "100%", zIndex: 65000,
		display: "none"
	});
	// semi-transparent overlay
	this.lightboxOverlay = newnode("div", {
		position: "fixed", backgroundColor: "black",
		filter: "alpha(opacity=50)", opacity: 0.5,
		top: "0px", right: "0px", bottom: "0px", left: "0px", zIndex: 1,
		display: "none"
	});
	// popup
	this.lightboxPopup = newnode("div", {
		position: "relative",
		width: "500px", height: "32em", margin: "-15em auto", zIndex: 2, border: "1px solid #555",
		MozBorderRadius: "10px", MozBoxShadow: "1px 1px 5px black", fontSize: "10pt",
		webkitBorderRadius: "10px", webkitBoxShadow: "1px 1px 5px black"
	}, { className: "background-color-content" });
	this.lightbox.appendChild(this.lightboxPopup);
	// callee
	this.callee = newnode("div", { 
		backgroundColor: "white", padding: "1em 20px",
		fontSize: "10pt", fontWeight: "normal", color: "black", 
		borderBottom: "1px solid #aaa", marginBottom: "0.5em",
		MozBorderRadiusTopleft: "10px", MozBorderRadiusTopright: "10px",
		webkitBorderTopLeftRadius: "10px", webkitBorderTopRightRadius: "10px"
	});
	this.lightboxPopup.appendChild(this.callee);
    
	// external URLs
    this.iframe = newnode("div", { width: "100%", height: "100%",
        border: "1px solid #aaa", overflow: "auto" });
    this.iframeParent = newnode("div", { position: "absolute", left: "20px",
        right: "20px", top: "9em", bottom: "3.5em", display: "none" }, 0,
        [this.iframe]);
    this.lightboxPopup.appendChild(this.iframeParent);
    this.inputs = newnode("div",{ position: "absolute", width: "100%",
        top: "9em", bottom: "3.5em", marginTop: "1px", display: "none" });
    this.lightboxPopup.appendChild(this.inputs);
    
	// phone book
	this.phoneBook = newnode("div", { 
		fontSize: "10pt", fontWeight: "normal", color: "black", padding: "0px 20px 0px 20px"
	});
	this.inputs.appendChild(this.phoneBook);
	// dialer
    this.dialer = newnode("div", {
        fontSize: "10pt", fontWeight: "normal", color: "black",
        padding: "10px 20px 0px 20px", position: "relative"
    });	
	this.inputs.appendChild(this.dialer);
			
	// log
	this.log = newnode("div", { 
		backgroundColor: "white", height: "5em", overflow: "auto",
		fontSize: "9pt", lineHeight: "11pt", fontWeight: "normal", color: "black", 
		margin: "1em 20px 0em 20px", padding: "5px"
	});
	this.inputs.appendChild(this.log);
	// close button
	this.buttons = newnode("div", { 
		position: "absolute", bottom: "1em", left: "20px", right: "20px",
		textAlign: "right"
	});
	this.lightboxPopup.appendChild(this.buttons);
	// add to document
	document.body.appendChild(this.lightbox);
	document.body.appendChild(this.lightboxOverlay);
	// add listeners
	var self = this;
	addDOMEvent(this.lightboxOverlay, "click", function() {
		self.hide();
	});
	
	// paint dialer
	this.paintDialer();
	// paint "close" button
	this.paintButtons();
};

Class.prototype.show = function() {
    var self = this;
    getServices(function(contact, services) {
        // clear
        self.callee.innerHTML = "";
        self.phoneBook.innerHTML = "";
        self.log.innerHTML = "";
        self.box.value = "";
        // contact given?
        if (contact) {
            self.contact = contact;
            // paint callee
            self.paintCallee(self.contact, services);
        } else {
            self.contact = null;
        }
        // show dialog
        self.lightbox.style.display = "block";
        self.lightboxOverlay.style.display = "block";
        self.box.focus();
        // wait for ESC
        self.escapeHandler = function(e) {
            var key = e.keyCode || e.which;
            if (key == 27) { self.hide(); }
        };
        addDOMEvent(document.body, "keypress", self.escapeHandler);
    });
};

Class.prototype.hide = function() {
	removeDOMEvent(document.body, "keypress", this.escapeHandler);
	this.lightbox.style.display = "none";
	this.lightboxOverlay.style.display = "none";
	this.disableSend(false);
};

Class.prototype.paintCallee = function(contact, services) {
	if (contact) {
	    removeChildNodes(this.callee);
	    this.callee.appendChild(newnode("div", 0, 0, [addTranslated(
	        //#. %s is the product name (by default: "Open-Xchange Server")
	        format(_("Here you can configure a mobile device for use with %s."),
	               oxProductInfo.product_name))]));
	    if (services.length > 1) {
            this.callee.appendChild(newnode("div", {
                fontWeight: "bold", color: "#555", lineHeight: "2em"
            }, 0, [addTranslated(
                _("Configuration via:"))]));
            select = newnode("select", { width: "100%" });
            for (var i = 0; i < services.length; i++) {
                select.appendChild(newnode("option", 0,
                    i ? 0 : { selected: "selected" },
                    [newtext(services[i].name)]));
            }
            var self = this;
            addDOMEvent(select, "change", function() {
                self.setService(services[select.selectedIndex]);
            });
            this.callee.appendChild(select);
	    }
        this.setService(services[0]);
	}
};

Class.prototype.setService = function(service) {
    this.service = service;
    if (service.url) {
        displayHTML(this.iframe, service.url);
        this.iframeParent.style.display = "";
        this.inputs.style.display = "none";
        this.provisionButton.style.display = "none";
    } else {
        // paint numbers
        this.paintNumbers(this.contact, service);
        // paint dialer
        this.dialerCaption.data = service.inputCaption;
        this.box.value = "";
        for (var i = 0; i < service.defaultFields.length; i++) {
            var value = this.contact[service.defaultFields[i]];
            if (value) {
                this.box.value = value;
                break;
            }
        }
        this.iframeParent.style.display = "none";
        this.inputs.style.display = "";
        this.provisionButton.style.display = "";
    }
};

Class.prototype.paintNumbers = function(contact, service) {
    this.phoneBook.innerHTML = "";
    var first = true, border = "1px solid #aaa";
    var self = this;
	// add caption
	var caption = newnode("div", {
		fontWeight: "bold", color: "#555", lineHeight: "2em"
	}, 0, [newtext(service.listCaption)]);
	this.phoneBook.appendChild(caption);
	var numbers = newnode("div", {
		height: "6em", overflow: "auto", backgroundColor: "#ddd"
	});
	this.phoneBook.appendChild(numbers);
	// loop through phone numbers
	for (var i = 0; i < service.fields.length; i++) {
		var key = service.fields[i], name = service.labels[i];
		var value = contact[key];
		if (value) addNumber(name, value);
	}
	if (contact.unnamedNumbers) {
	    for (var i = 0; i < contact.unnamedNumbers.length; i++) {
	        addNumber("", contact.unnamedNumbers[i]);
	    }
	}
	function addNumber(name, value) {
        // create div
	    var children = [];
	    if (name) {
	        children.push(newtext(name));
	        children.push(newtext(": "));
	    }
	    children.push(newnode("span", { fontWeight: "bold" }, 0,
	        [newtext(value)]));
        var div = newnode("div", {
            cursor: "pointer", lineHeight: "2em", backgroundColor: "white",
            borderBottom: border, paddingLeft: "10px"
        }, 0, children);
        // first?
        if (first) { div.style.borderTop = border; first = false; }
        // add listeners
        addDOMEvent(div, "mouseover", function() { div.className = "background-color-PMG-selection-elements"; });
        addDOMEvent(div, "mouseout", function() { div.className = ""; });
        addDOMEvent(div, "click", function() {
            if (self.box.disabled) return;
            self.box.value = value;
            self.box.focus();
        });
        addDOMEvent(div, "dblclick", function() {
            if (self.box.disabled) return;
            self.box.value = value;
            self.call();
        });
        numbers.appendChild(div);
    }
};

Class.prototype.paintDialer = function() {
	
	var self = this;
	
	// caption
    this.dialerCaption = newtext(":");
	var caption = newnode("div", {
		fontWeight: "bold", color: "#555", lineHeight: "2em"
	}, 0, [this.dialerCaption]);
	this.dialer.appendChild(caption);
	
	// text box
    this.box = newnode("input", { width: "449px", fontSize: "14pt",
        fontWeight: "bold", paddingLeft: "9px" }, { type: "text" });
	this.box.value = "";
	this.dialer.appendChild(this.box);
	// add listener
	
	addDOMEvent(this.box, "keypress", function(e) {
		var key = e.keyCode || e.which;
		if (key == 13) { self.call(); }
	});
};

Class.prototype.paintButtons = function() {
	var self = this;

    // provision button
    this.provisionButton = newnode("input", { marginRight: "10px" },
        { type: "button", value: _("Send") });
    register("LanguageChanged", function() { self.provisionButton.value = _("Send"); });
    addDOMEvent(this.provisionButton, "click", function() { self.call(); });
    this.buttons.appendChild(this.provisionButton);
	
	// close button
	var button =
	    newnode("input", 0, { type: "button", value: _("Close") });
	register("LanguageChanged", function() { button.value = _("Close"); });
	addDOMEvent(button, "click", function() { self.hide(); });
	this.buttons.appendChild(button);
};

Class.prototype.call = function() {
    var self = this;
	var number = this.box.value;
	if (!number) return;
	this.log.innerHTML = "";
	provision(this.service, number, function(text, color) {
	    var style = color ? { color: color, fontWeight: "bold" }
	                      : { color: "#333" };
	    self.log.appendChild(newnode("div", style, 0, [addTranslated(text)]));
	}, function(disabled) { self.disableSend(disabled); });
};

Class.prototype.disableSend = function(disabled) {
    this.box.disabled = disabled;
    this.provisionButton.disabled = disabled;
    this.phoneBook.style.color = disabled ? "gray" : "black";
};

com_openexchange_mobility_provisioning = new Class();

if (   configGetKey(["modules", "com.openexchange.usm.eas", "active"])
    && availableModule("com.openexchange.wizard"))
{
    // load CSS file
    loadCSSFile(PATH + "/style.css");
    
    var tab = {
        name: "mobile",
        enabled: false,
        visible: true,

        headerImage: newnode("img", 0, {
            className: "module-configuration-header-wizard_d com-openexchange-mobile-configuration-gui wizardHeaderImage-disabled",
            src: getFullImgSrc("img/dummy.gif")
        }),

        welcome_node: newnode("tr", 0 , 0, [
            newnode("td", {paddingTop: "5px",paddingleft: "5px"} , 0, [
                newnode("img", 0, {
                    className: "module-configuration-header-wizard_mini wizzardGridBox com-openexchange-mobile-configuration-gui wizardMiniIcon",
                    src: getFullImgSrc("img/dummy.gif")
                })
            ]),
            newnode("td", {paddingTop: "5px" }, 0, [addTranslated(format(
                //#. %1$s is the product name
                //#, c-format
                _("Configure your handheld device to synchronize it with %1$s"),
                oxProductInfo.product_name))])
        ]),
        
        draw: function(wizard) {
            $("popup.wizzard.next").value = _("Next");
            $("popup.wizzard.back").value = _("Previous");
            
            var title = $("popup.wizzard.header").getElementsByTagName("span")[0];
            removeChildNodes(title);
            if (!this.title) {
                this.title = addTranslated(format(
                    //#, c-format
                    _("Step %d. Configure your handheld device"), this.position));
            }
            title.appendChild(this.title);
            
            var header = document.getElementById("wizzardHeaderTitle");     
            removeChildNodes(header);
            header.appendChild(document.createTextNode(_("Handhelds and mobile devices")));
            
            jQuery(this.headerImage)
                .removeClass("module-configuration-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("module-configuration-header-wizard_a wizardHeaderImage-active");

            var base = document.getElementById("wizzardConten");
            removeChildNodes(base);
            this.content.style.height = (base.offsetParent.clientHeight -
                base.offsetTop) + "px";
            base.appendChild(this.content);
            getServices(function(contact, services) {
                tab.fill(contact, services);
            });
        },
        next: function(callback) {
            jQuery(this.headerImage)
                .removeClass("module-configuration-header-wizard_d wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("module-configuration-header-wizard_a wizardHeaderImage");
            callback();
        },
        previous: function(callback) {
            jQuery(this.headerImage)
                .removeClass("module-configuration-header-wizard_a wizardHeaderImage-disabled wizardHeaderImage-active wizardHeaderImage")
                .addClass("module-configuration-header-wizard_d wizardHeaderImage-disabled");
            callback();
        }
    };
    register("Ready", function () {
    	tab.content = createContent(tab);
    	temporary.services.provide("com.openexchange.wizard", tab);
    })
}

function createContent(tab) {

    var list = newnode("div");
    var left = newnode("div", { position: "absolute", width: "16em", left: 0,
                                top: "1em", bottom: 0, fontWeight: "bold" }, 0,
        //#. %s is the product name (by default: "Open-Xhcange Server")
        [addTranslated(format(_("You can use your mobile device with %s. The following devices are supported."),
                              oxProductInfo.product_name)),
         list]);
    
    var caption = newtext("");
    
    var numbers = newnode("div", { position: "absolute", top: "3em",
        bottom: "12em", left: "5px", right: "5px", overflow: "auto",
        backgroundColor: "white", border: "1px solid #c0c0c0" });
        
    var dialerCaption = newtext("");
    
    var box = newnode("input", {
        fontWeight: "bold", border: 0, width: "100%" }, { type: "text" });
    addDOMEvent(box, "keypress", function(e) {
        var key = e.keyCode || e.which;
        if (key == 13) call();
    });

    var button = wizButton(_("Send"));
    addDOMEvent(button.inner, "click", call);
    
    var log = newnode("div", { position: "absolute", bottom: "3em",
        height: "4.5em", left: "5px", right: "5px" });
    
    function call() {
        if (!box.value) return;
        log.innerHTML = "";
        provision(tab.service, box.value, function(text, color) {
            var style = color ? { color: color, fontWeight: "bold" }
                              : { color: "#333" };
            log.appendChild(newnode("div", style, 0,
                                           [addTranslated(text)]));
        }, function(disabled) {
            box.disabled = disabled;
            button.inner.disabled = disabled;
            numbers.style.color = disabled ? "grey" : "";
        });
    }
    
    var dialog = newnode("div", { display: "none", position: "absolute",
                                  top: "1em", bottom: 0, left: "17em",
                                  right: "5px" }, 0,
        [newnode("div", { textAlign: "center", margin: "0 5px" }, 0, [caption]), numbers,
         newnode("div", { position: "absolute", bottom: "10em",
             height: "1.5em", left: "5px", right: "5px", textAlign: "center" },
             0, [dialerCaption]),
         newnode("div", { position: "absolute", bottom: "8em",
             left: "5px", right: "5px", border: "1px solid #c0c0c0",
             paddingLeft: "10px" }, 0, [box]), log,
         newnode("div", { position: "absolute", left: 310, right: "5px",
                                    height: "2.5em", bottom: 0 }, 0, [button.outer])]);
    
    var iframe = newnode("div", { position: "absolute", left: "16em", right: "5px",
                                  top: "1em", bottom: "10px", display: "none",
                                  overflow: "auto" },
                                { className: "iFrameWindow" });
    
    tab.fill = function(contact, services) {
        removeChildNodes(list);
        for (var i = 0; i < services.length; i++) {
            var service = services[i];
            if (service.url) {
                var link = newnode("a", 0, { href: service.url,
                    target: "_blank", className: "linkstyle" },
                    [newtext(service.name)]);
            } else {
                var link = newnode("span", 0, { className: "linkstyle" },
                    [newtext(service.name)]);
            }
            addDOMEvent(link, "click", (function(s) {
                return function(e) {
                    stopEvent(e);
                    setService(s);
                };
            })(service));
            list.appendChild(newnode("div", { padding: "10px 0 0 0px" }, 0,
                                            [link]));
        }
        if (services.length) setService(services[0]);
        function setService(service) {
            if (service.url) {
                dialog.style.display = "none";
                iframe.style.display = "";
                displayHTML(iframe, service.url);
            } else {
                tab.service = service;
                caption.data = service.listCaption;
                removeChildNodes(numbers);
                for (var i = 0; i < service.fields.length; i++) {
                    var name = service.labels[i];
                    var value = contact[service.fields[i]];
                    if (value) addNumber(name, value);
                }
                dialerCaption.data = service.inputCaption;
                box.value = "";
                for (var i = 0; i < service.defaultFields.length; i++) {
                    var value = contact[service.defaultFields[i]];
                    if (value) {
                        box.value = value;
                        break;
                    }
                }
				button.inner.disabled=false;
                log.innerHTML = "";
                box.disabled =false;
                numbers.style.color = "";
                iframe.style.display = "none";
                dialog.style.display = "";
            }
        }
        function addNumber(name, value) {
            var children = [];
            if (name) {
                children.push(newtext(name));
                children.push(newtext(": "));
            }
            children.push(newnode("span",
                { fontWeight: "bold" }, 0,
                [newtext(value)]));
            var div = newnode("div", {
                cursor: "pointer", lineHeight: "2em",
                backgroundColor: "white",
                paddingLeft: "10px"
            }, 0, children);
            if (i) div.style.borderBottom = "1px solid #aaa";
            // add listeners
            addDOMEvent(div, "mouseover", function() {
                div.className = "background-color-PMG-selection-elements";
            });
            addDOMEvent(div, "mouseout", function() {
                div.className = "";
            });
            addDOMEvent(div, "click", function() {
                if (box.disabled) return;
                box.value = value;
                box.focus();
            });
            addDOMEvent(div, "dblclick", function() {
                if (box.disabled) return;
                box.value = value;
                call();
            });
            numbers.appendChild(div);
        }
    };
    
    return newnode("div", { position: "relative" }, 0, [left, dialog, iframe]);
}

function getServices(callback) {
    var contact, services;
    var join = new Join(function() { callback(contact, services); });
    var lock = join.add();
    ox.JSON.get(AjaxRoot + "/user?action=get&session=" + session,
        join.add(function(reply) { contact = reply.data; }));
    ox.JSON.get(AjaxRoot +
        "/mobilityprovisioning?action=listservices&session=" + session,
        join.add(function(reply) {
            services = reply.data.services;
            for (var i = 0; i < services.length; i++) {
                services[i] = availableServices[services[i]];
            }
            var cfg = configGetKey("modules")[pluginName].other;
            var lang = configGetKey("language");
            for (var j in cfg) {
                services.push(cfg[j][lang] || cfg[j].en_US);
            }
        }));
    lock();
}

function provision(service, value, log, disableSend) {
    if (!value) return;
    // clean up
    if (service.cleanupRegex) {
        value = value.replace(service.cleanupRegex, service.cleanupReplacement);
    }
    if (service.regex && !service.regex.test(value)) {
        log(service.regexErrorMessage, "#800");
        return;
    }
    log(_("Generating configuration"));
    disableSend(true);
    // talk to server       
    ox.JSON.put(AjaxRoot + "/mobilityprovisioning?action=" +
        service.action + "&target=" + encodeURIComponent(value) +
        "&session=" + session, null,
        // success
        function(reply) {
            var error = false;
            if (reply && reply.data && reply.data.success) {
                log(_("Configuration sent"), "#050");
            } else {
                log(_("Error on creating mobile configuration, please try again later"), "#800");
                disableSend(false);
            }
        },
        // error
        function(response) {
            disableSend(false);
            if (typeof response == "string") {
                log(noI18n(response), "#800");
            } else if (response && response.error) {
                log(formatError(response), "#800");
            } else {
                log(_("Unkown error."), "#800");
            }
        }
    );
}

function wizButton(text){
    var button = newnode("input", { marginTop: "5px" }, { className: "wizzardBlankButton fakeButton", type: "button", value: expectI18n(text) });
    register("LanguageChanged", function() { button.value = expectI18n(text); });
    var node = newnode("div",{flt:"left"},{ className:"fakeButton background-color-default cursorPointer whiteground"},[newnode("div",{},{className:"fakeButtonBottom"},[newnode("div",{},{className:"fakeButtonLeft"},[newnode("div",{},{className:"fakeButtonRight"},[
         newnode("div",{},{className:"fakeButtonTopLeft"},[newnode("div",{},{className:"fakeButtonTopRight"},[newnode("div",{},{className:"fakeButtonBottomLeft"},[newnode("div",{},{className:"fakeButtonBottomRight"},[button])])])])
      ])])])]);
    return { outer: node, inner: button };
}
