
Name:          open-xchange-documents-backend
BuildArch:     noarch
#!BuildIgnore: post-build-checks
%if 0%{?rhel_version} && 0%{?rhel_version} == 600
BuildRequires: java7-devel
%else
BuildRequires: java-devel >= 1.7.0
%endif
%if 0%{?rhel_version} && 0%{?rhel_version} >= 700
BuildRequires: ant
%else
BuildRequires: ant-nodeps
%endif
BuildRequires: open-xchange-grizzly
BuildRequires: open-xchange-oauth
BuildRequires: open-xchange-realtime-core
BuildRequires: open-xchange-documentconverter-api
BuildRequires: open-xchange-documents-templates
BuildRequires: open-xchange-core >= 7.8.3-23
Version:       7.8.3
%define        ox_release 12
Release:       %{ox_release}_<CI_CNT>.<B_CNT>
Group:         Applications/Productivity
License:       GPL-2.0
BuildRoot:     %{_tmppath}/%{name}-%{version}-build
URL:           http://www.open-xchange.com/
Source:        %{name}_%{version}.orig.tar.bz2
Summary:       The Open-Xchange backend office extension
AutoReqProv:   no
Requires:      open-xchange-core >= 7.8.3-23
Requires:      open-xchange-oauth >= 7.8.3
Requires:      open-xchange-realtime-json >= 7.8.3
Requires:      open-xchange-documentconverter-api >= 7.8.3
Requires:      open-xchange-file-distribution >= 7.8.3
Requires:      open-xchange-sessionstorage-hazelcast >= 7.8.3
Requires:      open-xchange-documents-templates >= 7.8.3
Obsoletes:     open-xchange-documents-core < 7.4.2
Obsoletes:     open-xchange-calcengineserver < 7.4.2
Obsoletes:     calcengine < 1.7
Provides:      open-xchange-documents-backend = %{version}
Provides:      open-xchange-documents-core = %{version}
Provides:      open-xchange-calcengineserver = %{version}
Provides:      calcengine = 1.7

%description
This package contains the backend components for the office productivity

Authors:
--------
    Open-Xchange

%prep
%setup -q

%build

%install
export NO_BRP_CHECK_BYTECODE_VERSION=true
ant -lib build/lib -Dbasedir=build -DdestDir=%{buildroot} -DpackageName=%{name} -f build/build.xml clean build



%post
. /opt/open-xchange/lib/oxfunctions.sh
CONFFILES="settings/office.properties conf/hunspell.properties hazelcast/officeDocumentDirectory.properties"
for FILE in $CONFFILES; do
    ox_move_config_file /opt/open-xchange/etc/groupware /opt/open-xchange/etc $FILE
done
if [ ${1:-0} -eq 2 ]; then
    # only when updating

    # prevent bash from expanding, see bug 13316
    GLOBIGNORE='*'

    # SoftwareChange_Request-2052
    ox_add_property io.ox/office//module/useLocalStorage true /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-2053
    ox_add_property io.ox/office//module/templatePath /opt/open-xchange/templates/documents /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-2334
    ox_add_property io.ox/office//module/standalone false /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-2610
    ox_add_property io.ox/office//module/renamedisabled false /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-2937
    ox_add_property io.ox/office//module/documentRestoreEnabled true /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-2947
    VALUE=$(ox_read_property com.openexchange.hazelcast.configuration.map.name /opt/open-xchange/etc/hazelcast/officeDocumentDirectory.properties)
    if [ "$VALUE" == "officeDocumentDirectory-1" ]; then
        ox_set_property com.openexchange.hazelcast.configuration.map.name officeDocumentDirectory-2 /opt/open-xchange/etc/hazelcast/officeDocumentDirectory.properties
    fi

    # SoftwareChange_Request-2948
    VALUE=$(ox_read_property com.openexchange.hazelcast.configuration.map.maxIdleSeconds /opt/open-xchange/etc/hazelcast/officeDocumentDirectory.properties)
    if [ "900" = "$VALUE" ]; then
        ox_set_property com.openexchange.hazelcast.configuration.map.maxIdleSeconds 1800 /opt/open-xchange/etc/hazelcast/officeDocumentDirectory.properties
    fi

    # SoftwareChange_Request-3331
    ox_add_property io.ox/office//spreadsheet/maxFormulas 10000 /opt/open-xchange/etc/settings/office.properties

    # SoftwareChange_Request-3589
    ox_add_property com.openexchange.capability.guard-docs false /opt/open-xchange/etc/documents.properties

    # SoftwareChange_Request-3665
    ox_add_property com.openexchange.office.maxDocumentFileSize 100 /opt/open-xchange/etc/documents.properties
fi

%clean
%{__rm} -rf %{buildroot}

%files
%defattr(-,root,root)
%dir /opt/open-xchange/bundles/
/opt/open-xchange/bundles/*
%dir /opt/open-xchange/etc/
/opt/open-xchange/etc/*
%config(noreplace) /opt/open-xchange/etc/settings/office.properties
%config(noreplace) /opt/open-xchange/etc/hunspell.properties
%config(noreplace) /opt/open-xchange/etc/documents.properties
%config(noreplace) /opt/open-xchange/etc/hazelcast/officeDocumentDirectory.properties
%config(noreplace) /opt/open-xchange/etc/hazelcast/officeDocSaveStateDirectory.properties
%config(noreplace) /opt/open-xchange/etc/hazelcast/officeDocumentCleanupLock.properties
%config(noreplace) /opt/open-xchange/etc/hazelcast/officeDocumentResources.properties
%dir /opt/open-xchange/osgi/bundle.d/
/opt/open-xchange/osgi/bundle.d/*

%changelog
* Mon Dec 04 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-12-11 (4472)
* Mon Oct 09 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-10-16 (4393)
* Wed Jul 05 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2015-07-10 (4256)
* Mon May 08 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-05-15 (4132)
* Wed Apr 12 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-04-18 (4084)
* Wed Mar 29 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-04-03 (4050)
* Fri Feb 10 2017 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2017-02-20 (3952)
* Fri Nov 25 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second release cadidate for 7.8.3 release
* Thu Nov 24 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First release cadidate for 7.8.3 release
* Tue Nov 15 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third preview of 7.8.3 release
* Sat Nov 12 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2016-11-21 (3731)
* Mon Oct 31 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2016-11-07 (3678)
* Sat Oct 29 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second preview of 7.8.3 release
* Fri Oct 14 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First preview of 7.8.3 release
* Tue Sep 06 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.8.3 release
* Tue Jul 12 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.8.2 release
* Wed Jul 06 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.8.2 release
* Wed Jun 29 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.8.2 release
* Tue Jun 14 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.8.2 release
* Sat May 07 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.8.2 release
* Wed Mar 30 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.8.1 release
* Thu Mar 24 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.8.1 release
* Tue Mar 15 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth preview of 7.8.1 release
* Fri Mar 04 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth preview of 7.8.1 release
* Sat Feb 20 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.8.1 release
* Tue Feb 02 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.8.1 release
* Tue Jan 26 2016 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.8.1 release
* Fri Oct 09 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.8.1 release
* Fri Oct 02 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.8.0 release
* Fri Sep 25 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.8.0 release
* Fri Sep 18 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.8.0 release
* Mon Sep 07 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.8.0 release
* Fri Aug 21 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.8.0 release
* Fri Aug 21 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.8.0 release
* Fri Jul 03 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2015-07-10
* Mon Mar 16 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.8.0 release
* Mon Mar 09 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Twelfth candidate for 7.6.2 release
* Fri Mar 06 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Eleventh candidate for 7.6.2 release
* Wed Mar 04 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Tenth candidate for 7.6.2 release
* Tue Mar 03 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Ninth candidate for 7.6.2 release
* Tue Feb 24 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Eighth candidate for 7.6.2 release
* Wed Feb 11 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Seventh candidate for 7.6.2 release
* Fri Jan 30 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.6.2 release
* Tue Jan 27 2015 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.6.2 release
* Fri Dec 12 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.6.2 release
* Fri Dec 05 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.6.2 release
* Fri Nov 21 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.6.2 release
* Tue Nov 04 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Ninth candidate for 7.6.1 release
* Fri Oct 31 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.6.2 release
* Thu Oct 30 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Eighth candidate for 7.6.1 release
* Mon Oct 27 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Seventh candidate for 7.6.1 release
* Tue Oct 21 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.6.1 release
* Thu Oct 16 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.6.2 release
* Tue Oct 14 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.6.1 release
* Fri Oct 10 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.6.1 release
* Thu Oct 02 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.6.1 release
* Tue Sep 16 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.6.1 release
* Wed Sep 10 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.6.1 release
* Wed Aug 20 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2014-08-25
* Tue Aug 19 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2014-08-25
* Mon Jul 21 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.6.1
* Tue Jul 15 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2014-07-21
* Tue Jul 08 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Build for patch 2014-07-17
* Tue Jun 24 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Seventh candidate for 7.6.0 release
* Fri Jun 20 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.6.0 release
* Fri Jun 13 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.6.0 release
* Fri May 30 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.6.0 release
* Fri May 16 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.6.0 release
* Mon May 05 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.6.0 release
* Fri Apr 11 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.6.0 release
* Thu Mar 27 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.4.2 Spreadsheet Final release
* Wed Mar 26 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.4.2 Spreadsheet Final release
* Wed Feb 26 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.4.2 spreadsheet release
* Wed Feb 12 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.6.0
* Fri Feb 07 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.4.2 release
* Thu Feb 06 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.4.2 release
* Tue Feb 04 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.4.2 release
* Thu Jan 23 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.4.2 release
* Fri Jan 10 2014 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.4.2 release
* Mon Dec 23 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.4.2 release
* Thu Dec 19 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.4.2
* Tue Dec 10 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
preparation for 7.0.1 - sprint #19
* Wed Nov 20 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.4.1 release
* Fri Nov 15 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.4.1 release
* Thu Nov 07 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.4.1 release
* Wed Oct 23 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.4.1 release
* Thu Oct 10 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First sprint increment for 7.4.1 release
* Tue Sep 24 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Eleventh candidate for 7.4.0 release
* Fri Sep 20 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.4.1 release
* Fri Sep 20 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Tenth candidate for 7.4.0 release
* Thu Sep 12 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Ninth candidate for 7.4.0 release
* Sun Sep 01 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Eighth candidate for 7.4.0 release
* Tue Aug 27 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Seventh candidate for 7.4.0 release
* Fri Aug 23 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Sixth candidate for 7.4.0 release
* Mon Aug 19 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fifth candidate for 7.4.0 release
* Tue Aug 13 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.4.0 release
* Tue Aug 06 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third release candidate for 7.4.0
* Fri Aug 02 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second release candidate for 7.4.0
* Wed Jul 17 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.4.0 release
* Tue Jul 16 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.4.0
* Mon Jul 01 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.2.2 release
* Fri Jun 28 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.2.2 release
* Wed Jun 26 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Release candidate for 7.2.2 release
* Fri Jun 21 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second feature freeze for 7.2.2 release
* Mon Jun 17 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Feature freeze for 7.2.2 release
* Mon Jun 03 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First sprint increment for 7.2.2 release
* Wed May 29 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.2.2 release
* Mon May 27 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.2.2
* Wed May 22 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.2.1 release
* Wed May 15 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.2.1 release
* Mon Apr 22 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.2.1 release
* Mon Apr 15 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.4.0
* Mon Apr 15 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.2.1
* Wed Apr 10 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Fourth candidate for 7.2.0 release
* Mon Apr 08 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Third candidate for 7.2.0 release
* Tue Apr 02 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
Second candidate for 7.2.0 release
* Tue Apr 02 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
First candidate for 7.2.0 release
* Fri Mar 15 2013 Martin Hollmichel <martin.hollmichel@open-xchange.com>
prepare for 7.2.0
* Wed Sep 19 2012 Martin Hollmichel <martin.hollmichel@open-xchange.com>
first build
