package com.openexchange.office.tools.htmldoc;

import java.util.Map.Entry;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;

public class SimpleField
        extends SubNode
{
    private static final String BEFORECLASS = "<div contenteditable=\"false\" class=\"inline field";
    private static final String BEFORETYPE  = "\"";
    private static final String AFTERTYPE   = "><span ";
    private static final String AFTERATTRS  = " >";
    private static final String CLOSEFIELD  = "</span></div>";

    private final String        fieldText;
    private final String              type;

    // ///////////////////////////////////////////////////////////

    public SimpleField(
            int position, String representation, String type)
    {
        super(position, 1);

        this.fieldText = representation;
        this.type = type;
    }

	@Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(BEFORECLASS);

        JSONObject attrs = getAttribute();
        if (attrs == null)
        {
            attrs = new JSONObject();
        }

        JSONObject field = attrs.optJSONObject("field");
        if (null != field)
        {
        	attrs.put("field", field);
        }

        JSONObject jq = GenDocHelper.getJQueryData(attrs);
        if (type != null)
        {
            jq.put("type", type);
        }
		if (null != field) {
			for (Entry<String, Object> e : field.entrySet()) {
				jq.put(e.getKey(), e.getValue());
			}
		}

        if (type != null)
        {
            String type = this.type;
            // System.out.println("Field.appendContent() before: '" + type + "'");

            type = type.trim().split(" ")[0];
            // System.out.println("Field.appendContent() after : '" + type + "'");

            document.append(" field-");
            document.append(StringEscapeUtils.escapeHtml4(type));
        }

        if (StringUtils.isEmpty(fieldText))
        {
            if (type != null)
            {
                document.append(" ");
            }
            document.append("empty-field");
        }

        document.append(BEFORETYPE);



        GenDocHelper.appendJQueryData(document, jq);

        document.append(AFTERTYPE);

        JSONObject jq2 = GenDocHelper.getJQueryData(getAttribute());
        GenDocHelper.appendJQueryData(document, jq2);

        document.append(AFTERATTRS);

        document.append(StringEscapeUtils.escapeHtml4(fieldText));

        document.append(CLOSEFIELD);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "Field: " + fieldText;
    }

}
