/*
*
*    OPEN-XCHANGE legal information
*
*    All intellectual property rights in the Software are protected by
*    international copyright laws.
*
*
*    In some countries OX, OX Open-Xchange, open xchange and OXtender
*    as well as the corresponding Logos OX Open-Xchange and OX are registered
*    trademarks.
*    The use of the Logos is not covered by the GNU General Public License.
*    Instead, you are allowed to use these Logos according to the terms and
*    conditions of the Creative Commons License, Version 2.5, Attribution,
*    Non-commercial, ShareAlike, and the interpretation of the term
*    Non-commercial applicable to the aforementioned license is published
*    on the web site http://www.open-xchange.com/EN/legal/index.html.
*
*    Please make sure that third-party modules and libraries are used
*    according to their respective licenses.
*
*    Any modifications to this package must retain all copyright notices
*    of the original copyright holder(s) for the original code used.
*
*    After any such modifications, the original and derivative code shall remain
*    under the copyright of the copyright holder(s) and/or original author(s)per
*    the Attribution and Assignment Agreement that can be located at
*    http://www.open-xchange.com/EN/developer/. The contributing author shall be
*    given Attribution for the derivative code and a license granting use.
*
*     Copyright (C) 2016 OX Software GmbH
*     Mail: info@open-xchange.com
*
*
*     This program is free software; you can redistribute it and/or modify it
*     under the terms of the GNU General Public License, Version 2 as published
*     by the Free Software Foundation.
*
*     This program is distributed in the hope that it will be useful, but
*     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
*     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
*     for more details.
*
*     You should have received a copy of the GNU General Public License along
*     with this program; if not, write to the Free Software Foundation, Inc., 59
*     Temple Place, Suite 330, Boston, MA 02111-1307 USA
*
*/
package com.openexchange.office.realtime.log;
/*
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map.Entry;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
*/

public class JoinTimeController { //implements Runnable {
/*
    private static class JoinTimeData {
        private final Date timeStamp;

        public JoinTimeData(final Date start) {
            this.timeStamp = start;
        }

        final Date getTimeStamp() {
            return this.timeStamp;
        }
    }

    private static final int MAX_TIME_ELAPSED_FOR_WARNING = 30000; // time in milliseconds
    private static final int MAX_TIME_ELAPSED_TO_REMOVE   = 65000; // time in milliseconds
    @SuppressWarnings("deprecation")
    private final static org.apache.commons.logging.Log LOG = com.openexchange.log.LogFactory.getLog(JoinTimeController.class);
    private static final AtomicReference<JoinTimeController> REF = new AtomicReference<JoinTimeController>(new JoinTimeController());
    private static final Lock m_lock = new ReentrantLock();
    private static final AtomicBoolean m_shutdown = new AtomicBoolean(false);
    private final HashMap<String, JoinTimeData> m_joinTimeData = new HashMap<String, JoinTimeData>();

    private JoinTimeController() {
        Thread t = new Thread(this, "JoinTimeController");
        t.start();
    }

    public static JoinTimeController getSingleton() {
        return REF.get();
    }

    public void shutdown() {
        m_shutdown.set(true);
        synchronized(m_shutdown) {
            m_shutdown.notify();
        }
    }

    public void addJoiningDocUserId(final String docUserId) {
        m_lock.lock();
        final Date now = new Date();
        m_joinTimeData.put(docUserId, new JoinTimeData(now));
        m_lock.unlock();
    }

    public void removeJoiningDocUserId(final String docUserId) {
        m_lock.lock();
        m_joinTimeData.remove(docUserId);
        m_lock.unlock();
    }

    public static String createDocUserId(final String docId, final String userId) {
        final StringBuffer buf = new StringBuffer();
        buf.append(docId);
        buf.append("*");
        buf.append(userId);
        return buf.toString();
    }

    @Override
    public void run() {

        while (!m_shutdown.get()) {
            final Date now = new Date();

            try {
                m_lock.lock();
                final Iterator<Entry<String, JoinTimeData>> iter = m_joinTimeData.entrySet().iterator();
                while (iter.hasNext()) {
                    final Entry<String, JoinTimeData> entry = iter.next();
                    final String docUserId = entry.getKey();
                    final Date timeStamp = entry.getValue().getTimeStamp();
                    long elapsedTime = now.getTime() - timeStamp.getTime();

                    if (elapsedTime >= MAX_TIME_ELAPSED_FOR_WARNING) {
                        LOG.warn("RT connection: Joining user/document " + docUserId + " exceeded warning threshold, elapsed time = " + elapsedTime + "ms");
                    }

                    if (elapsedTime >= MAX_TIME_ELAPSED_TO_REMOVE) {
                        LOG.warn("RT connection: Stalled joining user/document " + docUserId + " removed due to timeout (" + elapsedTime + "ms)");
                        iter.remove();
                    }
                }
            } catch (Throwable e) {
                // ignore
            } finally {
                m_lock.unlock();
            }

            try {
                synchronized(m_shutdown) {
                    m_shutdown.wait(5000);
                }
            } catch (InterruptedException e) {
                m_shutdown.set(true);
            }
        }
    }
*/
}
