/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.drawingml;

import java.util.List;

import org.docx4j.dml.CTHslColor;
import org.docx4j.dml.CTPresetColor;
import org.docx4j.dml.CTSRgbColor;
import org.docx4j.dml.CTScRgbColor;
import org.docx4j.dml.CTSchemeColor;
import org.docx4j.dml.CTSystemColor;
import org.docx4j.dml.IColorChoice;

public class ColorChoiceListEntry implements IColorChoice {

	final private List<Object> egChoiceList;
	final private int index;
	private Object o;

	public ColorChoiceListEntry(List<Object> egChoiceList, int index) {
		this.egChoiceList = egChoiceList;
		this.index = index;
		o = egChoiceList.get(index);
	}

	@Override
	public CTScRgbColor getScrgbClr() {
		return o instanceof CTScRgbColor ? (CTScRgbColor)o : null;
	}

	@Override
	public void setScrgbClr(CTScRgbColor value) {
		o = value;
		egChoiceList.set(index, value);
	}

	@Override
	public CTSRgbColor getSrgbClr() {
		return o instanceof CTSRgbColor ? (CTSRgbColor)o : null;
	}
	@Override
	public void setSrgbClr(CTSRgbColor value) {
		o = value;
		egChoiceList.set(index, value);
	}

	@Override
	public CTHslColor getHslClr() {
		return o instanceof CTHslColor ? (CTHslColor)o : null;
	}

	@Override
	public void setHslClr(CTHslColor value) {
		o = value;
		egChoiceList.set(index, value);
	}

	@Override
	public CTSystemColor getSysClr() {
		return o instanceof CTSystemColor ? (CTSystemColor)o : null;
	}

	@Override
	public void setSysClr(CTSystemColor value) {
		o = value;
		egChoiceList.set(index, value);
	}

	@Override
	public CTSchemeColor getSchemeClr() {
		return o instanceof CTSchemeColor ? (CTSchemeColor)o : null;
	}

	@Override
	public void setSchemeClr(CTSchemeColor value) {
		o = value;
		egChoiceList.set(index, value);
	}

	@Override
	public CTPresetColor getPrstClr() {
		return o instanceof CTPresetColor ? (CTPresetColor)o : null;
	}

	@Override
	public void setPrstClr(CTPresetColor value) {
		o = value;
		egChoiceList.set(index, value);
	}
}
