/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.pptx.components;

import javax.xml.bind.JAXBException;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.dml.CTTableCell;
import org.docx4j.dml.CTTableRow;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.ooxml.OperationDocument;
import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.drawingml.DMLHelper;
import com.openexchange.office.ooxml.operations.CreateOperationHelper;

public class TableRowComponent extends PptxComponent {

	final private CTTableRow tableRow;

	public TableRowComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);

        this.tableRow = (CTTableRow)getObject();
    }

    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        final int nextGridPosition = previousChildComponent instanceof TableCellComponent ? ((TableCellComponent)previousChildComponent).getNextGridPosition() : 0;

        Component nextComponent = null;
        final IndexedNodeList<Object> nodeList = tableRow.getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, tableRow);
            if(o instanceof CTTableCell&&!((CTTableCell)o).isHMerge()) {
            	nextComponent = new TableCellComponent(this, childNode, nextComponentNumber, nextGridPosition);
            }
        }
        return nextComponent;
    }

    @Override
    public void applyAttrsFromJSON(OperationDocument operationDocument, JSONObject attrs)
    	throws InvalidFormatException, PartUnrecognisedException, JSONException {

    	if(DMLHelper.applyTableRowFromJson(tableRow, attrs)) {
    		((ShapeGraphicComponent)getParentComponent()).recalcTableHeight();
    	}
    }

    @Override
    public JSONObject createJSONAttrs(CreateOperationHelper createOperationHelper, JSONObject attrs)
    	throws JSONException {

    	DMLHelper.createJsonFromTableRow(attrs, tableRow, createOperationHelper.getOperationDocument().getThemePart(false), createOperationHelper.getOperationDocument().getContextPart());
    	return attrs;
    }

	public void insertCells(com.openexchange.office.ooxml.OperationDocument operationDocument, int cellPosition, int count, JSONObject attrs)
	    throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

    	Component c = getChildComponent(cellPosition);
        final IndexedNodeList<Object> trContent = tableRow.getContent();
        for (int i=0; i<count; i++) {
            final CTTableCell tc = new CTTableCell();
            tc.setParent(tableRow);
            trContent.addNode(c!=null?c.getNode():null, new IndexedNode<Object>(tc), true);
        }
        if(attrs!=null) {
            c = getChildComponent(cellPosition);
            for(int i=0; i<count; i++) {
            	c.applyAttrsFromJSON(operationDocument, attrs);
            	c = c.getNextComponent();
            }
        }
	}
}
