/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.docx.components;

import javax.xml.bind.JAXBException;

import org.docx4j.IndexedNode;
import org.docx4j.IndexedNodeList;
import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.exceptions.PartUnrecognisedException;
import org.docx4j.wml.CTSdtCell;
import org.docx4j.wml.CTTrPrBase;
import org.docx4j.wml.CTTrPrChange;
import org.docx4j.wml.CTTrackChange;
import org.docx4j.wml.ContentAccessor;
import org.docx4j.wml.Tc;
import org.docx4j.wml.Tr;
import org.docx4j.wml.TrPr;
import org.json.JSONException;
import org.json.JSONObject;

import com.openexchange.office.ooxml.components.Component;
import com.openexchange.office.ooxml.components.ComponentContext;
import com.openexchange.office.ooxml.components.IRow;
import com.openexchange.office.ooxml.docx.tools.Table;
import com.openexchange.office.ooxml.docx.tools.Utils;

public class TrComponent extends DocxComponent implements IRow {

    public TrComponent(ComponentContext parentContext, IndexedNode<Object> _node, int _componentNumber) {
        super(parentContext, _node, _componentNumber);
    }
    @Override
	public Component getNextChildComponent(ComponentContext previousChildContext, Component previousChildComponent) {
        final int index = previousChildContext!=null?previousChildContext.getNode().getIndex()+1:0;
        final int nextComponentNumber = previousChildComponent!=null?previousChildComponent.getNextComponentNumber():0;
        final int nextGridPosition = previousChildComponent instanceof TcComponent?((TcComponent)previousChildComponent).getNextGridPosition():0;

        Component nextComponent = null;
        final IndexedNode<Object> trNode = getNode();
        final IndexedNodeList<Object> nodeList = (IndexedNodeList<Object>)((ContentAccessor)trNode.getData()).getContent();
        for(int i=index; nextComponent==null&&i<nodeList.size(); i++) {
            final IndexedNode<Object> childNode = nodeList.getNode(i);
            final Object o = getContentModel(childNode, trNode.getData());
            if(o instanceof Tc) {
                nextComponent = new TcComponent(this, childNode, nextComponentNumber, nextGridPosition);
            }
            else if(o instanceof CTSdtCell) {
                final SdtRowContext sdtRowContext = new SdtRowContext(this, childNode);
                nextComponent = sdtRowContext.getNextChildComponent(null, previousChildComponent);
            }
        }
        return nextComponent;
    }
	@Override
	public void applyAttrsFromJSON(com.openexchange.office.ooxml.OperationDocument operationDocument, JSONObject attrs) {
		if(attrs==null) {
			return;
		}
		try {
	        final Tr tr = (Tr)getObject();
	        TrPr trPr = tr.getTrPr();
	        if(trPr==null) {
	            trPr = Context.getWmlObjectFactory().createTrPr();
	            trPr.setParent(tr);
	            tr.setTrPr(trPr);
	        }
	        Table.applyRowProperties(attrs.optJSONObject("row"), trPr);
	        final Object changes = attrs.opt("changes");
	        if(changes!=null) {
		        if(changes instanceof JSONObject) {
		        	final Object attrsInserted = ((JSONObject)changes).opt("inserted");
		        	if(attrsInserted!=null) {
		        		if(attrsInserted instanceof JSONObject) {
	            			CTTrackChange ins = trPr.getIns();
	            			if(ins==null) {
	            				ins = Context.getWmlObjectFactory().createCTTrackChange();
	            				ins.setParent(trPr);
	            				trPr.setIns(ins);
	            			}
                			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsInserted, ins);
		        		}
		        		else {
		        			trPr.setIns(null);
		        		}
		        	}
		        	final Object attrsRemoved = ((JSONObject)changes).opt("removed");
		        	if(attrsRemoved!=null) {
			        	if(attrsRemoved instanceof JSONObject) {
	            			CTTrackChange del = trPr.getDel();
	            			if(del==null) {
	            				del = Context.getWmlObjectFactory().createCTTrackChange();
	            				del.setParent(trPr);
	            				trPr.setDel(del);
	            			}
                			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsRemoved, del);
			        	}
			        	else {
			        		trPr.setDel(null);
			        	}
		        	}
		        	final Object attrsModified = ((JSONObject)changes).opt("modified");
		        	if(attrsModified!=null) {
		        		if(attrsModified instanceof JSONObject) {
		        			CTTrPrChange trPrChange = trPr.getTrPrChange();
		        			if(trPrChange==null) {
		        				trPrChange = Context.getWmlObjectFactory().createCTTrPrChange();
		        				trPrChange.setParent(trPr);
		        				trPr.setTrPrChange(trPrChange);
		        			}
		        			Utils.applyTrackInfoFromJSON((com.openexchange.office.ooxml.docx.DocxOperationDocument)operationDocument, (JSONObject)attrsModified, trPrChange);
        					final Object attrsModifiedAttrs = ((JSONObject)attrsModified).opt("attrs");
        					if(attrsModifiedAttrs!=null) {
        						if(attrsModifiedAttrs instanceof JSONObject) {
        							CTTrPrBase trPrBase = trPrChange.getTrPr();
        							if(trPrBase==null) {
        								trPrBase = Context.getWmlObjectFactory().createCTTrPrBase();
        								trPrBase.setParent(trPrChange);
        								trPrChange.setTrPr(trPrBase);
        							}
        							Table.applyRowProperties(((JSONObject)attrsModifiedAttrs).optJSONObject("row"), trPrBase);
        						}
        						else {
        							trPrChange.setTrPr(null);
        						}
        					}
		        		}
		        		else {
		        			trPr.setTrPrChange(null);
		        		}
		        	}
		        }
		        else {
		        	trPr.setIns(null);
		        	trPr.setDel(null);
		        	trPr.setTrPrChange(null);
		        }
	        }
		}
		catch(Exception e) {

		}
	}

	@Override
	public JSONObject createJSONAttrs(com.openexchange.office.ooxml.operations.CreateOperationHelper createOperationHelper, JSONObject attrs)
		throws JSONException {

		final Tr tr = (Tr)getObject();
        final TrPr trPr = tr.getTrPr();
        if(trPr!=null) {
            Table.createRowProperties(tr.getTrPr(), attrs);
            if(trPr.getDel()!=null||trPr.getIns()!=null||trPr.getTrPrChange()!=null) {
                final JSONObject jsonRowChanges = new JSONObject(2);
                if(trPr.getDel()!=null) {
                	jsonRowChanges.put("removed", Utils.createJSONFromTrackInfo((com.openexchange.office.ooxml.docx.DocxOperationDocument)createOperationHelper.getOperationDocument(), trPr.getDel()));
                }
                if(trPr.getIns()!=null) {
                	jsonRowChanges.put("inserted", Utils.createJSONFromTrackInfo((com.openexchange.office.ooxml.docx.DocxOperationDocument)createOperationHelper.getOperationDocument(), trPr.getIns()));
                }
                if(trPr.getTrPrChange()!=null) {
                	JSONObject rowModified = Utils.createJSONFromTrackInfo((com.openexchange.office.ooxml.docx.DocxOperationDocument)createOperationHelper.getOperationDocument(), trPr.getTrPrChange());
                	final CTTrPrBase trPrChangePr = trPr.getTrPrChange().getTrPr();
                	if(trPrChangePr!=null) {
                		final JSONObject jsonRowAttrChanges = new JSONObject();
                		Table.createRowProperties(trPrChangePr, jsonRowAttrChanges);
                		if(!jsonRowAttrChanges.isEmpty()) {
                			rowModified.put("attrs", jsonRowAttrChanges);
                		}
                	}
                	if(!rowModified.isEmpty()) {
                    	jsonRowChanges.put("modified", rowModified);
                	}
                }
                if(!jsonRowChanges.isEmpty()) {
                	attrs.put("changes", jsonRowChanges);
                }
            }
        }
        return attrs;
	}

	// IRow interface
	@Override
	public void insertCells(com.openexchange.office.ooxml.OperationDocument operationDocument, int cellPosition, int count, JSONObject attrs)
	    throws JAXBException, JSONException, InvalidFormatException, PartUnrecognisedException {

    	Component c = getChildComponent(cellPosition);
    	final Tr tr = (Tr)getObject();
        final IndexedNodeList<Object> trContent = tr.getContent();
        for (int i=0; i<count; i++) {
            final Tc tc = Context.getWmlObjectFactory().createTc();
            tc.setParent(tr);
            trContent.addNode(c!=null?c.getNode():null, new IndexedNode<Object>(tc), true);
        }
        if(attrs!=null) {
            c = getChildComponent(cellPosition);
            for(int i=0; i<count; i++) {
            	c.applyAttrsFromJSON(operationDocument, attrs);
            	c = c.getNextComponent();
            }
        }
	}
}
