/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ooxml.docx;

import java.io.InputStream;
import java.util.Map;

import org.apache.commons.io.IOUtils;
import org.docx4j.jaxb.Context;
import org.json.JSONObject;

import com.openexchange.office.DocumentProperties;
import com.openexchange.office.FilterException;
import com.openexchange.office.IImporter;
import com.openexchange.office.IPartImporter;
import com.openexchange.server.ServiceLookup;
import com.openexchange.session.Session;

/**
 * {@link Importer}
 *
 * @author <a href="mailto:sven.jacobi@open-xchange.com">Sven Jacobi</a>
 */
public class Importer implements IImporter, IPartImporter {

    final ServiceLookup services;

    /**
     * Initializes a new {@link Importer}.
     */
    public Importer(ServiceLookup _services) {
        super();
        services = _services;
        Context.getWmlObjectFactory();
    }

    /*
     * (non-Javadoc)
     * @see com.openexchange.office.IImporter#createOperations(java.io.InputStream)
     */
    @Override
    public JSONObject createOperations(Session session, InputStream inputDocumentStm, DocumentProperties documentProperties)
        throws FilterException {

        DocxOperationDocument operationDocument = null;
        try {
            boolean debugGetDefaultDocument = false;
            if(debugGetDefaultDocument) {   // just a simple helper method to store our in memory created
                final DocxOperationDocument emptyDoc = new DocxOperationDocument(services, documentProperties);
                emptyDoc.writeFile("/tmp/default.oxt");    // template documents...
            }
            operationDocument = new DocxOperationDocument(session, services, inputDocumentStm, null, documentProperties);
            return operationDocument.getOperations();
        }
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        }
    }

    @Override
    public InputStream getDefaultDocument(InputStream templateDocument, DocumentProperties documentProperties)
        throws FilterException {

        DocxOperationDocument operationDocument = null;
        try {
        	operationDocument =
        		templateDocument!=null
        		? new DocxOperationDocument(null, null, templateDocument, null, documentProperties)
        		: new DocxOperationDocument(services, documentProperties);
        	operationDocument.applyDefaultDocumentProperties();
        	return operationDocument.save();
        }
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        	IOUtils.closeQuietly(templateDocument);
        }
    }

	@Override
	public void initPartitioning(Session session, InputStream inputDocument, DocumentProperties documentProperties)
		throws FilterException {

		DocxOperationDocument operationDocument = null;
        try {
            operationDocument = new DocxOperationDocument(session, services, inputDocument, null, documentProperties);
            documentProperties.put(DocumentProperties.PROP_DOCUMENT, operationDocument);
        }
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        }
	}

	@Override
	public Map<String, Object> getMetaData(DocumentProperties documentProperties)
		throws FilterException {

		DocxOperationDocument operationDocument = null;
	    try {
			operationDocument = (DocxOperationDocument)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
            operationDocument.registerMemoryListener();
	        return operationDocument.getMetaData();
		}
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        }
	}

	@Override
	public Map<String, Object> getActivePart(DocumentProperties documentProperties)
		throws FilterException {

		DocxOperationDocument operationDocument = null;
	    try {
			operationDocument = (DocxOperationDocument)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
            operationDocument.registerMemoryListener();
	        return operationDocument.getActivePart();
		}
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        }
	}

	@Override
	public Map<String, Object> getNextPart(DocumentProperties documentProperties)
		throws FilterException {

		DocxOperationDocument operationDocument = null;
	    try {
			operationDocument = (DocxOperationDocument)documentProperties.get(DocumentProperties.PROP_DOCUMENT);
            operationDocument.registerMemoryListener();
	        return operationDocument.getNextPart();
		}
        catch(Throwable e) {
        	throw DocxOperationDocument.getRethrowException(e);
        }
        finally {
            if(operationDocument!=null) {
                operationDocument.removeMemoryListener();
            }
        }
	}
}
