/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odt.dom;

import org.apache.xml.serializer.SerializationHandler;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.Namespaces;
import com.openexchange.office.odf.SaxContextHandler;

public class Column implements IElementWriter, Cloneable {

	private String defaultCellStyleName;
	private String styleName;
	private String visibility;
	private String id;

	public Column() {
	}

	public Column(Attributes attributes) {
		defaultCellStyleName = attributes.getValue("table:default-cell-style-name");
		styleName = attributes.getValue("table:style-name");
		visibility = attributes.getValue("table:visibility");
		id = attributes.getValue("xml:id");
	}

	public String getStyleName() {
		return styleName;
	}

	public void setStyleName(String styleName) {
		this.styleName = styleName;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.startElement(output, Namespaces.TABLE, "table-column", "table:table-column");
		SaxContextHandler.addAttribute(output, Namespaces.TABLE, "default-cell-style-name", "table:default-cell-style-name", defaultCellStyleName);
		SaxContextHandler.addAttribute(output, Namespaces.TABLE, "style-name", "table:style-name", styleName);
		SaxContextHandler.addAttribute(output, Namespaces.TABLE, "visibility", "table:visibility", visibility);
		SaxContextHandler.addAttribute(output, Namespaces.XML, "id", "xml:id", id);
		SaxContextHandler.endElement(output, Namespaces.TABLE, "table-column", "table:table-column");
	}

	@Override
	public Column clone() {
		final Column clone = new Column();
		clone.defaultCellStyleName = defaultCellStyleName;
		clone.styleName = styleName;
		clone.visibility = visibility;
		return clone;
	}
}
