/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

package com.openexchange.office.ods.dom;

import org.json.JSONArray;

import com.openexchange.office.ods.dom.SmlUtils.CellRef;
import com.openexchange.office.ods.dom.SmlUtils.CellRefRange;

public class Range implements ICellRefRangeAccess, Cloneable {

	private int sheet;
	private CellRefRange cellRefRange;

	public Range(Content content, String rangeAddress) {
		sheet = -1;
		setRangeAddress(content, rangeAddress);
	}

	public Range(int sheet, CellRefRange cellRefRange) {
		this.sheet = sheet;
		this.cellRefRange = cellRefRange;
	}

	public Range(int sheetIndex, JSONArray start, JSONArray end) {
		this.sheet = sheetIndex;
		this.cellRefRange = new CellRefRange(new CellRef(start), new CellRef(end));
	}

	@Override
	public SmlUtils.CellRefRange getCellRefRange() {
		return cellRefRange;
	}

    @Override
	public void setCellRefRange(SmlUtils.CellRefRange cellRefRange) {
    	this.cellRefRange = cellRefRange;
    }

    public int getSheetIndex() {
		return sheet;
	}

	public void setSheetIndex(int index) {
		sheet = index;
	}

	public String convertToString(Content content, boolean createSheetRef) {

		String sheetName = createSheetRef&&sheet>=0 ?	content.getSheets().get(sheet).getSheetName() : null;
		if(sheetName!=null) {
			if(sheetName.matches(".*[\\. ].*")) {
				sheetName = '\'' + sheetName + '\'';
			}
			return new StringBuffer().append(sheetName)
						 			 .append(".")
						 			 .append(SmlUtils.getCellRef(cellRefRange.getStart()))
						 			 .append(":")
						 			 .append(sheetName)
						 			 .append(".")
						 			 .append(SmlUtils.getCellRef(cellRefRange.getEnd())).toString();
		}
		else {
			return new StringBuffer().append(SmlUtils.getCellRef(cellRefRange.getStart()))
									 .append(":")
									 .append(SmlUtils.getCellRef(cellRefRange.getEnd())).toString();
		}
	}

    private void setRangeAddress(Content content, String value) {

    	CellRef start = new CellRef(0, 0);
    	CellRef end = new CellRef(0, 0);

    	if(value!=null) {
	    	final String[] refs = value.split(":");
	    	if(refs.length<=2) {
		    	int i;
		    	for(i=0;i<refs.length;i++) {
		    		final String ref = refs[i];
		    		int index = ref.lastIndexOf(".");
		    		if(i==0&&index>0) {
						sheet = content.getSheetIndex(ref.substring(0, index));
		    		}
		    		final CellRef cRef = SmlUtils.createCellRef(ref.substring(index+1));
		    		if(cRef!=null) {
			    		if(i==0) {
			    			start = cRef;
			    		}
			    		else {
			    			end = cRef;
			    		}
		    		}
		    	}
		    	if(i==1) {
		    		end = (CellRef)start.clone();
		    	}
	    	}
    	}
    	cellRefRange = new CellRefRange(start, end);
    }

	@Override
	public Range clone() throws CloneNotSupportedException {
		return new Range(sheet, cellRefRange.clone());
	}

	@Override
	public String toString() {
		return "Range [sheet=" + sheet + ", cellRefRange=" + cellRefRange + "]";
	}
}
