/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf.styles;

import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.ElementNSWriter;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.odf.UnknownContentHandler;

public class StyleMasterPageHandler extends SaxContextHandler {

	final StyleManager styleManager;
	final StyleMasterPage styleMasterPage;

	public StyleMasterPageHandler(SaxContextHandler parentContext, StyleMasterPage styleMasterPage, StyleManager styleManager) {
		super(parentContext);

		this.styleManager = styleManager;
		this.styleMasterPage = styleMasterPage;
	}

	@Override
    public SaxContextHandler startElement(Attributes attributes, String uri, String localName, String qName)
    	throws SAXException {

		StyleHeaderFooter styleHeaderFooter = null;
		if(qName.equals("style:header")) {
			styleHeaderFooter = new StyleHeaderFooter("header_default_Standard", "header_default", attributes);
		}
		else if(qName.equals("style:header-left")) {
			styleHeaderFooter = new StyleHeaderFooter("header_even_Standard", "header_even", attributes);
		}
		else if(qName.equals("style:header-first")) {
			styleHeaderFooter = new StyleHeaderFooter("header_first_Standard", "header_first", attributes);
		}
		else if(qName.equals("style:footer")) {
			styleHeaderFooter = new StyleHeaderFooter("footer_default_Standard", "footer_default", attributes);
		}
		else if(qName.equals("style:footer-left")) {
			styleHeaderFooter = new StyleHeaderFooter("footer_even_Standard", "footer_even", attributes);
		}
		else if(qName.equals("style:footer-first")) {
			styleHeaderFooter = new StyleHeaderFooter("footer_first_Standard", "footer_first", attributes);
		}
		if(styleHeaderFooter!=null) {
			styleMasterPage.getStyleHeaderFooters().add(styleHeaderFooter);
			getFileDom().getTargetNodes().put(styleHeaderFooter.getId(), styleHeaderFooter);
			return new StyleHeaderFooterHandler(this, styleHeaderFooter);
		}
    	final ElementNSWriter element = new ElementNSWriter(getFileDom(), attributes, uri, qName);
    	styleMasterPage.getContent().add(element);
		return new UnknownContentHandler(this, element);
    }

    @Override
	public void endContext(String qName, String characters) {
		super.endContext(qName, characters);

		styleManager.addStyle(styleMasterPage);
	}
}
