/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf.properties;

import java.util.Iterator;

import org.apache.xml.serializer.SerializationHandler;
import org.json.JSONException;
import org.json.JSONObject;
import org.odftoolkit.odfdom.IElementWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

import com.openexchange.office.odf.AttributesImpl;
import com.openexchange.office.odf.DLList;
import com.openexchange.office.odf.OpAttrs;
import com.openexchange.office.odf.SaxContextHandler;
import com.openexchange.office.odf.styles.StyleManager;

public abstract class StylePropertiesBase implements IElementWriter, Cloneable {

	protected AttributesImpl attributes;
	protected String text = "";

	protected StylePropertiesBase(AttributesImpl attributesImpl) {
		this.attributes = attributesImpl;
	}

	public StylePropertiesBase setAttributes(Attributes attributes) {
		this.attributes.setAttributes(attributes);
		return this;
	}

	public void setTextContent(String text) {
		this.text = text;
	}

	public String getTextContent() {
		return text;
	}

	@Override
	public void writeObject(SerializationHandler output)
		throws SAXException {

		if(!attributes.isEmpty()||(getContent()!=null&&!getContent().isEmpty())||!getTextContent().isEmpty()) {
			SaxContextHandler.startElement(output, getNamespace(), getLocalName(), getQName());
			attributes.write(output);
			if(!text.isEmpty()) {
				output.characters(text);
			}
			final DLList<IElementWriter> content = getContent();
			if(content!=null) {
				final Iterator<IElementWriter> childIter = content.iterator();
				while(childIter.hasNext()) {
					childIter.next().writeObject(output);
				}
			}
			SaxContextHandler.endElement(output, getNamespace(), getLocalName(), getQName());
		}
	}

	public DLList<IElementWriter> getContent() {
		return null;
	}

	public String getAttribute(String qName) {
		return attributes.getValue(qName);
	}

	public Boolean getBoolean(String qName, Boolean defaultValue) {
		return attributes.getBooleanValue(qName, defaultValue);
	}

	public Integer getInteger(String qName, Integer defaultValue) {
		final Integer ret = attributes.getIntValue(qName);
		return ret!=null ? ret : defaultValue;
	}

	public AttributesImpl getAttributes() {
		return attributes;
	}

	public void mergeAttrs(StylePropertiesBase propertiesBase) {
	}

	public abstract void applyAttrs(StyleManager styleManager, JSONObject attrs)
		throws JSONException;

	public abstract void createAttrs(StyleManager styleManager, boolean contentAutoStyle, OpAttrs attrs);

	@Override
	public int hashCode() {
		return ((getContent()==null||getContent().isEmpty()) ? 0 : getContent().hashCode() + attributes.hashCode() + getQName().hashCode());
	}

	@Override
	abstract protected Object clone();

	protected Object _clone() {
		try {
			final StylePropertiesBase clone = (StylePropertiesBase)super.clone();
			clone.attributes = attributes.clone();
			return clone;
		} catch (CloneNotSupportedException e) {
			throw new RuntimeException(e);
		}
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final StylePropertiesBase other = (StylePropertiesBase)obj;
		if (!attributes.equals(other.attributes))
			return false;
		final DLList<IElementWriter> content = getContent();
		if (content == null || content.isEmpty()) {
			if (other.getContent() != null && !other.getContent().isEmpty())
				return false;
		} else if (!content.equals(other.getContent()))
			return false;
		return true;
	}

	abstract public String getQName();

	abstract public String getLocalName();

	abstract public String getNamespace();
}
