/*
 *
 *    OPEN-XCHANGE legal information
 *
 *    All intellectual property rights in the Software are protected by
 *    international copyright laws.
 *
 *
 *    In some countries OX, OX Open-Xchange, open xchange and OXtender
 *    as well as the corresponding Logos OX Open-Xchange and OX are registered
 *    trademarks.
 *    The use of the Logos is not covered by the GNU General Public License.
 *    Instead, you are allowed to use these Logos according to the terms and
 *    conditions of the Creative Commons License, Version 2.5, Attribution,
 *    Non-commercial, ShareAlike, and the interpretation of the term
 *    Non-commercial applicable to the aforementioned license is published
 *    on the web site http://www.open-xchange.com/EN/legal/index.html.
 *
 *    Please make sure that third-party modules and libraries are used
 *    according to their respective licenses.
 *
 *    Any modifications to this package must retain all copyright notices
 *    of the original copyright holder(s) for the original code used.
 *
 *    After any such modifications, the original and derivative code shall remain
 *    under the copyright of the copyright holder(s) and/or original author(s)per
 *    the Attribution and Assignment Agreement that can be located at
 *    http://www.open-xchange.com/EN/developer/. The contributing author shall be
 *    given Attribution for the derivative code and a license granting use.
 *
 *     Copyright (C) 2016 OX Software GmbH
 *     Mail: info@open-xchange.com
 *
 *
 *     This program is free software; you can redistribute it and/or modify it
 *     under the terms of the GNU General Public License, Version 2 as published
 *     by the Free Software Foundation.
 *
 *     This program is distributed in the hope that it will be useful, but
 *     WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 *     or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License
 *     for more details.
 *
 *     You should have received a copy of the GNU General Public License along
 *     with this program; if not, write to the Free Software Foundation, Inc., 59
 *     Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

/**
 * @author sven.jacobi@open-xchange.com
 */

package com.openexchange.office.odf;

import org.apache.xml.serializer.SerializationHandler;
import org.xml.sax.SAXException;

final public class AttributeImpl implements Cloneable {

	final private String uri;
	final private String qName;
	final private String localName;
	final private String value;
	final private int hash;

	public AttributeImpl(String uri, String qName, String localName, String value) {
		this.uri = uri;
		this.qName = qName;
		this.localName = localName;
		this.value = value;

		final int prime = 31;
		int result = 1;
		result = prime * result + localName.hashCode();
		result = prime * result + qName.hashCode();
		result = prime * result + uri.hashCode();
		hash = prime * result + value.hashCode();
	}

	public String getUri() {
		return uri;
	}

	public String getQName() {
		return qName;
	}

	public String getLocalName() {
		return localName;
	}

	public String getValue() {
		return value;
	}

	public int getIntValue() {
		int i = 0;
		try {
			i = Integer.parseInt(value);
		}
		catch (NumberFormatException e) {}

		return i;
	}

	public void write(SerializationHandler output)
		throws SAXException {

		SaxContextHandler.addAttribute(output, getUri(), getLocalName(), getQName(), getValue());
	}

	@Override
	public AttributeImpl clone() {
		return this;
	}

	@Override
	public int hashCode() {
		return hash;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		AttributeImpl other = (AttributeImpl) obj;
		if (hashCode() != other.hashCode()) {
			return false;
		}
		if (!localName.equals(other.localName))
			return false;
		if (!qName.equals(other.qName))
			return false;
		if (!uri.equals(other.uri))
			return false;
		if (!value.equals(other.value))
			return false;
		return true;
	}
}
