/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */

package org.docx4j.openpackaging.parts.WordprocessingML;

import java.util.HashSet;
import java.util.List;

import org.docx4j.jaxb.Context;
import org.docx4j.openpackaging.exceptions.InvalidFormatException;
import org.docx4j.openpackaging.parts.Part;
import org.docx4j.openpackaging.parts.PartName;
import org.docx4j.openpackaging.parts.relationships.Namespaces;
import org.docx4j.wml.ContentAccessor;

/**
 * @author jharrop
 *
 */
public class MainDocumentPart extends DocumentPart<org.docx4j.wml.Document> implements ContentAccessor  {

	@SuppressWarnings("serial")
    static HashSet<String> ignorables = new HashSet<String>(1) {{
        add("w:tblDescription");
	}};
	public MainDocumentPart(PartName partName) throws InvalidFormatException {
		super(partName);
		init();
	}
	public MainDocumentPart() throws InvalidFormatException {
		super(new PartName("/word/document.xml"));
		init();
	}

	@Override
	protected HashSet<String> getIgnorables() {
	    return ignorables;
	}

	public void init() {
		// Used if this Part is added to [Content_Types].xml
		setContentType(new  org.docx4j.openpackaging.contenttype.ContentType(
				org.docx4j.openpackaging.contenttype.ContentTypes.WORDPROCESSINGML_DOCUMENT));

		/*
		 * From [MS-OE376]
		 *
		 * 2.1.8 Part 1 Section 11.3.10, Main Document Part
		 *
		 * a. The standard states that the content type for the Main Document part is:
		 *
		 *        application/vnd.openxmlformats-officedocument.wordprocessingml.main+xml.
		 *
		 *    Office uses the following content type for the Main Document part:
		 *
		 *        application/vnd.openxmlformats-officedocument.wordprocessingml.document.main+xml.
		 *
		 * This note applies to the following products: 2007, 2007 SP1, 2007 SP2.
		 */

		// Used when this Part is added to a rels
		setRelationshipType(Namespaces.DOCUMENT);
	}

	@Override
	protected void setMceIgnorable() {

		MainDocumentPartMceIgnorableHelper helper = new MainDocumentPartMceIgnorableHelper();
		this.jaxbElement.setIgnorable(
				helper.getMceIgnorable(this.getJaxbElement().getBody()));
	}

    /**
     * Convenience method to getJaxbElement().getBody().getContent()
     * @since 2.7
     */
    public List<Object> getContent() {

    	if (this.getJaxbElement()==null) {
    		this.setJaxbElement( Context.getWmlObjectFactory().createDocument() );
    	}
    	if (this.getJaxbElement().getBody()==null) {
    		this.getJaxbElement().setBody(
    				Context.getWmlObjectFactory().createBody() );
    	}

    	return this.getJaxbElement().getContent();
    }

	GlossaryDocumentPart glossaryDocumentPart;
	/**
	 * @since 3.0.0
	 */
	public GlossaryDocumentPart getGlossaryDocumentPart() {
		return glossaryDocumentPart;
	}

	@Override
	public boolean setPartShortcut(Part part, String relationshipType) {

		if (relationshipType.equals(Namespaces.GLOSSARY_DOCUMENT)) {
			glossaryDocumentPart = (GlossaryDocumentPart)part;
			return true;
		} else {
			return super.setPartShortcut(part, relationshipType);
		}
	}
}


