/*
 *  Copyright 2007-2008, Plutext Pty Ltd.
 *
 *  This file is part of docx4j.

    docx4j is licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.

    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

 */


package org.docx4j.dml.chart;

import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlType;

import org.docx4j.jaxb.Context;


/**
 * <p>Java class for CT_BarChart complex type.
 *
 * <p>The following schema fragment specifies the expected content contained within this class.
 *
 * <pre>
 * &lt;complexType name="CT_BarChart">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;group ref="{http://schemas.openxmlformats.org/drawingml/2006/chart}EG_BarChartShared"/>
 *         &lt;element name="gapWidth" type="{http://schemas.openxmlformats.org/drawingml/2006/chart}CT_GapAmount" minOccurs="0"/>
 *         &lt;element name="overlap" type="{http://schemas.openxmlformats.org/drawingml/2006/chart}CT_Overlap" minOccurs="0"/>
 *         &lt;element name="serLines" type="{http://schemas.openxmlformats.org/drawingml/2006/chart}CT_ChartLines" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="axId" type="{http://schemas.openxmlformats.org/drawingml/2006/chart}CT_UnsignedInt" maxOccurs="2" minOccurs="2"/>
 *         &lt;element name="extLst" type="{http://schemas.openxmlformats.org/drawingml/2006/chart}CT_ExtensionList" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 *
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "CT_BarChart", propOrder = {
    "barDir",
    "grouping",
    "varyColors",
    "ser",
    "dLbls",
    "gapWidth",
    "overlap",
    "serLines",
    "axId",
    "extLst"
})
public class CTBarChart implements IListSer {

    @XmlElement(required = true)
    protected CTBarDir barDir;
    protected CTBarGrouping grouping;
    protected CTBoolean varyColors;
    @XmlElements({
        @XmlElement(name = "ser", type = CTBarSer.class)
    })
    protected List<ISerContent> ser;
    protected CTDLbls dLbls;
    protected CTGapAmount gapWidth;
    protected CTOverlap overlap;
    protected List<CTChartLines> serLines;
    @XmlElement(required = true)
    protected List<CTUnsignedInt> axId;
    protected CTExtensionList extLst;

    /**
     * Gets the value of the barDir property.
     *
     * @return
     *     possible object is
     *     {@link CTBarDir }
     *
     */
    public CTBarDir getBarDir() {
        return barDir;
    }

    /**
     * Sets the value of the barDir property.
     *
     * @param value
     *     allowed object is
     *     {@link CTBarDir }
     *
     */
    public void setBarDir(CTBarDir value) {
        this.barDir = value;
    }

    /**
     * Gets the value of the grouping property.
     *
     * @return
     *     possible object is
     *     {@link CTBarGrouping }
     *
     */
    public CTBarGrouping getGrouping() {
        return grouping;
    }

    @Override
    public String getStacking() {
        if (null == grouping) { return null;}
        return grouping.getVal().value();
    }

    @Override
    public void setStacking(String stacking) {
        if(grouping==null) {
            grouping = new CTBarGrouping();
        }
        grouping.setVal(STBarGrouping.fromValue(stacking));
    }


    /**
     * Sets the value of the grouping property.
     *
     * @param value
     *     allowed object is
     *     {@link CTBarGrouping }
     *
     */
    public void setGrouping(CTBarGrouping value) {
        this.grouping = value;
    }

    /**
     * Gets the value of the varyColors property.
     *
     * @return
     *     possible object is
     *     {@link CTBoolean }
     *
     */
    @Override
    public CTBoolean getVaryColors() {
        return varyColors;
    }

    /**
     * Sets the value of the varyColors property.
     *
     * @param value
     *     allowed object is
     *     {@link CTBoolean }
     *
     */
    @Override
    public void setVaryColors(CTBoolean value) {
        this.varyColors = value;
    }

    /**
     * Gets the value of the ser property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the ser property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSer().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTBarSer }
     *
     *
     */
    @Override
    public List<ISerContent> getSer() {
        if (ser == null) {
            ser = new ArrayList<ISerContent>();
        }
        return this.ser;
    }

    @Override
    public CTBarSer createSer() {
        return Context.getDmlChartObjectFactory().createCTBarSer();
    }

    /**
     * Gets the value of the dLbls property.
     *
     * @return
     *     possible object is
     *     {@link CTDLbls }
     *
     */
    @Override
    public CTDLbls getDLbls() {
        return dLbls;
    }

    /**
     * Sets the value of the dLbls property.
     *
     * @param value
     *     allowed object is
     *     {@link CTDLbls }
     *
     */
    @Override
    public void setDLbls(CTDLbls value) {
        this.dLbls = value;
    }

    /**
     * Gets the value of the gapWidth property.
     *
     * @return
     *     possible object is
     *     {@link CTGapAmount }
     *
     */
    public CTGapAmount getGapWidth() {
        return gapWidth;
    }

    /**
     * Sets the value of the gapWidth property.
     *
     * @param value
     *     allowed object is
     *     {@link CTGapAmount }
     *
     */
    public void setGapWidth(CTGapAmount value) {
        this.gapWidth = value;
    }

    /**
     * Gets the value of the overlap property.
     *
     * @return
     *     possible object is
     *     {@link CTOverlap }
     *
     */
    public CTOverlap getOverlap() {
        return overlap;
    }

    /**
     * Sets the value of the overlap property.
     *
     * @param value
     *     allowed object is
     *     {@link CTOverlap }
     *
     */
    public void setOverlap(CTOverlap value) {
        this.overlap = value;
    }

    /**
     * Gets the value of the serLines property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the serLines property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getSerLines().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTChartLines }
     *
     *
     */
    public List<CTChartLines> getSerLines() {
        if (serLines == null) {
            serLines = new ArrayList<CTChartLines>();
        }
        return this.serLines;
    }

    /**
     * Gets the value of the axId property.
     *
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the axId property.
     *
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getAxId().add(newItem);
     * </pre>
     *
     *
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link CTUnsignedInt }
     *
     *
     */
    @Override
    public List<CTUnsignedInt> getAxId() {
        if (axId == null) {
            axId = new ArrayList<CTUnsignedInt>();
        }
        return this.axId;
    }

    /**
     * Gets the value of the extLst property.
     *
     * @return
     *     possible object is
     *     {@link CTExtensionList }
     *
     */
    public CTExtensionList getExtLst() {
        return extLst;
    }

    /**
     * Sets the value of the extLst property.
     *
     * @param value
     *     allowed object is
     *     {@link CTExtensionList }
     *
     */
    public void setExtLst(CTExtensionList value) {
        this.extLst = value;
    }

    @Override
    public String getBarDirection() {
        return barDir.val.value();
    }

    @Override
    public void setBarDirection(String barDirection) {
        barDir = new CTBarDir();
        barDir.val = STBarDir.fromValue(barDirection);
    }
}
