/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/tk/config'
], function (Config) {

    'use strict';

    // static class Config ====================================================

    describe('Toolkit module Config', function () {

        it('should exist', function () {
            expect(Config).to.be.an('object');
        });

        // constants ----------------------------------------------------------

        describe('constant "LOCALE"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('LOCALE').that.is.a('string');
            });
        });

        describe('constant "LANGUAGE"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('LANGUAGE').that.matches(/^[a-z]{2,}$/);
                expect(Config.LANGUAGE).to.equal(Config.LOCALE.substr(0, Config.LANGUAGE.length));
            });
        });

        describe('constant "COUNTRY"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('COUNTRY').that.matches(/^[A-Z]{2,}$/);
                expect(Config.COUNTRY).to.equal(Config.LOCALE.substr(-Config.COUNTRY.length));
            });
        });

        describe('constant "DEBUG"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('DEBUG').that.is.a('boolean');
            });
        });

        describe('constant "AUTOTEST"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('AUTOTEST').that.is.a('boolean');
            });
        });

        describe('constant "UNITTEST"', function () {
            it('should exist', function () {
                expect(Config).to.have.a.property('UNITTEST', true);
            });
        });

        // static methods -----------------------------------------------------

        describe('method "get"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('get');
            });
            it('should return something', function () {
                expect(Config.get('notExist', 'defaultValue')).to.equal('defaultValue');
            });
        });

        describe('method "set"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('set');
            });
        });

        describe('method "getFlag"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('getFlag');
            });
            it('should return something', function () {
                expect(Config.getFlag('notExist', false)).to.equal(false);
            });
        });

        describe('method "getUrlFlag"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('getUrlFlag');
            });
            it('should return something', function () {
                expect(Config.getUrlFlag('notExist', false)).to.equal(false);
            });
        });

        describe('method "getDebugUrlFlag"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('getDebugUrlFlag');
            });
            it('should return something', function () {
                expect(Config.getDebugUrlFlag('notExist', false)).to.equal(false);
            });
        });

        describe('method "getDebugState"', function () {
            it('should exist', function () {
                expect(Config).itself.to.respondTo('getDebugState');
            });
            it('should return something', function () {
                expect(Config.getDebugState('notExist', 'notExist')).to.equal(false);
            });
        });
    });

    // ========================================================================
});
