/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/model/paragraphmixin'
], function (AppHelper, ParagraphMixin) {

    'use strict';

    // class ParagraphMixin =============================================

    describe('TextFramework class ParagraphMixin', function () {

        // private helpers ----------------------------------------------------

        // the operations to be applied by the document model
        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 } } },
            { name: 'insertParagraph', start: [0] },
            { name: 'insertText', start: [0, 0], text: 'Hello World!' },
            { name: 'insertParagraph', start: [1] },
            { name: 'insertText', start: [1, 0], text: 'Hello Earth!' }
        ];

        var model;
        AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
            model = app.getModel();
        });

        // existence check ----------------------------------------------------

        it('should exist', function () {
            expect(ParagraphMixin).to.be.a('function');
        });

        // public methods -----------------------------------------------------

        describe('method "insertParagraphHandler"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('insertParagraphHandler');
            });
            it('should insert a paragraph', function () {
                expect(model.insertParagraphHandler({ name: 'insertParagraph', start: [3] })).to.equal(false);
                expect(model.insertParagraphHandler({ name: 'insertParagraph', start: [2] })).to.equal(true);
            });
        });

        describe('method "mergeParagraphHandler"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('mergeParagraphHandler');
            });
            it('should merge two paragraphs', function () {
                expect(model.mergeParagraphHandler({ name: 'mergeParagraph', start: [2] })).to.equal(false);
                expect(model.mergeParagraphHandler({ name: 'mergeParagraph', start: [1] })).to.equal(true);
            });
        });

        describe('method "splitParagraphHandler"', function () {
            it('should exist', function () {
                expect(model).to.respondTo('splitParagraphHandler');
            });
            it('should split a paragraph', function () {
                expect(model.splitParagraphHandler({ name: 'splitParagraph', start: [2, 0] })).to.equal(false);
                expect(model.splitParagraphHandler({ name: 'splitParagraph', start: [1, 13] })).to.equal(false);
                expect(model.splitParagraphHandler({ name: 'splitParagraph', start: [1, 12] })).to.equal(true);
                expect(model.splitParagraphHandler({ name: 'splitParagraph', start: [0, 0] })).to.equal(true);
            });
        });
    });

    // ========================================================================
});
