/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author York Richter <york.richter@open-xchange.com>
 */

define([
    'globals/apphelper',
    'io.ox/office/textframework/components/searchhandler/searchhandler',
    'io.ox/office/textframework/utils/position'
], function (AppHelper, SearchHandler, Position) {

    'use strict';

    // class Searchhandler ===========================================

    describe('Text class Searchhandler', function () {

        var OPERATIONS = [
            { name: 'setDocumentAttributes', attrs: { document: { defaultTabStop: 1270, zoom: { value: 100 } }, page: { width: 21590, height: 27940, marginLeft: 2540, marginTop: 2540, marginRight: 2540, marginBottom: 2540, marginHeader: 1248, marginFooter: 1248 } } },
            { name: 'insertParagraph', start: [0] },
            { name: 'insertText', start: [0, 0], text: 'Hello World!' },
            { name: 'insertParagraph', start: [1] },
            { name: 'insertText', start: [1, 0], text: 'Hello Earth!' }
        ];

        var model,
            searchHandler = null,
            firstParagraph,
            secondParagraph;

        AppHelper.createTextApp('ooxml', OPERATIONS).done(function (app) {
            model = app.getModel();
            searchHandler = model.getSearchHandler();
            var node = model.getNode();
            firstParagraph  = Position.getParagraphElement(node, [0]);
            secondParagraph  = Position.getParagraphElement(node, [1]);

        });

        it('should exist', function () {
            expect(SearchHandler).to.be.a('function');
        });

        describe('method "reset"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('reset');
            });
        });

        describe('method "removeHighlighting"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('removeHighlighting');
            });
        });

        describe('method "removeSpansHighlighting"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('removeSpansHighlighting');
            });
        });

        describe('method "selectNextSearchResult"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('selectPreviousSearchResult');
            });
        });

        describe('method "selectPreviousSearchResult"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('selectPreviousSearchResult');
            });
        });

        describe('method "replaceSearchResult"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('replaceSearchResult');
            });
        });

        describe('method "replaceSelectedSearchResult"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('replaceSelectedSearchResult');
            });
        });

        describe('method "debouncedQuickSearch"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('debouncedQuickSearch');
            });
        });

        describe('method "quickSearch"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('quickSearch');
            });

            it('should exist', function () {
                expect(searchHandler).to.respondTo('reset');
                searchHandler.reset();
            });

            it('without query should return false', function () {
                expect(searchHandler.quickSearch()).to.eql(false);
            });

            it('with query "x" should return false', function () {
                expect(searchHandler.quickSearch()).to.eql(false);
            });
            it('with query "Hello" should return true', function () {
                expect(searchHandler.quickSearch('Hello', 0)).to.eql(true);
            });

            it('should highlight first span of the two paragraphs', function () {
                expect($(firstParagraph).children('.highlight').length).to.equal(1);
                expect($(secondParagraph).children('.highlight').length).to.equal(1);
            });

            it('should not highlight first span of the two paragraphs', function () {
                searchHandler.reset();
                expect($(firstParagraph).children('.highlight').length).to.equal(0);
                expect($(secondParagraph).children('.highlight').length).to.equal(0);
            });

            it('search "Hello" and replace it with "001100"', function () {
                searchHandler.searchAndReplaceAll('Hello', '001100');
                expect(searchHandler.quickSearch('Hello', 0)).to.eql(false);
                expect(searchHandler.quickSearch('001100', 0)).to.eql(true);
                expect($(firstParagraph).children('.highlight').length).to.equal(1);
                expect($(secondParagraph).children('.highlight').length).to.equal(1);
            });
        });

        describe('method "searchAndReplaceAll"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('searchAndReplaceAll');
            });
        });

        describe('method "clearHighlighting"', function () {
            it('should exist', function () {
                expect(searchHandler).to.respondTo('clearHighlighting');
            });
        });

    });

    // ========================================================================
});
