/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/spreadsheet/utils/errorcode',
    'io.ox/office/spreadsheet/utils/address',
    'io.ox/office/spreadsheet/utils/interval',
    'io.ox/office/spreadsheet/utils/range',
    'io.ox/office/spreadsheet/utils/range3d',
    'io.ox/office/spreadsheet/utils/addressarray',
    'io.ox/office/spreadsheet/utils/intervalarray',
    'io.ox/office/spreadsheet/utils/rangearray',
    'io.ox/office/spreadsheet/utils/range3darray',
    'io.ox/office/spreadsheet/utils/addressset',
    'io.ox/office/spreadsheet/utils/intervalset',
    'io.ox/office/spreadsheet/utils/rangeset',
    'io.ox/office/spreadsheet/utils/changedescriptor',
    'io.ox/office/spreadsheet/utils/movedescriptor',
    'io.ox/office/spreadsheet/utils/sheetutils'
], function (ErrorCode, Address, Interval, Range, Range3D, AddressArray, IntervalArray, RangeArray, Range3DArray, AddressSet, IntervalSet, RangeSet, ChangeDescriptor, MoveDescriptor, SheetUtils) {

    'use strict';

    // static class SheetUtils ================================================

    describe('Spreadsheet module SheetUtils', function () {

        it('should exist', function () {
            expect(SheetUtils).to.be.an('object');
        });

        // helper classes -----------------------------------------------------

        describe('helper class ErrorCode', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('ErrorCode', ErrorCode);
            });
        });

        describe('helper class Address', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Address', Address);
            });
        });

        describe('helper class Interval', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Interval', Interval);
            });
        });

        describe('helper class Range', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range', Range);
            });
        });

        describe('helper class Range3D', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range3D', Range3D);
            });
        });

        describe('helper class AddressArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('AddressArray', AddressArray);
            });
        });

        describe('helper class IntervalArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('IntervalArray', IntervalArray);
            });
        });

        describe('helper class RangeArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('RangeArray', RangeArray);
            });
        });

        describe('helper class Range3DArray', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('Range3DArray', Range3DArray);
            });
        });

        describe('helper class AddressSet', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('AddressSet', AddressSet);
            });
        });

        describe('helper class IntervalSet', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('IntervalSet', IntervalSet);
            });
        });

        describe('helper class RangeSet', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('RangeSet', RangeSet);
            });
        });

        describe('helper class ChangeDescriptor', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('ChangeDescriptor', ChangeDescriptor);
            });
        });

        describe('helper class MoveDescriptor', function () {
            it('should exist', function () {
                expect(SheetUtils).to.have.a.property('MoveDescriptor', MoveDescriptor);
            });
        });

        // constants ----------------------------------------------------------

        describe('constant "MAX_NAME_LENGTH"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_NAME_LENGTH).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_FILL_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_FILL_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_AUTOFILL_COL_ROW_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_AUTOFILL_COL_ROW_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_MERGED_RANGES_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_MERGED_RANGES_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_UNMERGE_CELL_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_UNMERGE_CELL_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_CHANGE_COLS_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_CHANGE_COLS_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_CHANGE_ROWS_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_CHANGE_ROWS_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_SORT_LINES_COUNT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_SORT_LINES_COUNT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_CELL"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_CELL).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_EDIT"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_EDIT).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MAX_LENGTH_STANDARD_FORMULA"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_LENGTH_STANDARD_FORMULA).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MIN_CELL_SIZE"', function () {
            it('should exist', function () {
                expect(SheetUtils.MIN_CELL_SIZE).to.be.a('number').that.is.above(0);
            });
        });

        describe('constant "MIN_ZOOM"', function () {
            it('should exist', function () {
                expect(SheetUtils.MIN_ZOOM).to.be.a('number').that.is.above(0).and.below(1);
            });
        });

        describe('constant "MAX_ZOOM"', function () {
            it('should exist', function () {
                expect(SheetUtils.MAX_ZOOM).to.be.a('number').that.is.above(1);
            });
        });

        describe('constant "MULTI_SELECTION"', function () {
            it('should exist', function () {
                expect(SheetUtils.MULTI_SELECTION).to.be.a('boolean');
            });
        });

        // static methods -----------------------------------------------------

        describe('method "getNameKey"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getNameKey');
            });
            it('should return the map key of a defined name', function () {
                expect(SheetUtils.getNameKey('aBcDeF')).to.equal('ABCDEF');
                expect(SheetUtils.getNameKey('AbCdEf')).to.equal('ABCDEF');
            });
        });

        describe('method "getTableKey"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTableKey');
            });
            it('should return the map key of a table name', function () {
                expect(SheetUtils.getTableKey('aBcDeF')).to.equal('ABCDEF');
                expect(SheetUtils.getTableKey('AbCdEf')).to.equal('ABCDEF');
            });
        });

        describe('method "getSheetName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getSheetName');
            });
            it('should return the English sheet name', function () {
                expect(SheetUtils.getSheetName(1)).to.equal('Sheet1');
                expect(SheetUtils.getSheetName(2)).to.equal('Sheet2');
                expect(SheetUtils.getSheetName(100)).to.equal('Sheet100');
            });
        });

        describe('method "getTableName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTableName');
            });
            it('should return the English table name', function () {
                expect(SheetUtils.getTableName()).to.equal('Table');
            });
        });

        describe('method "getTableColName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTableColName');
            });
            it('should return the English column name', function () {
                expect(SheetUtils.getTableColName()).to.equal('Column');
            });
        });

        describe('method "hasWrappingAttributes"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('hasWrappingAttributes');
            });
            it('should return the correct result', function () {
                expect(SheetUtils.hasWrappingAttributes({ cell: { wrapText: false, alignHor: 'auto', alignVert: 'bottom' } })).to.equal(false);
                expect(SheetUtils.hasWrappingAttributes({ cell: { wrapText: true, alignHor: 'auto', alignVert: 'bottom' } })).to.equal(true);
                expect(SheetUtils.hasWrappingAttributes({ cell: { wrapText: false, alignHor: 'justify', alignVert: 'bottom' } })).to.equal(true);
                expect(SheetUtils.hasWrappingAttributes({ cell: { wrapText: false, alignHor: 'auto', alignVert: 'justify' } })).to.equal(true);
            });
        });

        describe('method "getTextOrientation"', function () {

            function getTextAlignment(value, align, display) {
                return SheetUtils.getTextOrientation(value, align, display).cssTextAlign;
            }

            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTextOrientation');
            });
            it('should return the correct cell text alignment for numbers', function () {
                expect(getTextAlignment(2, 'left', '2')).to.equal('left');
                expect(getTextAlignment(2, 'center', '2')).to.equal('center');
                expect(getTextAlignment(2, 'right', '2')).to.equal('right');
                expect(getTextAlignment(2, 'justify', '2')).to.equal('justify');
                expect(getTextAlignment(2, 'auto', '2')).to.equal('right');
            });
            it('should return the correct cell text alignment for strings', function () {
                expect(getTextAlignment('a', 'left', 'a')).to.equal('left');
                expect(getTextAlignment('a', 'center', 'a')).to.equal('center');
                expect(getTextAlignment('a', 'right', 'a')).to.equal('right');
                expect(getTextAlignment('a', 'justify', 'a')).to.equal('justify');
                expect(getTextAlignment('a', 'auto', 'a')).to.equal('left');
            });
            it('should return the correct cell text alignment for booleans', function () {
                expect(getTextAlignment(true, 'left', 'TRUE')).to.equal('left');
                expect(getTextAlignment(true, 'center', 'TRUE')).to.equal('center');
                expect(getTextAlignment(true, 'right', 'TRUE')).to.equal('right');
                expect(getTextAlignment(true, 'justify', 'TRUE')).to.equal('justify');
                expect(getTextAlignment(true, 'auto', 'TRUE')).to.equal('center');
            });
            it('should return the correct cell text alignment for error codes', function () {
                expect(getTextAlignment(ErrorCode.NUM, 'left', '#NUM!')).to.equal('left');
                expect(getTextAlignment(ErrorCode.NUM, 'center', '#NUM!')).to.equal('center');
                expect(getTextAlignment(ErrorCode.NUM, 'right', '#NUM!')).to.equal('right');
                expect(getTextAlignment(ErrorCode.NUM, 'justify', '#NUM!')).to.equal('justify');
                expect(getTextAlignment(ErrorCode.NUM, 'auto', '#NUM!')).to.equal('center');
            });
            it('should return the correct cell text alignment for blanks', function () {
                expect(getTextAlignment(null, 'left', '')).to.equal('left');
                expect(getTextAlignment(null, 'center', '')).to.equal('center');
                expect(getTextAlignment(null, 'right', '')).to.equal('right');
                expect(getTextAlignment(null, 'justify', '')).to.equal('justify');
                expect(getTextAlignment(null, 'auto', '')).to.match(/^(left|right)$/);
            });
            it('should accept missing display parameter', function () {
                expect(getTextAlignment(2, 'auto')).to.equal('right');
                expect(getTextAlignment('a', 'auto')).to.equal('left');
                expect(getTextAlignment(true, 'auto')).to.equal('center');
                expect(getTextAlignment(ErrorCode.NUM, 'auto')).to.equal('center');
                expect(getTextAlignment(null, 'auto')).to.match(/^(left|right)$/);
            });
        });

        describe('method "getOuterBorderKey"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getOuterBorderKey');
            });
            it('should return the correct border key', function () {
                expect(SheetUtils.getOuterBorderKey(false, true)).to.equal('t');
                expect(SheetUtils.getOuterBorderKey(false, false)).to.equal('b');
                expect(SheetUtils.getOuterBorderKey(true, true)).to.equal('l');
                expect(SheetUtils.getOuterBorderKey(true, false)).to.equal('r');
            });
        });

        describe('method "getInnerBorderKey"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getInnerBorderKey');
            });
            it('should return the correct border key', function () {
                expect(SheetUtils.getInnerBorderKey(false)).to.equal('h');
                expect(SheetUtils.getInnerBorderKey(true)).to.equal('v');
            });
        });

        describe('method "getBorderName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getBorderName');
            });
            it('should return the correct border name', function () {
                expect(SheetUtils.getBorderName('t')).to.equal('borderTop');
                expect(SheetUtils.getBorderName('b')).to.equal('borderBottom');
                expect(SheetUtils.getBorderName('l')).to.equal('borderLeft');
                expect(SheetUtils.getBorderName('r')).to.equal('borderRight');
                expect(SheetUtils.getBorderName('d')).to.equal('borderDown');
                expect(SheetUtils.getBorderName('u')).to.equal('borderUp');
                expect(SheetUtils.getBorderName('h')).to.equal('borderInsideHor');
                expect(SheetUtils.getBorderName('v')).to.equal('borderInsideVert');
            });
        });

        describe('method "getOuterBorderName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getOuterBorderName');
            });
            it('should return the correct border name', function () {
                expect(SheetUtils.getOuterBorderName(false, true)).to.equal('borderTop');
                expect(SheetUtils.getOuterBorderName(false, false)).to.equal('borderBottom');
                expect(SheetUtils.getOuterBorderName(true, true)).to.equal('borderLeft');
                expect(SheetUtils.getOuterBorderName(true, false)).to.equal('borderRight');
            });
        });

        describe('method "getInnerBorderName"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getInnerBorderName');
            });
            it('should return the correct border name', function () {
                expect(SheetUtils.getInnerBorderName(false)).to.equal('borderInsideHor');
                expect(SheetUtils.getInnerBorderName(true)).to.equal('borderInsideVert');
            });
        });

        describe('method "getTextPadding"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTextPadding');
            });
            it('should return text padding according to zoom factor', function () {
                expect(SheetUtils.getTextPadding(1)).to.equal(2);
                expect(SheetUtils.getTextPadding(2)).to.be.above(2);
            });
        });

        describe('method "getTotalCellPadding"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('getTotalCellPadding');
            });
            it('should return text padding according to zoom factor', function () {
                expect(SheetUtils.getTotalCellPadding(1)).to.equal(5);
                expect(SheetUtils.getTotalCellPadding(2)).to.be.above(5);
            });
        });

        describe('method "isDynamicSplit"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('isDynamicSplit');
            });
            it('should recognize dynamic split modes', function () {
                expect(SheetUtils.isDynamicSplit('split')).to.equal(true);
                expect(SheetUtils.isDynamicSplit('frozen')).to.equal(false);
                expect(SheetUtils.isDynamicSplit('frozenSplit')).to.equal(true);
            });
        });

        describe('method "isFrozenSplit"', function () {
            it('should exist', function () {
                expect(SheetUtils).itself.to.respondTo('isFrozenSplit');
            });
            it('should recognize frozen split modes', function () {
                expect(SheetUtils.isFrozenSplit('split')).to.equal(false);
                expect(SheetUtils.isFrozenSplit('frozen')).to.equal(true);
                expect(SheetUtils.isFrozenSplit('frozenSplit')).to.equal(true);
            });
        });
    });

    // ========================================================================
});
