/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

/* eslint new-cap: 0 */

define([
    'globals/apphelper',
    'globals/sheethelper',
    'io.ox/office/spreadsheet/model/formula/interpret/operand',
    'io.ox/office/spreadsheet/model/formula/funcs/webfuncs'
], function (AppHelper, SheetHelper, Operand, WebFuncs) {

    'use strict';

    // module WebFuncs =======================================================

    describe('Spreadsheet module WebFuncs', function () {

        // initialize the test
        var appPromise = AppHelper.createSpreadsheetApp('ooxml');
        var moduleTester = SheetHelper.createFunctionModuleTester(WebFuncs, appPromise);

        // function implementations -------------------------------------------

        moduleTester.testFunction('HYPERLINK', function (HYPERLINK) {
            var URL = 'http://www.example.com';
            it('should return the URL as value, and as "url" operand option', function () {
                var result = HYPERLINK.invoke(URL);
                expect(result).to.be.an.instanceof(Operand);
                expect(result.getRawValue()).to.equal(URL);
                expect(result.getURL()).to.equal(URL);
            });
            it('should return the second parameter as value', function () {
                var result = HYPERLINK.invoke(URL, 42);
                expect(result).to.be.an.instanceof(Operand);
                expect(result.getRawValue()).to.equal(42);
                expect(result.getURL()).to.equal(URL);
            });
        });
    });

    // ========================================================================
});
