/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 */

define([
    'io.ox/office/portal/collection/templatecollection'
], function (TemplateCollection) {

    'use strict';

    // class TemplateCollection ===============================================

    describe('Portal class TemplateCollection', function () {

        it('should exist', function () {
            expect(TemplateCollection).to.be.a('function');
        });

        it('should have method "setData"', function () {
            var collection = new TemplateCollection();
            expect(collection).to.respondTo('setData');
        });

        it('should fetch data', function () {
            var collection = new TemplateCollection();
            collection.setData([{ filename: 'one' }, { filename: 'two' }]);
            expect(collection.length).to.be.equal(2);
        });

        it('should return template', function () {
            var collection = new TemplateCollection();

            collection.setData([
                { filename: 'one.docx', type: 'text' },
                { filename: 'two.xlsx', type: 'spreadsheet' },
                { filename: 'three.xlsx', type: 'text', source: 'definedSource' }
            ]);

            expect(collection.length).to.be.equal(3);
            expect(collection.getTemplates('text', 'all')).to.be.an('array');
            expect(collection.getTemplates('text', 'all')).to.have.length(2);

            expect(collection.getTemplates('text', 'definedSource')).to.be.an('array');
            expect(collection.getTemplates('text', 'definedSource')).to.have.length(1);

            expect(collection.getTemplates('text')).to.be.an('array');
            expect(collection.getTemplates('text')).to.have.length(2);
        });
    });

    // ========================================================================
});
