/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Michael Nimz <michael.nimz@open-xchange.com>
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define([
    'io.ox/office/editframework/model/fontcollection'
], function (FontCollection) {

    'use strict';

    // class FontCollection ===================================================

    describe('EditFramework class FontCollection', function () {

        it('should exist', function () {
            expect(FontCollection).to.be.a('function');
        });

        // methods ------------------------------------------------------------

        describe('static method "getFirstFontName"', function () {
            it('should exist', function () {
                expect(FontCollection).itself.to.respondTo('getFirstFontName');
            });
            it('should return the font name capitalized', function () {
                expect(FontCollection.getFirstFontName('arial')).to.equal('Arial');
                expect(FontCollection.getFirstFontName('ARIAL')).to.equal('Arial');
            });
            it('should return the first font name', function () {
                expect(FontCollection.getFirstFontName('calibri,arial,sans-serif')).to.equal('Calibri');
                expect(FontCollection.getFirstFontName('cambria,times,serif')).to.equal('Cambria');
                expect(FontCollection.getFirstFontName('consolas,courier,monospace')).to.equal('Consolas');
            });
            it('should remove quotation marks', function () {
                expect(FontCollection.getFirstFontName('times new roman,serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('"times new roman",serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('\'times new roman\',serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('"times new roman\',serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('\'times new roman",serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('"times new roman,serif')).to.equal('Times New Roman');
                expect(FontCollection.getFirstFontName('times new roman",serif')).to.equal('Times New Roman');
            });
        });
    });

    // ========================================================================
});
