/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 * @author Ingo Schmidt-Rosbiegal <ingo.schmidt-rosbiegal@open-xchange.com>
 */

define('io.ox/office/presentation/model/modelattributesmixin', [
    'io.ox/office/presentation/format/drawingstyles',
    'io.ox/office/presentation/format/paragraphstyles',
    'io.ox/office/presentation/format/pagestyles',
    'io.ox/office/presentation/format/slidestyles',
    'io.ox/office/presentation/format/tablecellstyles',
    'io.ox/office/textframework/format/characterstyles',
    'io.ox/office/textframework/format/tablestyles',
    'io.ox/office/textframework/format/tablerowstyles'
], function (DrawingStyles, ParagraphStyles, PageStyles, SlideStyles, TableCellStyles, CharacterStyles, TableStyles, TableRowStyles) {

    'use strict';

    var // definitions for global document attributes -------------------------
        DOCUMENT_ATTRIBUTE_DEFINITIONS = {
        },

        // definitions for the default text list style attributes -------------
        DEFAULT_TEXT_LISTSTYLE_ATTRIBUTE_DEFINITIONS = {
            l1: { def: {} },
            l2: { def: {} },
            l3: { def: {} },
            l4: { def: {} },
            l5: { def: {} },
            l6: { def: {} },
            l7: { def: {} },
            l8: { def: {} },
            l9: { def: {} }
        },

        // definitions for presentation attributes ----------------------------
        PRESENTATION_ATTRIBUTE_DEFINITIONS = {
            phType: { def: 'obj', scope: 'element' },
            phSize: { def: 'full', scope: 'element' },
            phIndex: { def: 0, scope: 'element' },
            customPrompt: { def: false, scope: 'element' }
        },

        // definitions for change tracking attributes (TODO: Removing this attributes asap)--
        CHANGES_ATTRIBUTE_DEFINITIONS = {
            inserted: { def: '', scope: 'element' },
            removed: { def: '', scope: 'element' },
            modified: { def: '', scope: 'element' }
        },

        // definitions for layout attributes
        LAYOUT_ATTRIBUTE_DEFINITIONS = {
            slidePaneWidth: { def: '10' }
        };

    // mix-in class ModelAttributesMixin ======================================

    /**
     * A mix-in class for the document model class PresentationModel providing
     * the style sheet containers for all attribute families used in a
     * presentation document.
     *
     * @constructor
     */
    function ModelAttributesMixin() {

        // initialization -----------------------------------------------------

        this.registerAttributeDefinitions('document', DOCUMENT_ATTRIBUTE_DEFINITIONS);
        this.registerAttributeDefinitions('presentation', PRESENTATION_ATTRIBUTE_DEFINITIONS);
        this.registerAttributeDefinitions('changes', CHANGES_ATTRIBUTE_DEFINITIONS);
        this.registerAttributeDefinitions('layout', LAYOUT_ATTRIBUTE_DEFINITIONS);
        this.registerAttributeDefinitions('defaultTextListStyles', DEFAULT_TEXT_LISTSTYLE_ATTRIBUTE_DEFINITIONS);

        this.addStyleCollection(new DrawingStyles(this))
            .addStyleCollection(new ParagraphStyles(this))
            .addStyleCollection(new PageStyles(this))
            .addStyleCollection(new SlideStyles(this))
            .addStyleCollection(new CharacterStyles(this))
            .addStyleCollection(new TableStyles(this))
            .addStyleCollection(new TableRowStyles(this))
            .addStyleCollection(new TableCellStyles(this));

    } // class ModelAttributesMixin

    // exports ================================================================

    return ModelAttributesMixin;

});
