/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Peter Seliger <peter.seliger@open-xchange.com>
 */

define('io.ox/office/presentation/model/dragtocopymixin', [
    'io.ox/office/tk/keycodes'
], function (KeyCodes) {

    'use strict';

    // mixin DragToCopyMixin =========================================================

    function DragToCopyMixin(app) {

        var self = this;
        var editDiv = self.getNode();
        var winBodyNode = app.getWindowNode();

        // local / private methods --------------------------------------------

        function processKeyDown(evt) {
            if (KeyCodes.matchKeyCode(evt, 'CONTROL', { ctrl: true })) {
                if (self.isInsertTextFrameActive() || self.isInsertShapeActive()) {
                    return;
                }
                toggleState(true);
            }
        }

        function processKeyUp(evt) {
            if (KeyCodes.matchKeyCode(evt, 'CONTROL', { ctrl: false })) {
                toggleState(false);
            }
        }

        function toggleState(state) {
            editDiv.toggleClass('drag-to-copy', state);
            if (_.browser.Chrome) {
                // https://bugs.chromium.org/p/chromium/issues/detail?id=26723
                editDiv[0].scrollLeft += 1;
                editDiv[0].scrollLeft -= 1;
            }
        }

        // public methods -----------------------------------------------------

        // initialization -----------------------------------------------------

        self.waitForImportSuccess(function () {
            app.registerVisibleStateHandler(function (visible) {
                if (!visible) { toggleState(false); }
            });

            winBodyNode.on('keydown', processKeyDown);
            winBodyNode.on('keyup', processKeyUp);
        });

        // --------------------------------------------------------------------

    } // mixin DragToCopyMixin

    // exports ================================================================

    return DragToCopyMixin;
});
