/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com
 *
 * @author Daniel Rentz <daniel.rentz@open-xchange.com>
 */

define('io.ox/office/baseframework/view/control/compoundbutton', [
    'io.ox/office/tk/utils',
    'io.ox/office/tk/forms',
    'io.ox/office/tk/control/group',
    'io.ox/office/tk/control/captionmixin',
    'io.ox/office/tk/control/widthmixin',
    'io.ox/office/baseframework/view/control/compoundmenumixin'
], function (Utils, Forms, Group, CaptionMixin, WidthMixin, CompoundMenuMixin) {

    'use strict';

    // class CompoundButton ===================================================

    /**
     * A generic drop-down button control that shows a complete self-contained
     * view component instance with completely independent controls in its
     * drop-down menu. See class CompoundSplitButton for a similar drop-down
     * control with an additional split button control.
     *
     * @constructor
     *
     * @extends Group
     * @extends CaptionMixin
     * @extends WidthMixin
     * @extends CompoundMenuMixin
     *
     * @param {BaseView} docView
     *  The document view instance containing this control.
     *
     * @param {Object} [initOptions]
     *  Optional parameters. Supports all options also supported by the base
     *  class Group, the mix-in class WidthMixin, and the mix-in class
     *  CompoundMenuMixin.
     */
    function CompoundButton(docView, initOptions) {

        var // the drop-down button
            menuButton = $(Forms.createButtonMarkup(Utils.extendOptions({ attributes: { 'aria-haspopup': true } }, initOptions)));

        // base constructors --------------------------------------------------

        Group.call(this, initOptions);
        CaptionMixin.call(this, menuButton, initOptions);
        WidthMixin.call(this, menuButton, initOptions);
        CompoundMenuMixin.call(this, docView, Utils.extendOptions(initOptions, { button: menuButton }));

        // initialization -----------------------------------------------------

        Forms.setToolTip(menuButton, initOptions);

        // add the drop-down button to the group
        this.addChildNodes(menuButton);

        // destroy all class members
        this.registerDestructor(function () {
            docView = initOptions = menuButton = null;
        });

    } // class CompoundButton

    // exports ================================================================

    // derive this class from class Group
    return Group.extend({ constructor: CompoundButton });

});
