/*
 * Decompiled with CFR 0.152.
 */
package com.openexchange.logback.extensions.logstash;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.net.DefaultSocketConnector;
import ch.qos.logback.core.net.SocketConnector;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.WarnStatus;
import ch.qos.logback.core.util.CloseUtil;
import ch.qos.logback.core.util.Duration;
import com.openexchange.logback.extensions.logstash.LogstashEncoder;
import com.openexchange.logback.extensions.logstash.LogstashFormatter;
import com.openexchange.logback.extensions.logstash.LogstashSocketAppenderMBean;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;

public class LogstashSocketAppender
extends AppenderBase<ILoggingEvent>
implements Runnable,
SocketConnector.ExceptionHandler,
LogstashSocketAppenderMBean {
    private static final AtomicReference<LogstashSocketAppender> REF = new AtomicReference();
    private static final float LOAD_FACTOR = 0.67f;
    private static final int ACCEPT_TIMEOUT_CONNECTION = 10000;
    private static final Object PRESENT = new Object();
    private int port;
    private String remoteHost;
    private InetAddress address;
    BlockingQueue<ILoggingEvent> queue;
    private int queueSize;
    private int loadThreshold;
    private float loadFactor;
    private String peerId;
    private Future<?> task;
    private Future<Socket> connectorTask;
    private volatile Socket socket;
    private int reconnectionDelay;
    Duration eventDelayLimit;
    private int acceptConnectionTimeout;
    private Encoder<ILoggingEvent> encoder;
    private boolean alwaysPersistEvents;
    private Boolean keepAlive;
    private final ConcurrentMap<Thread, Object> guard = new ConcurrentHashMap<Thread, Object>(32, 0.9f, 1);
    private final AtomicInteger statusRepeatCount = new AtomicInteger(0);
    private final AtomicInteger exceptionCount = new AtomicInteger(0);
    private LogstashEncoder fallbackEncoder;
    static final int ALLOWED_REPEATS = 5;

    public static LogstashSocketAppender getInstance() {
        return REF.get();
    }

    public void start() {
        REF.set(this);
        if (this.isStarted()) {
            return;
        }
        int errorCount = 0;
        if (this.port <= 0) {
            ++errorCount;
            this.logWarn("No port was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_port", new Throwable[0]);
        }
        if (this.remoteHost == null) {
            ++errorCount;
            this.logWarn("No remote host was configured for appender" + this.name + " For more information, please visit http://logback.qos.ch/codes.html#socket_no_host", new Throwable[0]);
        }
        if (this.queueSize <= 0) {
            this.logWarn("'queueSize' is not defined in configuration file. Falling back to default value of '2048'", new Throwable[0]);
            this.queueSize = 2048;
        }
        this.setOptionalProperties();
        try {
            LogstashEncoder enc = new LogstashEncoder();
            enc.init(System.err);
            this.fallbackEncoder = enc;
        }
        catch (IOException e) {
            this.logError("Failed to initialize fall-back encoder.", e);
            ++errorCount;
        }
        if (errorCount == 0) {
            try {
                this.address = InetAddress.getByName(this.remoteHost);
            }
            catch (UnknownHostException ex) {
                this.logError("unknown host: " + this.remoteHost, new Throwable[0]);
                ++errorCount;
            }
        }
        if (errorCount == 0) {
            this.queue = this.newBlockingQueue(this.queueSize);
            this.peerId = this.remoteHost + ":" + this.port;
            this.task = this.getContext().getExecutorService().submit(this);
            super.start();
        }
    }

    private void setOptionalProperties() {
        this.alwaysPersistEvents = Boolean.parseBoolean(this.context.getProperty("com.openexchange.logback.extensions.logstash.alwaysPersistEvents"));
        String value = this.context.getProperty("com.openexchange.logback.extensions.logstash.loadFactor");
        if (value == null || !(value instanceof String)) {
            this.logWarn("'com.openexchange.logback.extensions.logstash.loadFactor' property is not defined in the configuration file. Falling back to default value of '0.67'", new Throwable[0]);
            this.loadFactor = 0.67f;
        } else {
            try {
                this.loadFactor = Float.parseFloat(value);
            }
            catch (NumberFormatException e) {
                this.logWarn("The value of 'com.openexchange.logback.extensions.logstash.loadFactor' is not a parsable float. Falling back to default value of '0.67'", new Throwable[0]);
                this.loadFactor = 0.67f;
            }
        }
        this.loadThreshold = (int)(this.loadFactor * (float)this.queueSize);
        this.keepAlive = Boolean.parseBoolean(this.context.getProperty("com.openexchange.logback.extensions.logstash.keepAlive"));
        String property = this.context.getProperty("com.openexchange.logback.extensions.logstash.acceptConnectionTimeout");
        if (property == null || !(property instanceof String)) {
            this.logWarn("'com.openexchange.logback.extensions.logstash.acceptConnectionTimeout' property is not defined in the configuration file. Falling back to default value of '10000'", new Throwable[0]);
            this.acceptConnectionTimeout = 10000;
        } else {
            try {
                this.acceptConnectionTimeout = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.logWarn("The value of 'com.openexchange.logback.extensions.logstash.acceptConnectionTimeout' is not a parsable integer. Falling back to default value of '10000'", new Throwable[0]);
                this.acceptConnectionTimeout = 10000;
            }
        }
    }

    public void stop() {
        if (!this.isStarted()) {
            return;
        }
        CloseUtil.closeQuietly((Socket)this.socket);
        this.task.cancel(true);
        if (this.connectorTask != null) {
            this.connectorTask.cancel(true);
        }
        this.fallbackEncoder = null;
        REF.set(null);
        super.stop();
    }

    public void connectionFailed(SocketConnector connector, Exception ex) {
        this.handleConnectionException(ex);
    }

    private void handleConnectionException(Exception ex) {
        if (ex instanceof InterruptedException) {
            this.logError("Connection to " + this.peerId + " interrupted.", ex);
        } else if (ex instanceof ConnectException) {
            this.logError("Connection to " + this.peerId + " refused.", ex);
        } else if (ex instanceof IOException) {
            this.logError("Connection to " + this.peerId + " failed.", ex);
        } else if (ex instanceof InterruptedException) {
            this.logError("Connection to " + this.peerId + " interupted.", ex);
        } else {
            this.logError("Connection error to " + this.peerId + ".", ex);
        }
        try {
            this.cleanQueueIfNecessary();
        }
        catch (IOException e) {
            this.logError("Failed while cleaning queue.", e);
        }
    }

    @Override
    public final void run() {
        try {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    SocketConnector connector = this.createConnector(this.address, this.port, 0, this.reconnectionDelay);
                    this.connectorTask = this.activateConnector(connector);
                    if (this.connectorTask == null) continue;
                    this.socket = this.waitForConnectorToReturnASocket();
                    if (this.socket == null) continue;
                    this.dispatchEvents();
                }
                catch (Exception e) {
                    this.handleConnectionException(e);
                }
            }
        }
        catch (Throwable t) {
            this.logError("LogstashSocketAppender is shutting down.", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEvents() {
        ILoggingEvent event = null;
        try {
            this.socket.setSoTimeout(this.acceptConnectionTimeout);
            BufferedOutputStream oos = new BufferedOutputStream(this.socket.getOutputStream());
            this.encoder.init((OutputStream)oos);
            this.logInfo("Dispatching events...", new Throwable[0]);
            while (true) {
                event = this.queue.take();
                this.encoder.doEncode((Object)event);
                ((OutputStream)oos).flush();
            }
        }
        catch (IOException ex) {
            this.handleConnectionException(ex);
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.logError("Connection to " + this.peerId + " closed.", new Throwable[0]);
            this.doAppend(event);
        }
        catch (InterruptedException ex) {
            try {
                this.handleConnectionException(ex);
            }
            catch (Throwable throwable) {
                CloseUtil.closeQuietly((Socket)this.socket);
                this.socket = null;
                this.logError("Connection to " + this.peerId + " closed.", new Throwable[0]);
                this.doAppend(event);
                throw throwable;
            }
            CloseUtil.closeQuietly((Socket)this.socket);
            this.socket = null;
            this.logError("Connection to " + this.peerId + " closed.", new Throwable[0]);
            this.doAppend(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doAppend(ILoggingEvent eventObject) {
        Thread currentThread = Thread.currentThread();
        if (null != this.guard.putIfAbsent(currentThread, PRESENT)) {
            return;
        }
        try {
            if (!this.started) {
                if (this.statusRepeatCount.getAndIncrement() < 5) {
                    this.addStatus((Status)new WarnStatus("Attempted to append to non started appender [" + this.name + "].", (Object)this));
                }
                return;
            }
            if (this.getFilterChainDecision(eventObject) == FilterReply.DENY) {
                return;
            }
            this.append(eventObject);
        }
        catch (Exception e) {
            if (this.exceptionCount.getAndIncrement() < 5) {
                this.addError("Appender [" + this.name + "] failed to append.", e);
            }
        }
        finally {
            this.guard.remove(currentThread);
        }
    }

    protected void append(ILoggingEvent event) {
        if (event == null || !this.isStarted()) {
            return;
        }
        int maxRetry = 2;
        boolean inserted = false;
        int i = maxRetry;
        while (!inserted && i-- > 0) {
            inserted = this.queue.offer(event);
            if (inserted) continue;
            try {
                this.cleanQueueIfNecessary();
            }
            catch (IOException e) {
                this.logError("Failed while cleaning queue.", e);
            }
        }
        if (!inserted) {
            this.logError("Dropping event due to timeout limit of [" + this.eventDelayLimit + "] being exceeded", new Throwable[0]);
        }
    }

    protected SocketConnector newConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        return new DefaultSocketConnector(address, port, (long)initialDelay, (long)retryDelay);
    }

    protected SocketFactory getSocketFactory() {
        return SocketFactory.getDefault();
    }

    BlockingQueue<ILoggingEvent> newBlockingQueue(int queueSize) {
        return (BlockingQueue)((Object)(queueSize <= 0 ? new SynchronousQueue() : new ArrayBlockingQueue(queueSize)));
    }

    private SocketConnector createConnector(InetAddress address, int port, int initialDelay, int retryDelay) {
        this.logInfo("Creating socket connector for " + this.peerId + " ...", new Throwable[0]);
        SocketConnector connector = this.newConnector(address, port, initialDelay, retryDelay);
        connector.setExceptionHandler((SocketConnector.ExceptionHandler)this);
        connector.setSocketFactory(this.getSocketFactory());
        this.logInfo("Socket connector for " + this.peerId + " created.", new Throwable[0]);
        return connector;
    }

    private Future<Socket> activateConnector(SocketConnector connector) {
        this.logInfo("Submitting socket connector to the executor service...", new Throwable[0]);
        Future<Socket> task = this.getContext().getExecutorService().submit(connector);
        this.logInfo("Connector task returned.", new Throwable[0]);
        return task;
    }

    private Socket waitForConnectorToReturnASocket() throws InterruptedException, ExecutionException, SocketException {
        this.logInfo("Trying to connect to " + this.peerId + "...", new Throwable[0]);
        Socket s = this.connectorTask.get();
        s.setKeepAlive(this.keepAlive);
        this.logInfo("Connection established to " + this.peerId + ".", new Throwable[0]);
        this.connectorTask = null;
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanQueueIfNecessary() throws IOException {
        int qSize = this.queue.size();
        if (qSize < this.loadThreshold) {
            String message = "Event queue holds " + qSize + " log events.";
            this.logInfo(message + " Not flushing yet. Load threshold of " + this.loadThreshold + " is not reached.", new Throwable[0]);
            return;
        }
        LogstashSocketAppender logstashSocketAppender = this;
        synchronized (logstashSocketAppender) {
            qSize = this.queue.size();
            if (qSize < this.loadThreshold) {
                this.logDebug("Another thread flushed the queue in the meantime.", new Throwable[0]);
                return;
            }
            String message = "Event queue holds " + qSize + " log events.";
            if (this.alwaysPersistEvents) {
                this.logInfo(message + " Load threshold of " + this.loadThreshold + " is reached. Flushing...", new Throwable[0]);
                this.flushQueue(qSize);
            } else {
                this.queue.clear();
                this.logInfo("Cleared event queue. Discarded " + qSize + " log events.", new Throwable[0]);
            }
        }
    }

    private void flushQueue(int qSize) throws IOException {
        int events;
        LogstashEncoder enc = this.fallbackEncoder;
        for (events = 0; events < qSize; ++events) {
            ILoggingEvent event = (ILoggingEvent)this.queue.poll();
            enc.doEncode(event);
        }
        this.logInfo("Successfully flushed " + events + " out of " + qSize + " events.", new Throwable[0]);
    }

    private String writeCurrentTimestamp() {
        return LogstashFormatter.LOGSTASH_TIMEFORMAT.format(System.currentTimeMillis());
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getPort() {
        return this.port;
    }

    public void setReconnectionDelay(int delay) {
        this.reconnectionDelay = delay;
    }

    public int getReconnectionDelay() {
        return this.reconnectionDelay;
    }

    public void setEventDelayLimit(Duration eventDelayLimit) {
        this.eventDelayLimit = eventDelayLimit;
    }

    public Duration getEventDelayLimit() {
        return this.eventDelayLimit;
    }

    void setAcceptConnectionTimeout(int acceptConnectionTimeout) {
        this.acceptConnectionTimeout = acceptConnectionTimeout;
    }

    public int getNumberOfElementsInQueue() {
        return this.queue.size();
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public void setQueueSize(int queueSize) {
        if (this.queue != null) {
            throw new IllegalStateException("Queue size must be set before initialization");
        }
        this.queueSize = queueSize;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }

    private void logDebug(String message, Throwable ... t) {
        this.log(Level.DEBUG, message, t);
    }

    private void logInfo(String message, Throwable ... t) {
        this.log(Level.INFO, message, t);
    }

    private void logWarn(String message, Throwable ... t) {
        this.log(Level.WARN, message, t);
    }

    void logError(String message, Throwable ... t) {
        this.log(Level.ERROR, message, t);
    }

    private void log(Level level, String message, Throwable ... t) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.writeCurrentTimestamp()).append(" ").append(level).append(" in ").append(this.getClass().getCanonicalName()).append(" - ").append(message);
        if (t.length >= 1) {
            builder.append(" Reason:");
        }
        System.err.println(builder.toString());
        for (Throwable th : t) {
            th.printStackTrace();
        }
    }

    @Override
    public int getEventsInQueue() {
        return this.queue.size();
    }
}

