/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.android;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.dropbox.core.android.AuthActivity;
import java.util.Arrays;

public class Auth {
    public static void startOAuth2Authentication(Context context, String appKey) {
        Auth.startOAuth2Authentication(context, appKey, null, null, null);
    }

    public static void startOAuth2Authentication(Context context, String appKey, String desiredUid, String[] alreadyAuthedUids, String sessionId) {
        if (!AuthActivity.checkAppBeforeAuth(context, appKey, true)) {
            return;
        }
        if (alreadyAuthedUids != null && Arrays.asList(alreadyAuthedUids).contains(desiredUid)) {
            throw new IllegalArgumentException("desiredUid cannot be present in alreadyAuthedUids");
        }
        String apiType = "1";
        String webHost = "www.dropbox.com";
        Intent intent = AuthActivity.makeIntent(context, appKey, desiredUid, alreadyAuthedUids, sessionId, webHost, apiType);
        if (!(context instanceof Activity)) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    public static String getOAuth2Token() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return null;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals(""))) {
            return secret;
        }
        return null;
    }

    public static String getUid() {
        Intent data = AuthActivity.result;
        if (data == null) {
            return null;
        }
        String token = data.getStringExtra("ACCESS_TOKEN");
        String secret = data.getStringExtra("ACCESS_SECRET");
        String uid = data.getStringExtra("UID");
        if (!(token == null || token.equals("") || secret == null || secret.equals("") || uid == null || uid.equals(""))) {
            return uid;
        }
        return null;
    }
}

