package com.openexchange.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

/**
 * Contains convenience methods.
 *
 * @author <a href="mailto:marcus.klein@open-xchange.com">Marcus Klein</a>
 */
public final class Tools {

    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    private Tools() {
        super();
    }

    public static String readFile(File file) {
        try {
            return readFileE(file);
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        }
    }

    public static String readFileE(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            return readFile(fis);
        } finally {
            fis.close();
        }
    }

    public static String readFile(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        try {
            return readFile(isr);
        } finally {
            isr.close();
        }
    }

    public static String readFile(Reader r) throws IOException {
        StringBuilder retval = new StringBuilder();
        final char[] buf = new char[512];
        int length = 0;
        while ((length = r.read(buf)) != -1) {
            retval.append(buf, 0, length);
        }
        return retval.toString();
    }

    public static Properties readProperties(File file) {
        try {
            return readPropertiesE(file);
        } catch (IOException e) {
            throw new BuildException(e.getMessage(), e);
        }
    }

    public static Properties readPropertiesE(File file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        try {
            return readProperties(fis);
        } finally {
            fis.close();
        }
    }

    public static Properties readProperties(InputStream is) throws IOException {
        InputStreamReader isr = new InputStreamReader(is, "UTF-8");
        try {
            return readProperties(isr);
        } finally {
            isr.close();
        }
    }

    public static Properties readProperties(Reader r) throws IOException {
        Properties retval = new Properties();
        retval.load(r);
        return retval;
    }

    public static Document readXML(File file) throws IOException {
        final DocumentBuilder db;
        try {
            db = dbf.newDocumentBuilder();
        } catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage(), e);
        }
        final FileInputStream fis = new FileInputStream(file);
        final Document document;
        try {
            document = db.parse(fis);
        } catch (SAXException e) {
            throw new IOException(e.getMessage(), e);
        } finally {
            fis.close();
        }
        return document;
    }
}
