/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.directory.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DirectoryConnectSettings
implements Serializable,
Cloneable {
    private String vpcId;
    private ListWithAutoConstructFlag<String> subnetIds;
    private ListWithAutoConstructFlag<String> customerDnsIps;
    private String customerUserName;

    public String getVpcId() {
        return this.vpcId;
    }

    public void setVpcId(String vpcId) {
        this.vpcId = vpcId;
    }

    public DirectoryConnectSettings withVpcId(String vpcId) {
        this.vpcId = vpcId;
        return this;
    }

    public List<String> getSubnetIds() {
        if (this.subnetIds == null) {
            this.subnetIds = new ListWithAutoConstructFlag();
            this.subnetIds.setAutoConstruct(true);
        }
        return this.subnetIds;
    }

    public void setSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
            return;
        }
        ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
        subnetIdsCopy.addAll(subnetIds);
        this.subnetIds = subnetIdsCopy;
    }

    public DirectoryConnectSettings withSubnetIds(String ... subnetIds) {
        if (this.getSubnetIds() == null) {
            this.setSubnetIds(new ArrayList<String>(subnetIds.length));
        }
        for (String value : subnetIds) {
            this.getSubnetIds().add(value);
        }
        return this;
    }

    public DirectoryConnectSettings withSubnetIds(Collection<String> subnetIds) {
        if (subnetIds == null) {
            this.subnetIds = null;
        } else {
            ListWithAutoConstructFlag subnetIdsCopy = new ListWithAutoConstructFlag(subnetIds.size());
            subnetIdsCopy.addAll(subnetIds);
            this.subnetIds = subnetIdsCopy;
        }
        return this;
    }

    public List<String> getCustomerDnsIps() {
        if (this.customerDnsIps == null) {
            this.customerDnsIps = new ListWithAutoConstructFlag();
            this.customerDnsIps.setAutoConstruct(true);
        }
        return this.customerDnsIps;
    }

    public void setCustomerDnsIps(Collection<String> customerDnsIps) {
        if (customerDnsIps == null) {
            this.customerDnsIps = null;
            return;
        }
        ListWithAutoConstructFlag customerDnsIpsCopy = new ListWithAutoConstructFlag(customerDnsIps.size());
        customerDnsIpsCopy.addAll(customerDnsIps);
        this.customerDnsIps = customerDnsIpsCopy;
    }

    public DirectoryConnectSettings withCustomerDnsIps(String ... customerDnsIps) {
        if (this.getCustomerDnsIps() == null) {
            this.setCustomerDnsIps(new ArrayList<String>(customerDnsIps.length));
        }
        for (String value : customerDnsIps) {
            this.getCustomerDnsIps().add(value);
        }
        return this;
    }

    public DirectoryConnectSettings withCustomerDnsIps(Collection<String> customerDnsIps) {
        if (customerDnsIps == null) {
            this.customerDnsIps = null;
        } else {
            ListWithAutoConstructFlag customerDnsIpsCopy = new ListWithAutoConstructFlag(customerDnsIps.size());
            customerDnsIpsCopy.addAll(customerDnsIps);
            this.customerDnsIps = customerDnsIpsCopy;
        }
        return this;
    }

    public String getCustomerUserName() {
        return this.customerUserName;
    }

    public void setCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
    }

    public DirectoryConnectSettings withCustomerUserName(String customerUserName) {
        this.customerUserName = customerUserName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVpcId() != null) {
            sb.append("VpcId: " + this.getVpcId() + ",");
        }
        if (this.getSubnetIds() != null) {
            sb.append("SubnetIds: " + this.getSubnetIds() + ",");
        }
        if (this.getCustomerDnsIps() != null) {
            sb.append("CustomerDnsIps: " + this.getCustomerDnsIps() + ",");
        }
        if (this.getCustomerUserName() != null) {
            sb.append("CustomerUserName: " + this.getCustomerUserName());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVpcId() == null ? 0 : this.getVpcId().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetIds() == null ? 0 : this.getSubnetIds().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerDnsIps() == null ? 0 : this.getCustomerDnsIps().hashCode());
        hashCode = 31 * hashCode + (this.getCustomerUserName() == null ? 0 : this.getCustomerUserName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConnectSettings)) {
            return false;
        }
        DirectoryConnectSettings other = (DirectoryConnectSettings)obj;
        if (other.getVpcId() == null ^ this.getVpcId() == null) {
            return false;
        }
        if (other.getVpcId() != null && !other.getVpcId().equals(this.getVpcId())) {
            return false;
        }
        if (other.getSubnetIds() == null ^ this.getSubnetIds() == null) {
            return false;
        }
        if (other.getSubnetIds() != null && !other.getSubnetIds().equals(this.getSubnetIds())) {
            return false;
        }
        if (other.getCustomerDnsIps() == null ^ this.getCustomerDnsIps() == null) {
            return false;
        }
        if (other.getCustomerDnsIps() != null && !other.getCustomerDnsIps().equals(this.getCustomerDnsIps())) {
            return false;
        }
        if (other.getCustomerUserName() == null ^ this.getCustomerUserName() == null) {
            return false;
        }
        return other.getCustomerUserName() == null || other.getCustomerUserName().equals(this.getCustomerUserName());
    }

    public DirectoryConnectSettings clone() {
        try {
            return (DirectoryConnectSettings)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

