/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.quorum.impl;

import com.hazelcast.config.QuorumConfig;
import com.hazelcast.core.Member;
import com.hazelcast.nio.ClassLoaderUtil;
import com.hazelcast.quorum.Quorum;
import com.hazelcast.quorum.QuorumEvent;
import com.hazelcast.quorum.QuorumException;
import com.hazelcast.quorum.QuorumFunction;
import com.hazelcast.quorum.QuorumType;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.impl.MutatingOperation;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.spi.impl.eventservice.InternalEventService;
import com.hazelcast.util.ExceptionUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;

public class QuorumImpl
implements Quorum {
    private final AtomicBoolean isPresent = new AtomicBoolean(true);
    private final AtomicBoolean lastPresence = new AtomicBoolean(true);
    private final NodeEngineImpl nodeEngine;
    private final String quorumName;
    private final int size;
    private final QuorumConfig config;
    private final InternalEventService eventService;
    private QuorumFunction quorumFunction;
    private volatile boolean initialized;

    public QuorumImpl(QuorumConfig config, NodeEngineImpl nodeEngine) {
        this.nodeEngine = nodeEngine;
        this.eventService = nodeEngine.getEventService();
        this.config = config;
        this.quorumName = config.getName();
        this.size = config.getSize();
        this.initializeQuorumFunction();
    }

    public void update(Collection<Member> members) {
        boolean presence = this.quorumFunction.apply(members);
        this.setLocalResult(presence);
        this.updateLastResultAndFireEvent(members, presence);
    }

    public String getName() {
        return this.quorumName;
    }

    public int getSize() {
        return this.size;
    }

    public QuorumConfig getConfig() {
        return this.config;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public boolean isPresent() {
        return this.isPresent.get();
    }

    public void setLocalResult(boolean presence) {
        this.setLocalResultInternal(presence);
    }

    private void setLocalResultInternal(boolean presence) {
        this.initialized = true;
        this.isPresent.set(presence);
    }

    private boolean isQuorumNeeded(Operation op) {
        QuorumType type = this.config.getType();
        switch (type) {
            case WRITE: {
                return QuorumImpl.isWriteOperation(op);
            }
            case READ: {
                return QuorumImpl.isReadOperation(op);
            }
            case READ_WRITE: {
                return QuorumImpl.isReadOperation(op) || QuorumImpl.isWriteOperation(op);
            }
        }
        throw new IllegalStateException("Unhandled quorum type: " + (Object)((Object)type));
    }

    private static boolean isReadOperation(Operation op) {
        return op instanceof ReadonlyOperation;
    }

    private static boolean isWriteOperation(Operation op) {
        return op instanceof MutatingOperation;
    }

    public void ensureQuorumPresent(Operation op) {
        if (!this.isQuorumNeeded(op)) {
            return;
        }
        Collection<Member> memberList = this.nodeEngine.getClusterService().getMembers();
        if (!this.isInitialized()) {
            this.update(memberList);
        }
        if (!this.isPresent()) {
            this.updateLastResultAndFireEvent(memberList, false);
            throw this.newQuorumException(memberList);
        }
        this.updateLastResultAndFireEvent(memberList, true);
    }

    private QuorumException newQuorumException(Collection<Member> memberList) {
        if (this.size == 0) {
            throw new QuorumException("Cluster quorum failed");
        }
        throw new QuorumException("Cluster quorum failed, quorum minimum size: " + this.size + ", current size: " + memberList.size());
    }

    private void updateLastResultAndFireEvent(Collection<Member> memberList, Boolean presence) {
        boolean currentPresence;
        do {
            if (!presence.equals(currentPresence = this.lastPresence.get())) continue;
            return;
        } while (!this.lastPresence.compareAndSet(currentPresence, presence));
        this.createAndPublishEvent(memberList, presence);
    }

    private void createAndPublishEvent(Collection<Member> memberList, boolean presence) {
        QuorumEvent quorumEvent = new QuorumEvent(this.nodeEngine.getThisAddress(), this.size, memberList, presence);
        this.eventService.publishEvent("hz:impl:quorumService", this.quorumName, (Object)quorumEvent, quorumEvent.hashCode());
    }

    private void initializeQuorumFunction() {
        if (this.config.getQuorumFunctionImplementation() != null) {
            this.quorumFunction = this.config.getQuorumFunctionImplementation();
        } else if (this.config.getQuorumFunctionClassName() != null) {
            try {
                this.quorumFunction = (QuorumFunction)ClassLoaderUtil.newInstance(this.nodeEngine.getConfigClassLoader(), this.config.getQuorumFunctionClassName());
            }
            catch (Exception e) {
                throw ExceptionUtil.rethrow(e);
            }
        }
        if (this.quorumFunction == null) {
            this.quorumFunction = new MemberCountQuorumFunction();
        }
    }

    public String toString() {
        return "QuorumImpl{quorumName='" + this.quorumName + '\'' + ", isPresent=" + this.isPresent + ", size=" + this.size + ", config=" + this.config + ", quorumFunction=" + this.quorumFunction + ", initialized=" + this.initialized + '}';
    }

    private class MemberCountQuorumFunction
    implements QuorumFunction {
        private MemberCountQuorumFunction() {
        }

        @Override
        public boolean apply(Collection<Member> members) {
            return members.size() >= QuorumImpl.this.size;
        }
    }
}

