/* This file has been generated by ox-ui-module generator.
 * Please only apply minor changes (better no changes at all) to this file
 * if you want to be able to run the generator again without much trouble.
 *
 * If you really have to change this file for whatever reason, try to contact
 * the core team and describe your use-case. May be, your changes can be
 * integrated into the templates to be of use for everybody.
 */
'use strict';

module.exports = function (grunt) {

    var path = require('path');
    var coreDir = grunt.config('local.coreDir');

    //TODO: get rid of coreDir dependency for less files
    //if no coreDir is specified, compile everything for 'default' theme, this can be used
    //with local versions of core definitions.less, mixins.less and style.less.
    //Just place those files in lib/appsuite/apps/themes/
    var coreThemes = (/^\.\.[/\\].+/.test(coreDir) ?
        grunt.file.expand({ cwd: path.join(coreDir, 'apps/themes/') }, '*/definitions.less') : []
    ).map(function (file) {
        return file.replace(/\/definitions.less$/, '');
    });
    var localThemes = grunt.file.expand({ cwd: 'apps/themes/' }, '*/definitions.less').filter(function () {
        if (!grunt.file.exists(path.join(coreDir, 'apps/themes/style.less')) &&
            !grunt.file.exists('apps/themes/style.less') &&/* actually this is the coreDir, most likely */
            grunt.isPeerDependencyInstalled('assemble-less') /* less task will actually do something */) {
            grunt.log.warn('Important file from core directory is missing');
            grunt.log.warn('Building local themes without a (valid) --coreDir option is not supported, at the moment');
            return false;
        }
        return true;
    }).map(function (file) {
        return file.replace(/\/definitions.less$/, '');
    });

    function optionsFor(themeName) {
        return {
            compress: !grunt.config('local.debug'),
            cleancss: !grunt.config('local.debug'),
            ieCompat: false,
            syncImport: true,
            strictMath: false,
            strictUnits: false,
            relativeUrls: false,
            rootpath: 'v=<%= pkg.version %>.' + grunt.template.date(new Date(), 'yyyymmdd.hhMMss') + '/',
            paths: [
                path.join(coreDir, 'apps/3rd.party/bootstrap/less'),
                path.join(coreDir, 'apps/3rd.party/font-awesome/less'),
                'lib/appsuite/apps/themes',
                path.join(coreDir, 'apps/themes'),
                'apps/themes'
            ],
            imports: {
                reference: [
                    'variables.less',
                    'mixins.less'
                ],
                less: [
                    'definitions.less',
                    themeName + '/definitions.less'
                ]
            }
        };
    }

    localThemes.forEach(function (themeName) {
        var theme = {};

        theme[themeName] = {
            options: optionsFor(themeName),
            files: [
                {
                    src: [
                        path.join(coreDir, 'apps/3rd.party/bootstrap/less/bootstrap.less'),
                        path.join(coreDir, 'apps/3rd.party/bootstrap-datepicker/less/datepicker3.less'),
                        path.join(coreDir, 'apps/3rd.party/font-awesome/less/font-awesome.less'),
                        path.join(coreDir, 'apps/themes/style.less')
                    ],
                    expand: true,
                    rename: function (dest) { return dest; },
                    dest: 'build/apps/themes/' + themeName + '/common.css',
                    nonull: true
                },
                {
                    src: [
                        'apps/themes/' + themeName + '/style.less'
                    ],
                    expand: true,
                    rename: function (dest) { return dest; },
                    filter: function () {
                        //only generate this file if there is a style.less for this theme
                        return grunt.file.exists('apps/themes/' + themeName + '/style.less');
                    },
                    dest: 'build/apps/themes/' + themeName + '/style.css'
                },
                {
                    src: [
                        '**/*.less',
                        '!themes/**/*.less',
                        '!themes/*.less',
                        //ignore third party less files
                        '!3rd.party/**/*.less'
                    ],
                    expand: true,
                    ext: '.css',
                    cwd: path.join(coreDir, 'apps/'),
                    dest: 'build/apps/themes/' + themeName + '/'
                },
                {
                    src: [
                        '**/*.less',
                        '!themes/**/*.less',
                        '!themes/*.less'
                    ],
                    expand: true,
                    ext: '.css',
                    cwd: 'apps/',
                    dest: 'build/apps/themes/' + themeName + '/'
                }
            ]
        };
        grunt.config.merge({
            less: theme
        });
    });

    coreThemes.forEach(function (themeName) {
        var theme = {};
        theme['core_theme/' + themeName + '+local_less'] = {
            options: optionsFor(themeName),
            files: [
                {
                    src: [
                        '**/*.less',
                        '!themes/**/*.less',
                        '!themes/*.less'
                    ],
                    expand: true,
                    ext: '.css',
                    cwd: 'apps/',
                    dest: 'build/apps/themes/' + themeName + '/'
                }
            ]
        };
        grunt.config.merge({
            less: theme
        });
    });

    //init empty less config, if no themes detected, this will prevent grunt-newer
    //from failing. If no coreDir is set, it will prevent assemble-less from failing.
    if (!grunt.config('less')) {
        grunt.config.merge({
            less: {
                prevent_no_themes_fail: {}
            }
        });
    }

    grunt.util.registerDummyTask('less', 'assemble-less');
    if (grunt.isPeerDependencyInstalled('assemble-less')) {
        grunt.loadNpmTasks('assemble-less');
    }
};

