/*!
 * delims <https://github.com/jonschlinkert/delims>
 *
 * Copyright (c) 2014 Jon Schlinkert
 * Licensed under the MIT license.
 */

const _ = require('lodash');
const utils = require('./lib/utils');


// Generate RegExp patterns dynamically. By default, patterns use
// [\s\S] instead to avoid the need for multiline and dotall flags.
var delims = module.exports = function (delims, options) {
  if(!_.isArray(delims)) {options = delims; delims = ['---', '---'];}

  // Defaults
  var opts = _.defaults({}, options, {
    beginning: '^',           // '^' Matches beginning of input.
    matter: '([\\s\\S]+?)',   // The "content" between the delims
    body: '([\\s\\S]+|\\s?)', // The "content" after the delims
    end: '$',                 // '$' Matches end of input.
    flags: ''                 // g, m, i
  });
  opts.body = delims[2] || opts.body || '';

  // Generate regex ections
  var open  = utils.buildRegexGroup(delims[0], opts);
  var close = utils.buildRegexGroup(delims[1], opts);
  var block = opts.matter + close + opts.body + opts.end;

  // "evaluate" is probably most suitable for most use cases
  return {
    evaluate: new RegExp(opts.beginning + open + block, opts.flags),
    interpolate: new RegExp(opts.beginning + open + '=' + block, opts.flags),
    escape: new RegExp(opts.beginning + open + '-' + block, opts.flags),
  };
};

delims.arrayify = utils.arrayify;
delims.escapeDelim = utils.escapeDelim;
delims.buildRegexGroup = utils.buildRegexGroup;