import * as K from "./kinds";
import * as N from "./nodes";
export interface FileBuilder {
    (program: K.ProgramKind, name?: string | null): N.File;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name?: string | null;
        program: K.ProgramKind;
    }): N.File;
}
export interface ProgramBuilder {
    (body: K.StatementKind[]): N.Program;
    from(params: {
        body: K.StatementKind[];
        comments?: K.CommentKind[] | null;
        directives?: K.DirectiveKind[];
        interpreter?: K.InterpreterDirectiveKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.Program;
}
export interface IdentifierBuilder {
    (name: string): N.Identifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: string;
        optional?: boolean;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    }): N.Identifier;
}
export interface BlockStatementBuilder {
    (body: K.StatementKind[]): N.BlockStatement;
    from(params: {
        body: K.StatementKind[];
        comments?: K.CommentKind[] | null;
        directives?: K.DirectiveKind[];
        loc?: K.SourceLocationKind | null;
    }): N.BlockStatement;
}
export interface EmptyStatementBuilder {
    (): N.EmptyStatement;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.EmptyStatement;
}
export interface ExpressionStatementBuilder {
    (expression: K.ExpressionKind): N.ExpressionStatement;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.ExpressionStatement;
}
export interface IfStatementBuilder {
    (test: K.ExpressionKind, consequent: K.StatementKind, alternate?: K.StatementKind | null): N.IfStatement;
    from(params: {
        alternate?: K.StatementKind | null;
        comments?: K.CommentKind[] | null;
        consequent: K.StatementKind;
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind;
    }): N.IfStatement;
}
export interface LabeledStatementBuilder {
    (label: K.IdentifierKind, body: K.StatementKind): N.LabeledStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        label: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.LabeledStatement;
}
export interface BreakStatementBuilder {
    (label?: K.IdentifierKind | null): N.BreakStatement;
    from(params: {
        comments?: K.CommentKind[] | null;
        label?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.BreakStatement;
}
export interface ContinueStatementBuilder {
    (label?: K.IdentifierKind | null): N.ContinueStatement;
    from(params: {
        comments?: K.CommentKind[] | null;
        label?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.ContinueStatement;
}
export interface WithStatementBuilder {
    (object: K.ExpressionKind, body: K.StatementKind): N.WithStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        object: K.ExpressionKind;
    }): N.WithStatement;
}
export interface SwitchStatementBuilder {
    (discriminant: K.ExpressionKind, cases: K.SwitchCaseKind[], lexical?: boolean): N.SwitchStatement;
    from(params: {
        cases: K.SwitchCaseKind[];
        comments?: K.CommentKind[] | null;
        discriminant: K.ExpressionKind;
        lexical?: boolean;
        loc?: K.SourceLocationKind | null;
    }): N.SwitchStatement;
}
export interface SwitchCaseBuilder {
    (test: K.ExpressionKind | null, consequent: K.StatementKind[]): N.SwitchCase;
    from(params: {
        comments?: K.CommentKind[] | null;
        consequent: K.StatementKind[];
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind | null;
    }): N.SwitchCase;
}
export interface ReturnStatementBuilder {
    (argument: K.ExpressionKind | null): N.ReturnStatement;
    from(params: {
        argument: K.ExpressionKind | null;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ReturnStatement;
}
export interface ThrowStatementBuilder {
    (argument: K.ExpressionKind): N.ThrowStatement;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ThrowStatement;
}
export interface TryStatementBuilder {
    (block: K.BlockStatementKind, handler?: K.CatchClauseKind | null, finalizer?: K.BlockStatementKind | null): N.TryStatement;
    from(params: {
        block: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        finalizer?: K.BlockStatementKind | null;
        guardedHandlers?: K.CatchClauseKind[];
        handler?: K.CatchClauseKind | null;
        handlers?: K.CatchClauseKind[];
        loc?: K.SourceLocationKind | null;
    }): N.TryStatement;
}
export interface CatchClauseBuilder {
    (param: K.PatternKind | null | undefined, guard: K.ExpressionKind | null | undefined, body: K.BlockStatementKind): N.CatchClause;
    from(params: {
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        guard?: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
        param?: K.PatternKind | null;
    }): N.CatchClause;
}
export interface WhileStatementBuilder {
    (test: K.ExpressionKind, body: K.StatementKind): N.WhileStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind;
    }): N.WhileStatement;
}
export interface DoWhileStatementBuilder {
    (body: K.StatementKind, test: K.ExpressionKind): N.DoWhileStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind;
    }): N.DoWhileStatement;
}
export interface ForStatementBuilder {
    (init: K.VariableDeclarationKind | K.ExpressionKind | null, test: K.ExpressionKind | null, update: K.ExpressionKind | null, body: K.StatementKind): N.ForStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        init: K.VariableDeclarationKind | K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind | null;
        update: K.ExpressionKind | null;
    }): N.ForStatement;
}
export interface VariableDeclarationBuilder {
    (kind: "var" | "let" | "const", declarations: (K.VariableDeclaratorKind | K.IdentifierKind)[]): N.VariableDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declarations: (K.VariableDeclaratorKind | K.IdentifierKind)[];
        kind: "var" | "let" | "const";
        loc?: K.SourceLocationKind | null;
    }): N.VariableDeclaration;
}
export interface ForInStatementBuilder {
    (left: K.VariableDeclarationKind | K.ExpressionKind, right: K.ExpressionKind, body: K.StatementKind): N.ForInStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        left: K.VariableDeclarationKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        right: K.ExpressionKind;
    }): N.ForInStatement;
}
export interface DebuggerStatementBuilder {
    (): N.DebuggerStatement;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.DebuggerStatement;
}
export interface FunctionDeclarationBuilder {
    (id: K.IdentifierKind, params: K.PatternKind[], body: K.BlockStatementKind, generator?: boolean, expression?: boolean): N.FunctionDeclaration;
    from(params: {
        async?: boolean;
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: boolean;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.FunctionDeclaration;
}
export interface FunctionExpressionBuilder {
    (id: K.IdentifierKind | null | undefined, params: K.PatternKind[], body: K.BlockStatementKind, generator?: boolean, expression?: boolean): N.FunctionExpression;
    from(params: {
        async?: boolean;
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: boolean;
        id?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.FunctionExpression;
}
export interface VariableDeclaratorBuilder {
    (id: K.PatternKind, init?: K.ExpressionKind | null): N.VariableDeclarator;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.PatternKind;
        init?: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.VariableDeclarator;
}
export interface ThisExpressionBuilder {
    (): N.ThisExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ThisExpression;
}
export interface ArrayExpressionBuilder {
    (elements: (K.ExpressionKind | K.SpreadElementKind | K.RestElementKind | null)[]): N.ArrayExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        elements: (K.ExpressionKind | K.SpreadElementKind | K.RestElementKind | null)[];
        loc?: K.SourceLocationKind | null;
    }): N.ArrayExpression;
}
export interface ObjectExpressionBuilder {
    (properties: (K.PropertyKind | K.ObjectMethodKind | K.ObjectPropertyKind | K.SpreadPropertyKind | K.SpreadElementKind)[]): N.ObjectExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        properties: (K.PropertyKind | K.ObjectMethodKind | K.ObjectPropertyKind | K.SpreadPropertyKind | K.SpreadElementKind)[];
    }): N.ObjectExpression;
}
export interface PropertyBuilder {
    (kind: "init" | "get" | "set", key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, value: K.ExpressionKind | K.PatternKind): N.Property;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        kind: "init" | "get" | "set";
        loc?: K.SourceLocationKind | null;
        method?: boolean;
        shorthand?: boolean;
        value: K.ExpressionKind | K.PatternKind;
    }): N.Property;
}
export interface LiteralBuilder {
    (value: string | boolean | null | number | RegExp): N.Literal;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: string | boolean | null | number | RegExp;
    }): N.Literal;
}
export interface SequenceExpressionBuilder {
    (expressions: K.ExpressionKind[]): N.SequenceExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        expressions: K.ExpressionKind[];
        loc?: K.SourceLocationKind | null;
    }): N.SequenceExpression;
}
export interface UnaryExpressionBuilder {
    (operator: "-" | "+" | "!" | "~" | "typeof" | "void" | "delete", argument: K.ExpressionKind, prefix?: boolean): N.UnaryExpression;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        operator: "-" | "+" | "!" | "~" | "typeof" | "void" | "delete";
        prefix?: boolean;
    }): N.UnaryExpression;
}
export interface BinaryExpressionBuilder {
    (operator: "==" | "!=" | "===" | "!==" | "<" | "<=" | ">" | ">=" | "<<" | ">>" | ">>>" | "+" | "-" | "*" | "/" | "%" | "**" | "&" | "|" | "^" | "in" | "instanceof", left: K.ExpressionKind, right: K.ExpressionKind): N.BinaryExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        left: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        operator: "==" | "!=" | "===" | "!==" | "<" | "<=" | ">" | ">=" | "<<" | ">>" | ">>>" | "+" | "-" | "*" | "/" | "%" | "**" | "&" | "|" | "^" | "in" | "instanceof";
        right: K.ExpressionKind;
    }): N.BinaryExpression;
}
export interface AssignmentExpressionBuilder {
    (operator: "=" | "+=" | "-=" | "*=" | "/=" | "%=" | "<<=" | ">>=" | ">>>=" | "|=" | "^=" | "&=", left: K.PatternKind, right: K.ExpressionKind): N.AssignmentExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        left: K.PatternKind;
        loc?: K.SourceLocationKind | null;
        operator: "=" | "+=" | "-=" | "*=" | "/=" | "%=" | "<<=" | ">>=" | ">>>=" | "|=" | "^=" | "&=";
        right: K.ExpressionKind;
    }): N.AssignmentExpression;
}
export interface UpdateExpressionBuilder {
    (operator: "++" | "--", argument: K.ExpressionKind, prefix: boolean): N.UpdateExpression;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        operator: "++" | "--";
        prefix: boolean;
    }): N.UpdateExpression;
}
export interface LogicalExpressionBuilder {
    (operator: "||" | "&&" | "??", left: K.ExpressionKind, right: K.ExpressionKind): N.LogicalExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        left: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        operator: "||" | "&&" | "??";
        right: K.ExpressionKind;
    }): N.LogicalExpression;
}
export interface ConditionalExpressionBuilder {
    (test: K.ExpressionKind, consequent: K.ExpressionKind, alternate: K.ExpressionKind): N.ConditionalExpression;
    from(params: {
        alternate: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        consequent: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        test: K.ExpressionKind;
    }): N.ConditionalExpression;
}
export interface NewExpressionBuilder {
    (callee: K.ExpressionKind, argumentsParam: (K.ExpressionKind | K.SpreadElementKind)[]): N.NewExpression;
    from(params: {
        arguments: (K.ExpressionKind | K.SpreadElementKind)[];
        callee: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.NewExpression;
}
export interface CallExpressionBuilder {
    (callee: K.ExpressionKind, argumentsParam: (K.ExpressionKind | K.SpreadElementKind)[]): N.CallExpression;
    from(params: {
        arguments: (K.ExpressionKind | K.SpreadElementKind)[];
        callee: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.CallExpression;
}
export interface MemberExpressionBuilder {
    (object: K.ExpressionKind, property: K.IdentifierKind | K.ExpressionKind, computed?: boolean): N.MemberExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        loc?: K.SourceLocationKind | null;
        object: K.ExpressionKind;
        property: K.IdentifierKind | K.ExpressionKind;
    }): N.MemberExpression;
}
export interface RestElementBuilder {
    (argument: K.PatternKind): N.RestElement;
    from(params: {
        argument: K.PatternKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    }): N.RestElement;
}
export interface TypeAnnotationBuilder {
    (typeAnnotation: K.FlowTypeKind): N.TypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.FlowTypeKind;
    }): N.TypeAnnotation;
}
export interface TSTypeAnnotationBuilder {
    (typeAnnotation: K.TSTypeKind | K.TSTypeAnnotationKind): N.TSTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind | K.TSTypeAnnotationKind;
    }): N.TSTypeAnnotation;
}
export interface SpreadElementPatternBuilder {
    (argument: K.PatternKind): N.SpreadElementPattern;
    from(params: {
        argument: K.PatternKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.SpreadElementPattern;
}
export interface ArrowFunctionExpressionBuilder {
    (params: K.PatternKind[], body: K.BlockStatementKind | K.ExpressionKind, expression?: boolean): N.ArrowFunctionExpression;
    from(params: {
        async?: boolean;
        body: K.BlockStatementKind | K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: false;
        id?: null;
        loc?: K.SourceLocationKind | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ArrowFunctionExpression;
}
export interface ForOfStatementBuilder {
    (left: K.VariableDeclarationKind | K.PatternKind, right: K.ExpressionKind, body: K.StatementKind): N.ForOfStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        left: K.VariableDeclarationKind | K.PatternKind;
        loc?: K.SourceLocationKind | null;
        right: K.ExpressionKind;
    }): N.ForOfStatement;
}
export interface YieldExpressionBuilder {
    (argument: K.ExpressionKind | null, delegate?: boolean): N.YieldExpression;
    from(params: {
        argument: K.ExpressionKind | null;
        comments?: K.CommentKind[] | null;
        delegate?: boolean;
        loc?: K.SourceLocationKind | null;
    }): N.YieldExpression;
}
export interface GeneratorExpressionBuilder {
    (body: K.ExpressionKind, blocks: K.ComprehensionBlockKind[], filter: K.ExpressionKind | null): N.GeneratorExpression;
    from(params: {
        blocks: K.ComprehensionBlockKind[];
        body: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        filter: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.GeneratorExpression;
}
export interface ComprehensionBlockBuilder {
    (left: K.PatternKind, right: K.ExpressionKind, each: boolean): N.ComprehensionBlock;
    from(params: {
        comments?: K.CommentKind[] | null;
        each: boolean;
        left: K.PatternKind;
        loc?: K.SourceLocationKind | null;
        right: K.ExpressionKind;
    }): N.ComprehensionBlock;
}
export interface ComprehensionExpressionBuilder {
    (body: K.ExpressionKind, blocks: K.ComprehensionBlockKind[], filter: K.ExpressionKind | null): N.ComprehensionExpression;
    from(params: {
        blocks: K.ComprehensionBlockKind[];
        body: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        filter: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.ComprehensionExpression;
}
export interface ObjectPropertyBuilder {
    (key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, value: K.ExpressionKind | K.PatternKind): N.ObjectProperty;
    from(params: {
        accessibility?: K.LiteralKind | null;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        shorthand?: boolean;
        value: K.ExpressionKind | K.PatternKind;
    }): N.ObjectProperty;
}
export interface PropertyPatternBuilder {
    (key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, pattern: K.PatternKind): N.PropertyPattern;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        pattern: K.PatternKind;
    }): N.PropertyPattern;
}
export interface ObjectPatternBuilder {
    (properties: (K.PropertyKind | K.PropertyPatternKind | K.SpreadPropertyPatternKind | K.SpreadPropertyKind | K.ObjectPropertyKind | K.RestPropertyKind)[]): N.ObjectPattern;
    from(params: {
        comments?: K.CommentKind[] | null;
        decorators?: K.DecoratorKind[] | null;
        loc?: K.SourceLocationKind | null;
        properties: (K.PropertyKind | K.PropertyPatternKind | K.SpreadPropertyPatternKind | K.SpreadPropertyKind | K.ObjectPropertyKind | K.RestPropertyKind)[];
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    }): N.ObjectPattern;
}
export interface ArrayPatternBuilder {
    (elements: (K.PatternKind | K.SpreadElementKind | null)[]): N.ArrayPattern;
    from(params: {
        comments?: K.CommentKind[] | null;
        elements: (K.PatternKind | K.SpreadElementKind | null)[];
        loc?: K.SourceLocationKind | null;
    }): N.ArrayPattern;
}
export interface MethodDefinitionBuilder {
    (kind: "constructor" | "method" | "get" | "set", key: K.ExpressionKind, value: K.FunctionKind, staticParam?: boolean): N.MethodDefinition;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        key: K.ExpressionKind;
        kind: "constructor" | "method" | "get" | "set";
        loc?: K.SourceLocationKind | null;
        static?: boolean;
        value: K.FunctionKind;
    }): N.MethodDefinition;
}
export interface SpreadElementBuilder {
    (argument: K.ExpressionKind): N.SpreadElement;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.SpreadElement;
}
export interface AssignmentPatternBuilder {
    (left: K.PatternKind, right: K.ExpressionKind): N.AssignmentPattern;
    from(params: {
        comments?: K.CommentKind[] | null;
        left: K.PatternKind;
        loc?: K.SourceLocationKind | null;
        right: K.ExpressionKind;
    }): N.AssignmentPattern;
}
export interface ClassPropertyDefinitionBuilder {
    (definition: K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind): N.ClassPropertyDefinition;
    from(params: {
        comments?: K.CommentKind[] | null;
        definition: K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind;
        loc?: K.SourceLocationKind | null;
    }): N.ClassPropertyDefinition;
}
export interface ClassPropertyBuilder {
    (key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, value: K.ExpressionKind | null, typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null, staticParam?: boolean): N.ClassProperty;
    from(params: {
        access?: "public" | "private" | "protected" | undefined;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        static?: boolean;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        value: K.ExpressionKind | null;
        variance?: K.VarianceKind | "plus" | "minus" | null;
    }): N.ClassProperty;
}
export interface ClassBodyBuilder {
    (body: (K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind | K.ClassPrivatePropertyKind | K.ClassMethodKind | K.ClassPrivateMethodKind | K.TSDeclareMethodKind | K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[]): N.ClassBody;
    from(params: {
        body: (K.MethodDefinitionKind | K.VariableDeclaratorKind | K.ClassPropertyDefinitionKind | K.ClassPropertyKind | K.ClassPrivatePropertyKind | K.ClassMethodKind | K.ClassPrivateMethodKind | K.TSDeclareMethodKind | K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ClassBody;
}
export interface ClassDeclarationBuilder {
    (id: K.IdentifierKind | null, body: K.ClassBodyKind, superClass?: K.ExpressionKind | null): N.ClassDeclaration;
    from(params: {
        body: K.ClassBodyKind;
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind | null;
        implements?: K.ClassImplementsKind[] | K.TSExpressionWithTypeArgumentsKind[];
        loc?: K.SourceLocationKind | null;
        superClass?: K.ExpressionKind | null;
        superTypeParameters?: K.TypeParameterInstantiationKind | K.TSTypeParameterInstantiationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ClassDeclaration;
}
export interface ClassExpressionBuilder {
    (id: K.IdentifierKind | null | undefined, body: K.ClassBodyKind, superClass?: K.ExpressionKind | null): N.ClassExpression;
    from(params: {
        body: K.ClassBodyKind;
        comments?: K.CommentKind[] | null;
        id?: K.IdentifierKind | null;
        implements?: K.ClassImplementsKind[] | K.TSExpressionWithTypeArgumentsKind[];
        loc?: K.SourceLocationKind | null;
        superClass?: K.ExpressionKind | null;
        superTypeParameters?: K.TypeParameterInstantiationKind | K.TSTypeParameterInstantiationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ClassExpression;
}
export interface ImportSpecifierBuilder {
    (imported: K.IdentifierKind, local?: K.IdentifierKind | null): N.ImportSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        id?: K.IdentifierKind | null;
        imported: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        local?: K.IdentifierKind | null;
        name?: K.IdentifierKind | null;
    }): N.ImportSpecifier;
}
export interface ImportNamespaceSpecifierBuilder {
    (local?: K.IdentifierKind | null): N.ImportNamespaceSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        id?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        local?: K.IdentifierKind | null;
        name?: K.IdentifierKind | null;
    }): N.ImportNamespaceSpecifier;
}
export interface ImportDefaultSpecifierBuilder {
    (local?: K.IdentifierKind | null): N.ImportDefaultSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        id?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        local?: K.IdentifierKind | null;
        name?: K.IdentifierKind | null;
    }): N.ImportDefaultSpecifier;
}
export interface ImportDeclarationBuilder {
    (specifiers: (K.ImportSpecifierKind | K.ImportNamespaceSpecifierKind | K.ImportDefaultSpecifierKind)[] | undefined, source: K.LiteralKind, importKind?: "value" | "type"): N.ImportDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        importKind?: "value" | "type";
        loc?: K.SourceLocationKind | null;
        source: K.LiteralKind;
        specifiers?: (K.ImportSpecifierKind | K.ImportNamespaceSpecifierKind | K.ImportDefaultSpecifierKind)[];
    }): N.ImportDeclaration;
}
export interface TaggedTemplateExpressionBuilder {
    (tag: K.ExpressionKind, quasi: K.TemplateLiteralKind): N.TaggedTemplateExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        quasi: K.TemplateLiteralKind;
        tag: K.ExpressionKind;
    }): N.TaggedTemplateExpression;
}
export interface TemplateLiteralBuilder {
    (quasis: K.TemplateElementKind[], expressions: K.ExpressionKind[]): N.TemplateLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        expressions: K.ExpressionKind[];
        loc?: K.SourceLocationKind | null;
        quasis: K.TemplateElementKind[];
    }): N.TemplateLiteral;
}
export interface TemplateElementBuilder {
    (value: {
        cooked: string;
        raw: string;
    }, tail: boolean): N.TemplateElement;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        tail: boolean;
        value: {
            cooked: string;
            raw: string;
        };
    }): N.TemplateElement;
}
export interface SpreadPropertyBuilder {
    (argument: K.ExpressionKind): N.SpreadProperty;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.SpreadProperty;
}
export interface SpreadPropertyPatternBuilder {
    (argument: K.PatternKind): N.SpreadPropertyPattern;
    from(params: {
        argument: K.PatternKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.SpreadPropertyPattern;
}
export interface AwaitExpressionBuilder {
    (argument: K.ExpressionKind | null, all?: boolean): N.AwaitExpression;
    from(params: {
        all?: boolean;
        argument: K.ExpressionKind | null;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.AwaitExpression;
}
export interface JSXAttributeBuilder {
    (name: K.JSXIdentifierKind | K.JSXNamespacedNameKind, value?: K.LiteralKind | K.JSXExpressionContainerKind | null): N.JSXAttribute;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: K.JSXIdentifierKind | K.JSXNamespacedNameKind;
        value?: K.LiteralKind | K.JSXExpressionContainerKind | null;
    }): N.JSXAttribute;
}
export interface JSXIdentifierBuilder {
    (name: string): N.JSXIdentifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: string;
        optional?: boolean;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    }): N.JSXIdentifier;
}
export interface JSXNamespacedNameBuilder {
    (namespace: K.JSXIdentifierKind, name: K.JSXIdentifierKind): N.JSXNamespacedName;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: K.JSXIdentifierKind;
        namespace: K.JSXIdentifierKind;
    }): N.JSXNamespacedName;
}
export interface JSXExpressionContainerBuilder {
    (expression: K.ExpressionKind): N.JSXExpressionContainer;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.JSXExpressionContainer;
}
export interface JSXMemberExpressionBuilder {
    (object: K.JSXIdentifierKind | K.JSXMemberExpressionKind, property: K.JSXIdentifierKind): N.JSXMemberExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        loc?: K.SourceLocationKind | null;
        object: K.JSXIdentifierKind | K.JSXMemberExpressionKind;
        property: K.JSXIdentifierKind;
    }): N.JSXMemberExpression;
}
export interface JSXSpreadAttributeBuilder {
    (argument: K.ExpressionKind): N.JSXSpreadAttribute;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.JSXSpreadAttribute;
}
export interface JSXElementBuilder {
    (openingElement: K.JSXOpeningElementKind, closingElement?: K.JSXClosingElementKind | null, children?: (K.JSXElementKind | K.JSXExpressionContainerKind | K.JSXFragmentKind | K.JSXTextKind | K.LiteralKind)[]): N.JSXElement;
    from(params: {
        attributes?: (K.JSXAttributeKind | K.JSXSpreadAttributeKind)[];
        children?: (K.JSXElementKind | K.JSXExpressionContainerKind | K.JSXFragmentKind | K.JSXTextKind | K.LiteralKind)[];
        closingElement?: K.JSXClosingElementKind | null;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name?: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
        openingElement: K.JSXOpeningElementKind;
        selfClosing?: boolean;
    }): N.JSXElement;
}
export interface JSXOpeningElementBuilder {
    (name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind, attributes?: (K.JSXAttributeKind | K.JSXSpreadAttributeKind)[], selfClosing?: boolean): N.JSXOpeningElement;
    from(params: {
        attributes?: (K.JSXAttributeKind | K.JSXSpreadAttributeKind)[];
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
        selfClosing?: boolean;
    }): N.JSXOpeningElement;
}
export interface JSXClosingElementBuilder {
    (name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind): N.JSXClosingElement;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: K.JSXIdentifierKind | K.JSXNamespacedNameKind | K.JSXMemberExpressionKind;
    }): N.JSXClosingElement;
}
export interface JSXFragmentBuilder {
    (openingElement: K.JSXOpeningFragmentKind, closingElement: K.JSXClosingFragmentKind, children?: (K.JSXElementKind | K.JSXExpressionContainerKind | K.JSXFragmentKind | K.JSXTextKind | K.LiteralKind)[]): N.JSXFragment;
    from(params: {
        children?: (K.JSXElementKind | K.JSXExpressionContainerKind | K.JSXFragmentKind | K.JSXTextKind | K.LiteralKind)[];
        closingElement: K.JSXClosingFragmentKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        openingElement: K.JSXOpeningFragmentKind;
    }): N.JSXFragment;
}
export interface JSXTextBuilder {
    (value: string): N.JSXText;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: string;
    }): N.JSXText;
}
export interface JSXOpeningFragmentBuilder {
    (): N.JSXOpeningFragment;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.JSXOpeningFragment;
}
export interface JSXClosingFragmentBuilder {
    (): N.JSXClosingFragment;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.JSXClosingFragment;
}
export interface JSXEmptyExpressionBuilder {
    (): N.JSXEmptyExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.JSXEmptyExpression;
}
export interface JSXSpreadChildBuilder {
    (expression: K.ExpressionKind): N.JSXSpreadChild;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.JSXSpreadChild;
}
export interface TypeParameterDeclarationBuilder {
    (params: K.TypeParameterKind[]): N.TypeParameterDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        params: K.TypeParameterKind[];
    }): N.TypeParameterDeclaration;
}
export interface TSTypeParameterDeclarationBuilder {
    (params: K.TSTypeParameterKind[]): N.TSTypeParameterDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        params: K.TSTypeParameterKind[];
    }): N.TSTypeParameterDeclaration;
}
export interface TypeParameterInstantiationBuilder {
    (params: K.FlowTypeKind[]): N.TypeParameterInstantiation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        params: K.FlowTypeKind[];
    }): N.TypeParameterInstantiation;
}
export interface TSTypeParameterInstantiationBuilder {
    (params: K.TSTypeKind[]): N.TSTypeParameterInstantiation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        params: K.TSTypeKind[];
    }): N.TSTypeParameterInstantiation;
}
export interface ClassImplementsBuilder {
    (id: K.IdentifierKind): N.ClassImplements;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        superClass?: K.ExpressionKind | null;
        typeParameters?: K.TypeParameterInstantiationKind | null;
    }): N.ClassImplements;
}
export interface TSExpressionWithTypeArgumentsBuilder {
    (expression: K.IdentifierKind | K.TSQualifiedNameKind, typeParameters?: K.TSTypeParameterInstantiationKind | null): N.TSExpressionWithTypeArguments;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.IdentifierKind | K.TSQualifiedNameKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TSTypeParameterInstantiationKind | null;
    }): N.TSExpressionWithTypeArguments;
}
export interface AnyTypeAnnotationBuilder {
    (): N.AnyTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.AnyTypeAnnotation;
}
export interface EmptyTypeAnnotationBuilder {
    (): N.EmptyTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.EmptyTypeAnnotation;
}
export interface MixedTypeAnnotationBuilder {
    (): N.MixedTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.MixedTypeAnnotation;
}
export interface VoidTypeAnnotationBuilder {
    (): N.VoidTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.VoidTypeAnnotation;
}
export interface NumberTypeAnnotationBuilder {
    (): N.NumberTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.NumberTypeAnnotation;
}
export interface NumberLiteralTypeAnnotationBuilder {
    (value: number, raw: string): N.NumberLiteralTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        raw: string;
        value: number;
    }): N.NumberLiteralTypeAnnotation;
}
export interface NumericLiteralTypeAnnotationBuilder {
    (value: number, raw: string): N.NumericLiteralTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        raw: string;
        value: number;
    }): N.NumericLiteralTypeAnnotation;
}
export interface StringTypeAnnotationBuilder {
    (): N.StringTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.StringTypeAnnotation;
}
export interface StringLiteralTypeAnnotationBuilder {
    (value: string, raw: string): N.StringLiteralTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        raw: string;
        value: string;
    }): N.StringLiteralTypeAnnotation;
}
export interface BooleanTypeAnnotationBuilder {
    (): N.BooleanTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.BooleanTypeAnnotation;
}
export interface BooleanLiteralTypeAnnotationBuilder {
    (value: boolean, raw: string): N.BooleanLiteralTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        raw: string;
        value: boolean;
    }): N.BooleanLiteralTypeAnnotation;
}
export interface NullableTypeAnnotationBuilder {
    (typeAnnotation: K.FlowTypeKind): N.NullableTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.FlowTypeKind;
    }): N.NullableTypeAnnotation;
}
export interface NullLiteralTypeAnnotationBuilder {
    (): N.NullLiteralTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.NullLiteralTypeAnnotation;
}
export interface NullTypeAnnotationBuilder {
    (): N.NullTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.NullTypeAnnotation;
}
export interface ThisTypeAnnotationBuilder {
    (): N.ThisTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ThisTypeAnnotation;
}
export interface ExistsTypeAnnotationBuilder {
    (): N.ExistsTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ExistsTypeAnnotation;
}
export interface ExistentialTypeParamBuilder {
    (): N.ExistentialTypeParam;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ExistentialTypeParam;
}
export interface FunctionTypeAnnotationBuilder {
    (params: K.FunctionTypeParamKind[], returnType: K.FlowTypeKind, rest: K.FunctionTypeParamKind | null, typeParameters: K.TypeParameterDeclarationKind | null): N.FunctionTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        params: K.FunctionTypeParamKind[];
        rest: K.FunctionTypeParamKind | null;
        returnType: K.FlowTypeKind;
        typeParameters: K.TypeParameterDeclarationKind | null;
    }): N.FunctionTypeAnnotation;
}
export interface FunctionTypeParamBuilder {
    (name: K.IdentifierKind, typeAnnotation: K.FlowTypeKind, optional: boolean): N.FunctionTypeParam;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: K.IdentifierKind;
        optional: boolean;
        typeAnnotation: K.FlowTypeKind;
    }): N.FunctionTypeParam;
}
export interface ArrayTypeAnnotationBuilder {
    (elementType: K.FlowTypeKind): N.ArrayTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        elementType: K.FlowTypeKind;
        loc?: K.SourceLocationKind | null;
    }): N.ArrayTypeAnnotation;
}
export interface ObjectTypeAnnotationBuilder {
    (properties: (K.ObjectTypePropertyKind | K.ObjectTypeSpreadPropertyKind)[], indexers?: K.ObjectTypeIndexerKind[], callProperties?: K.ObjectTypeCallPropertyKind[]): N.ObjectTypeAnnotation;
    from(params: {
        callProperties?: K.ObjectTypeCallPropertyKind[];
        comments?: K.CommentKind[] | null;
        exact?: boolean;
        indexers?: K.ObjectTypeIndexerKind[];
        inexact?: boolean | undefined;
        internalSlots?: K.ObjectTypeInternalSlotKind[];
        loc?: K.SourceLocationKind | null;
        properties: (K.ObjectTypePropertyKind | K.ObjectTypeSpreadPropertyKind)[];
    }): N.ObjectTypeAnnotation;
}
export interface ObjectTypePropertyBuilder {
    (key: K.LiteralKind | K.IdentifierKind, value: K.FlowTypeKind, optional: boolean): N.ObjectTypeProperty;
    from(params: {
        comments?: K.CommentKind[] | null;
        key: K.LiteralKind | K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        optional: boolean;
        value: K.FlowTypeKind;
        variance?: K.VarianceKind | "plus" | "minus" | null;
    }): N.ObjectTypeProperty;
}
export interface ObjectTypeSpreadPropertyBuilder {
    (argument: K.FlowTypeKind): N.ObjectTypeSpreadProperty;
    from(params: {
        argument: K.FlowTypeKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ObjectTypeSpreadProperty;
}
export interface ObjectTypeIndexerBuilder {
    (id: K.IdentifierKind, key: K.FlowTypeKind, value: K.FlowTypeKind): N.ObjectTypeIndexer;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        key: K.FlowTypeKind;
        loc?: K.SourceLocationKind | null;
        value: K.FlowTypeKind;
        variance?: K.VarianceKind | "plus" | "minus" | null;
    }): N.ObjectTypeIndexer;
}
export interface ObjectTypeCallPropertyBuilder {
    (value: K.FunctionTypeAnnotationKind): N.ObjectTypeCallProperty;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        static?: boolean;
        value: K.FunctionTypeAnnotationKind;
    }): N.ObjectTypeCallProperty;
}
export interface ObjectTypeInternalSlotBuilder {
    (id: K.IdentifierKind, value: K.FlowTypeKind, optional: boolean, staticParam: boolean, method: boolean): N.ObjectTypeInternalSlot;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        method: boolean;
        optional: boolean;
        static: boolean;
        value: K.FlowTypeKind;
    }): N.ObjectTypeInternalSlot;
}
export interface VarianceBuilder {
    (kind: "plus" | "minus"): N.Variance;
    from(params: {
        comments?: K.CommentKind[] | null;
        kind: "plus" | "minus";
        loc?: K.SourceLocationKind | null;
    }): N.Variance;
}
export interface QualifiedTypeIdentifierBuilder {
    (qualification: K.IdentifierKind | K.QualifiedTypeIdentifierKind, id: K.IdentifierKind): N.QualifiedTypeIdentifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        qualification: K.IdentifierKind | K.QualifiedTypeIdentifierKind;
    }): N.QualifiedTypeIdentifier;
}
export interface GenericTypeAnnotationBuilder {
    (id: K.IdentifierKind | K.QualifiedTypeIdentifierKind, typeParameters: K.TypeParameterInstantiationKind | null): N.GenericTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind | K.QualifiedTypeIdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeParameters: K.TypeParameterInstantiationKind | null;
    }): N.GenericTypeAnnotation;
}
export interface MemberTypeAnnotationBuilder {
    (object: K.IdentifierKind, property: K.MemberTypeAnnotationKind | K.GenericTypeAnnotationKind): N.MemberTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        object: K.IdentifierKind;
        property: K.MemberTypeAnnotationKind | K.GenericTypeAnnotationKind;
    }): N.MemberTypeAnnotation;
}
export interface UnionTypeAnnotationBuilder {
    (types: K.FlowTypeKind[]): N.UnionTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        types: K.FlowTypeKind[];
    }): N.UnionTypeAnnotation;
}
export interface IntersectionTypeAnnotationBuilder {
    (types: K.FlowTypeKind[]): N.IntersectionTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        types: K.FlowTypeKind[];
    }): N.IntersectionTypeAnnotation;
}
export interface TypeofTypeAnnotationBuilder {
    (argument: K.FlowTypeKind): N.TypeofTypeAnnotation;
    from(params: {
        argument: K.FlowTypeKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TypeofTypeAnnotation;
}
export interface TypeParameterBuilder {
    (name: string, variance?: K.VarianceKind | "plus" | "minus" | null, bound?: K.TypeAnnotationKind | null): N.TypeParameter;
    from(params: {
        bound?: K.TypeAnnotationKind | null;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        name: string;
        variance?: K.VarianceKind | "plus" | "minus" | null;
    }): N.TypeParameter;
}
export interface InterfaceTypeAnnotationBuilder {
    (body: K.ObjectTypeAnnotationKind, extendsParam?: K.InterfaceExtendsKind[] | null): N.InterfaceTypeAnnotation;
    from(params: {
        body: K.ObjectTypeAnnotationKind;
        comments?: K.CommentKind[] | null;
        extends?: K.InterfaceExtendsKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.InterfaceTypeAnnotation;
}
export interface InterfaceExtendsBuilder {
    (id: K.IdentifierKind): N.InterfaceExtends;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TypeParameterInstantiationKind | null;
    }): N.InterfaceExtends;
}
export interface InterfaceDeclarationBuilder {
    (id: K.IdentifierKind, body: K.ObjectTypeAnnotationKind, extendsParam: K.InterfaceExtendsKind[]): N.InterfaceDeclaration;
    from(params: {
        body: K.ObjectTypeAnnotationKind;
        comments?: K.CommentKind[] | null;
        extends: K.InterfaceExtendsKind[];
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | null;
    }): N.InterfaceDeclaration;
}
export interface DeclareInterfaceBuilder {
    (id: K.IdentifierKind, body: K.ObjectTypeAnnotationKind, extendsParam: K.InterfaceExtendsKind[]): N.DeclareInterface;
    from(params: {
        body: K.ObjectTypeAnnotationKind;
        comments?: K.CommentKind[] | null;
        extends: K.InterfaceExtendsKind[];
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | null;
    }): N.DeclareInterface;
}
export interface TypeAliasBuilder {
    (id: K.IdentifierKind, typeParameters: K.TypeParameterDeclarationKind | null, right: K.FlowTypeKind): N.TypeAlias;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        right: K.FlowTypeKind;
        typeParameters: K.TypeParameterDeclarationKind | null;
    }): N.TypeAlias;
}
export interface OpaqueTypeBuilder {
    (id: K.IdentifierKind, typeParameters: K.TypeParameterDeclarationKind | null, impltype: K.FlowTypeKind, supertype: K.FlowTypeKind): N.OpaqueType;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        impltype: K.FlowTypeKind;
        loc?: K.SourceLocationKind | null;
        supertype: K.FlowTypeKind;
        typeParameters: K.TypeParameterDeclarationKind | null;
    }): N.OpaqueType;
}
export interface DeclareTypeAliasBuilder {
    (id: K.IdentifierKind, typeParameters: K.TypeParameterDeclarationKind | null, right: K.FlowTypeKind): N.DeclareTypeAlias;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        right: K.FlowTypeKind;
        typeParameters: K.TypeParameterDeclarationKind | null;
    }): N.DeclareTypeAlias;
}
export interface DeclareOpaqueTypeBuilder {
    (id: K.IdentifierKind, typeParameters: K.TypeParameterDeclarationKind | null): N.DeclareOpaqueType;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        right: K.FlowTypeKind;
        typeParameters: K.TypeParameterDeclarationKind | null;
    }): N.DeclareOpaqueType;
}
export interface TypeCastExpressionBuilder {
    (expression: K.ExpressionKind, typeAnnotation: K.TypeAnnotationKind): N.TypeCastExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TypeAnnotationKind;
    }): N.TypeCastExpression;
}
export interface TupleTypeAnnotationBuilder {
    (types: K.FlowTypeKind[]): N.TupleTypeAnnotation;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        types: K.FlowTypeKind[];
    }): N.TupleTypeAnnotation;
}
export interface DeclareVariableBuilder {
    (id: K.IdentifierKind): N.DeclareVariable;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.DeclareVariable;
}
export interface DeclareFunctionBuilder {
    (id: K.IdentifierKind): N.DeclareFunction;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.DeclareFunction;
}
export interface DeclareClassBuilder {
    (id: K.IdentifierKind): N.DeclareClass;
    from(params: {
        body: K.ObjectTypeAnnotationKind;
        comments?: K.CommentKind[] | null;
        extends: K.InterfaceExtendsKind[];
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | null;
    }): N.DeclareClass;
}
export interface DeclareModuleBuilder {
    (id: K.IdentifierKind | K.LiteralKind, body: K.BlockStatementKind): N.DeclareModule;
    from(params: {
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind | K.LiteralKind;
        loc?: K.SourceLocationKind | null;
    }): N.DeclareModule;
}
export interface DeclareModuleExportsBuilder {
    (typeAnnotation: K.TypeAnnotationKind): N.DeclareModuleExports;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TypeAnnotationKind;
    }): N.DeclareModuleExports;
}
export interface DeclareExportDeclarationBuilder {
    (defaultParam: boolean, declaration: K.DeclareVariableKind | K.DeclareFunctionKind | K.DeclareClassKind | K.FlowTypeKind | null, specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[], source?: K.LiteralKind | null): N.DeclareExportDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declaration: K.DeclareVariableKind | K.DeclareFunctionKind | K.DeclareClassKind | K.FlowTypeKind | null;
        default: boolean;
        loc?: K.SourceLocationKind | null;
        source?: K.LiteralKind | null;
        specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[];
    }): N.DeclareExportDeclaration;
}
export interface ExportSpecifierBuilder {
    (local: K.IdentifierKind | null | undefined, exported: K.IdentifierKind): N.ExportSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        exported: K.IdentifierKind;
        id?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        local?: K.IdentifierKind | null;
        name?: K.IdentifierKind | null;
    }): N.ExportSpecifier;
}
export interface ExportBatchSpecifierBuilder {
    (): N.ExportBatchSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.ExportBatchSpecifier;
}
export interface DeclareExportAllDeclarationBuilder {
    (source?: K.LiteralKind | null): N.DeclareExportAllDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        source?: K.LiteralKind | null;
    }): N.DeclareExportAllDeclaration;
}
export interface InferredPredicateBuilder {
    (): N.InferredPredicate;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.InferredPredicate;
}
export interface DeclaredPredicateBuilder {
    (value: K.ExpressionKind): N.DeclaredPredicate;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        value: K.ExpressionKind;
    }): N.DeclaredPredicate;
}
export interface ExportDeclarationBuilder {
    (defaultParam: boolean, declaration: K.DeclarationKind | K.ExpressionKind | null, specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[], source?: K.LiteralKind | null): N.ExportDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declaration: K.DeclarationKind | K.ExpressionKind | null;
        default: boolean;
        loc?: K.SourceLocationKind | null;
        source?: K.LiteralKind | null;
        specifiers?: (K.ExportSpecifierKind | K.ExportBatchSpecifierKind)[];
    }): N.ExportDeclaration;
}
export interface BlockBuilder {
    (value: string, leading?: boolean, trailing?: boolean): N.Block;
    from(params: {
        leading?: boolean;
        loc?: K.SourceLocationKind | null;
        trailing?: boolean;
        value: string;
    }): N.Block;
}
export interface LineBuilder {
    (value: string, leading?: boolean, trailing?: boolean): N.Line;
    from(params: {
        leading?: boolean;
        loc?: K.SourceLocationKind | null;
        trailing?: boolean;
        value: string;
    }): N.Line;
}
export interface NoopBuilder {
    (): N.Noop;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.Noop;
}
export interface DoExpressionBuilder {
    (body: K.StatementKind[]): N.DoExpression;
    from(params: {
        body: K.StatementKind[];
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.DoExpression;
}
export interface SuperBuilder {
    (): N.Super;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.Super;
}
export interface BindExpressionBuilder {
    (object: K.ExpressionKind | null, callee: K.ExpressionKind): N.BindExpression;
    from(params: {
        callee: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        object: K.ExpressionKind | null;
    }): N.BindExpression;
}
export interface DecoratorBuilder {
    (expression: K.ExpressionKind): N.Decorator;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.Decorator;
}
export interface MetaPropertyBuilder {
    (meta: K.IdentifierKind, property: K.IdentifierKind): N.MetaProperty;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        meta: K.IdentifierKind;
        property: K.IdentifierKind;
    }): N.MetaProperty;
}
export interface ParenthesizedExpressionBuilder {
    (expression: K.ExpressionKind): N.ParenthesizedExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.ParenthesizedExpression;
}
export interface ExportDefaultDeclarationBuilder {
    (declaration: K.DeclarationKind | K.ExpressionKind): N.ExportDefaultDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declaration: K.DeclarationKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.ExportDefaultDeclaration;
}
export interface ExportNamedDeclarationBuilder {
    (declaration: K.DeclarationKind | null, specifiers?: K.ExportSpecifierKind[], source?: K.LiteralKind | null): N.ExportNamedDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declaration: K.DeclarationKind | null;
        loc?: K.SourceLocationKind | null;
        source?: K.LiteralKind | null;
        specifiers?: K.ExportSpecifierKind[];
    }): N.ExportNamedDeclaration;
}
export interface ExportNamespaceSpecifierBuilder {
    (exported: K.IdentifierKind): N.ExportNamespaceSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        exported: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.ExportNamespaceSpecifier;
}
export interface ExportDefaultSpecifierBuilder {
    (exported: K.IdentifierKind): N.ExportDefaultSpecifier;
    from(params: {
        comments?: K.CommentKind[] | null;
        exported: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.ExportDefaultSpecifier;
}
export interface ExportAllDeclarationBuilder {
    (exported: K.IdentifierKind | null, source: K.LiteralKind): N.ExportAllDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        exported: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        source: K.LiteralKind;
    }): N.ExportAllDeclaration;
}
export interface CommentBlockBuilder {
    (value: string, leading?: boolean, trailing?: boolean): N.CommentBlock;
    from(params: {
        leading?: boolean;
        loc?: K.SourceLocationKind | null;
        trailing?: boolean;
        value: string;
    }): N.CommentBlock;
}
export interface CommentLineBuilder {
    (value: string, leading?: boolean, trailing?: boolean): N.CommentLine;
    from(params: {
        leading?: boolean;
        loc?: K.SourceLocationKind | null;
        trailing?: boolean;
        value: string;
    }): N.CommentLine;
}
export interface DirectiveBuilder {
    (value: K.DirectiveLiteralKind): N.Directive;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        value: K.DirectiveLiteralKind;
    }): N.Directive;
}
export interface DirectiveLiteralBuilder {
    (value?: string): N.DirectiveLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        value?: string;
    }): N.DirectiveLiteral;
}
export interface InterpreterDirectiveBuilder {
    (value: string): N.InterpreterDirective;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        value: string;
    }): N.InterpreterDirective;
}
export interface StringLiteralBuilder {
    (value: string): N.StringLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: string;
    }): N.StringLiteral;
}
export interface NumericLiteralBuilder {
    (value: number): N.NumericLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        extra?: {
            rawValue: number;
            raw: string;
        };
        loc?: K.SourceLocationKind | null;
        raw?: string | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: number;
    }): N.NumericLiteral;
}
export interface BigIntLiteralBuilder {
    (value: string | number): N.BigIntLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        extra?: {
            rawValue: string;
            raw: string;
        };
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: string | number;
    }): N.BigIntLiteral;
}
export interface NullLiteralBuilder {
    (): N.NullLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value?: null;
    }): N.NullLiteral;
}
export interface BooleanLiteralBuilder {
    (value: boolean): N.BooleanLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value: boolean;
    }): N.BooleanLiteral;
}
export interface RegExpLiteralBuilder {
    (pattern: string, flags: string): N.RegExpLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        flags: string;
        loc?: K.SourceLocationKind | null;
        pattern: string;
        regex?: {
            pattern: string;
            flags: string;
        } | null;
        value?: RegExp;
    }): N.RegExpLiteral;
}
export interface ObjectMethodBuilder {
    (kind: "method" | "get" | "set", key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, params: K.PatternKind[], body: K.BlockStatementKind, computed?: boolean): N.ObjectMethod;
    from(params: {
        accessibility?: K.LiteralKind | null;
        async?: boolean;
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: boolean;
        id?: K.IdentifierKind | null;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        kind: "method" | "get" | "set";
        loc?: K.SourceLocationKind | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ObjectMethod;
}
export interface ClassPrivatePropertyBuilder {
    (key: K.PrivateNameKind, value?: K.ExpressionKind | null): N.ClassPrivateProperty;
    from(params: {
        access?: "public" | "private" | "protected" | undefined;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        key: K.PrivateNameKind;
        loc?: K.SourceLocationKind | null;
        static?: boolean;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        value?: K.ExpressionKind | null;
        variance?: K.VarianceKind | "plus" | "minus" | null;
    }): N.ClassPrivateProperty;
}
export interface ClassMethodBuilder {
    (kind: "get" | "set" | "method" | "constructor" | undefined, key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind, params: K.PatternKind[], body: K.BlockStatementKind, computed?: boolean, staticParam?: boolean | null): N.ClassMethod;
    from(params: {
        abstract?: boolean | null;
        access?: "public" | "private" | "protected" | null;
        accessibility?: "public" | "private" | "protected" | null;
        async?: boolean;
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: boolean;
        id?: K.IdentifierKind | null;
        key: K.LiteralKind | K.IdentifierKind | K.ExpressionKind;
        kind?: "get" | "set" | "method" | "constructor";
        loc?: K.SourceLocationKind | null;
        optional?: boolean | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        static?: boolean | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ClassMethod;
}
export interface ClassPrivateMethodBuilder {
    (key: K.PrivateNameKind, params: K.PatternKind[], body: K.BlockStatementKind, kind?: "get" | "set" | "method" | "constructor", computed?: boolean, staticParam?: boolean | null): N.ClassPrivateMethod;
    from(params: {
        abstract?: boolean | null;
        access?: "public" | "private" | "protected" | null;
        accessibility?: "public" | "private" | "protected" | null;
        async?: boolean;
        body: K.BlockStatementKind;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        defaults?: (K.ExpressionKind | null)[];
        expression?: boolean;
        generator?: boolean;
        id?: K.IdentifierKind | null;
        key: K.PrivateNameKind;
        kind?: "get" | "set" | "method" | "constructor";
        loc?: K.SourceLocationKind | null;
        optional?: boolean | null;
        params: K.PatternKind[];
        rest?: K.IdentifierKind | null;
        returnType?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
        static?: boolean | null;
        typeParameters?: K.TypeParameterDeclarationKind | K.TSTypeParameterDeclarationKind | null;
    }): N.ClassPrivateMethod;
}
export interface PrivateNameBuilder {
    (id: K.IdentifierKind): N.PrivateName;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.PrivateName;
}
export interface RestPropertyBuilder {
    (argument: K.ExpressionKind): N.RestProperty;
    from(params: {
        argument: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.RestProperty;
}
export interface ForAwaitStatementBuilder {
    (left: K.VariableDeclarationKind | K.ExpressionKind, right: K.ExpressionKind, body: K.StatementKind): N.ForAwaitStatement;
    from(params: {
        body: K.StatementKind;
        comments?: K.CommentKind[] | null;
        left: K.VariableDeclarationKind | K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        right: K.ExpressionKind;
    }): N.ForAwaitStatement;
}
export interface ImportBuilder {
    (): N.Import;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.Import;
}
export interface TSQualifiedNameBuilder {
    (left: K.IdentifierKind | K.TSQualifiedNameKind, right: K.IdentifierKind | K.TSQualifiedNameKind): N.TSQualifiedName;
    from(params: {
        comments?: K.CommentKind[] | null;
        left: K.IdentifierKind | K.TSQualifiedNameKind;
        loc?: K.SourceLocationKind | null;
        right: K.IdentifierKind | K.TSQualifiedNameKind;
    }): N.TSQualifiedName;
}
export interface TSTypeReferenceBuilder {
    (typeName: K.IdentifierKind | K.TSQualifiedNameKind, typeParameters?: K.TSTypeParameterInstantiationKind | null): N.TSTypeReference;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeName: K.IdentifierKind | K.TSQualifiedNameKind;
        typeParameters?: K.TSTypeParameterInstantiationKind | null;
    }): N.TSTypeReference;
}
export interface TSAsExpressionBuilder {
    (expression: K.ExpressionKind): N.TSAsExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        extra?: {
            parenthesized: boolean;
        } | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
    }): N.TSAsExpression;
}
export interface TSNonNullExpressionBuilder {
    (expression: K.ExpressionKind): N.TSNonNullExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSNonNullExpression;
}
export interface TSAnyKeywordBuilder {
    (): N.TSAnyKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSAnyKeyword;
}
export interface TSBigIntKeywordBuilder {
    (): N.TSBigIntKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSBigIntKeyword;
}
export interface TSBooleanKeywordBuilder {
    (): N.TSBooleanKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSBooleanKeyword;
}
export interface TSNeverKeywordBuilder {
    (): N.TSNeverKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSNeverKeyword;
}
export interface TSNullKeywordBuilder {
    (): N.TSNullKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSNullKeyword;
}
export interface TSNumberKeywordBuilder {
    (): N.TSNumberKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSNumberKeyword;
}
export interface TSObjectKeywordBuilder {
    (): N.TSObjectKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSObjectKeyword;
}
export interface TSStringKeywordBuilder {
    (): N.TSStringKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSStringKeyword;
}
export interface TSSymbolKeywordBuilder {
    (): N.TSSymbolKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSSymbolKeyword;
}
export interface TSUndefinedKeywordBuilder {
    (): N.TSUndefinedKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSUndefinedKeyword;
}
export interface TSUnknownKeywordBuilder {
    (): N.TSUnknownKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSUnknownKeyword;
}
export interface TSVoidKeywordBuilder {
    (): N.TSVoidKeyword;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSVoidKeyword;
}
export interface TSThisTypeBuilder {
    (): N.TSThisType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSThisType;
}
export interface TSArrayTypeBuilder {
    (elementType: K.TSTypeKind): N.TSArrayType;
    from(params: {
        comments?: K.CommentKind[] | null;
        elementType: K.TSTypeKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSArrayType;
}
export interface TSLiteralTypeBuilder {
    (literal: K.NumericLiteralKind | K.StringLiteralKind | K.BooleanLiteralKind | K.TemplateLiteralKind | K.UnaryExpressionKind): N.TSLiteralType;
    from(params: {
        comments?: K.CommentKind[] | null;
        literal: K.NumericLiteralKind | K.StringLiteralKind | K.BooleanLiteralKind | K.TemplateLiteralKind | K.UnaryExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSLiteralType;
}
export interface TSUnionTypeBuilder {
    (types: K.TSTypeKind[]): N.TSUnionType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        types: K.TSTypeKind[];
    }): N.TSUnionType;
}
export interface TSIntersectionTypeBuilder {
    (types: K.TSTypeKind[]): N.TSIntersectionType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        types: K.TSTypeKind[];
    }): N.TSIntersectionType;
}
export interface TSConditionalTypeBuilder {
    (checkType: K.TSTypeKind, extendsType: K.TSTypeKind, trueType: K.TSTypeKind, falseType: K.TSTypeKind): N.TSConditionalType;
    from(params: {
        checkType: K.TSTypeKind;
        comments?: K.CommentKind[] | null;
        extendsType: K.TSTypeKind;
        falseType: K.TSTypeKind;
        loc?: K.SourceLocationKind | null;
        trueType: K.TSTypeKind;
    }): N.TSConditionalType;
}
export interface TSInferTypeBuilder {
    (typeParameter: K.TSTypeParameterKind): N.TSInferType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeParameter: K.TSTypeParameterKind;
    }): N.TSInferType;
}
export interface TSTypeParameterBuilder {
    (name: string, constraint?: K.TSTypeKind | undefined, defaultParam?: K.TSTypeKind | undefined): N.TSTypeParameter;
    from(params: {
        comments?: K.CommentKind[] | null;
        constraint?: K.TSTypeKind | undefined;
        default?: K.TSTypeKind | undefined;
        loc?: K.SourceLocationKind | null;
        name: string;
        optional?: boolean;
        typeAnnotation?: K.TypeAnnotationKind | K.TSTypeAnnotationKind | null;
    }): N.TSTypeParameter;
}
export interface TSParenthesizedTypeBuilder {
    (typeAnnotation: K.TSTypeKind): N.TSParenthesizedType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
    }): N.TSParenthesizedType;
}
export interface TSFunctionTypeBuilder {
    (parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[]): N.TSFunctionType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
        typeAnnotation?: K.TSTypeAnnotationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSFunctionType;
}
export interface TSConstructorTypeBuilder {
    (parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[]): N.TSConstructorType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
        typeAnnotation?: K.TSTypeAnnotationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSConstructorType;
}
export interface TSDeclareFunctionBuilder {
    (id: K.IdentifierKind | null | undefined, params: K.PatternKind[], returnType?: K.TSTypeAnnotationKind | K.NoopKind | null): N.TSDeclareFunction;
    from(params: {
        async?: boolean;
        comments?: K.CommentKind[] | null;
        declare?: boolean;
        generator?: boolean;
        id?: K.IdentifierKind | null;
        loc?: K.SourceLocationKind | null;
        params: K.PatternKind[];
        returnType?: K.TSTypeAnnotationKind | K.NoopKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSDeclareFunction;
}
export interface TSDeclareMethodBuilder {
    (key: K.IdentifierKind | K.StringLiteralKind | K.NumericLiteralKind | K.ExpressionKind, params: K.PatternKind[], returnType?: K.TSTypeAnnotationKind | K.NoopKind | null): N.TSDeclareMethod;
    from(params: {
        abstract?: boolean;
        access?: "public" | "private" | "protected" | undefined;
        accessibility?: "public" | "private" | "protected" | undefined;
        async?: boolean;
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        decorators?: K.DecoratorKind[] | null;
        generator?: boolean;
        key: K.IdentifierKind | K.StringLiteralKind | K.NumericLiteralKind | K.ExpressionKind;
        kind?: "get" | "set" | "method" | "constructor";
        loc?: K.SourceLocationKind | null;
        optional?: boolean;
        params: K.PatternKind[];
        returnType?: K.TSTypeAnnotationKind | K.NoopKind | null;
        static?: boolean;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSDeclareMethod;
}
export interface TSMappedTypeBuilder {
    (typeParameter: K.TSTypeParameterKind, typeAnnotation?: K.TSTypeKind | null): N.TSMappedType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        optional?: boolean | "+" | "-";
        readonly?: boolean | "+" | "-";
        typeAnnotation?: K.TSTypeKind | null;
        typeParameter: K.TSTypeParameterKind;
    }): N.TSMappedType;
}
export interface TSTupleTypeBuilder {
    (elementTypes: K.TSTypeKind[]): N.TSTupleType;
    from(params: {
        comments?: K.CommentKind[] | null;
        elementTypes: K.TSTypeKind[];
        loc?: K.SourceLocationKind | null;
    }): N.TSTupleType;
}
export interface TSRestTypeBuilder {
    (typeAnnotation: K.TSTypeKind): N.TSRestType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
    }): N.TSRestType;
}
export interface TSOptionalTypeBuilder {
    (typeAnnotation: K.TSTypeKind): N.TSOptionalType;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
    }): N.TSOptionalType;
}
export interface TSIndexedAccessTypeBuilder {
    (objectType: K.TSTypeKind, indexType: K.TSTypeKind): N.TSIndexedAccessType;
    from(params: {
        comments?: K.CommentKind[] | null;
        indexType: K.TSTypeKind;
        loc?: K.SourceLocationKind | null;
        objectType: K.TSTypeKind;
    }): N.TSIndexedAccessType;
}
export interface TSTypeOperatorBuilder {
    (operator: string): N.TSTypeOperator;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        operator: string;
        typeAnnotation: K.TSTypeKind;
    }): N.TSTypeOperator;
}
export interface TSIndexSignatureBuilder {
    (parameters: K.IdentifierKind[], typeAnnotation?: K.TSTypeAnnotationKind | null): N.TSIndexSignature;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameters: K.IdentifierKind[];
        readonly?: boolean;
        typeAnnotation?: K.TSTypeAnnotationKind | null;
    }): N.TSIndexSignature;
}
export interface TSPropertySignatureBuilder {
    (key: K.ExpressionKind, typeAnnotation?: K.TSTypeAnnotationKind | null, optional?: boolean): N.TSPropertySignature;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        initializer?: K.ExpressionKind | null;
        key: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        optional?: boolean;
        readonly?: boolean;
        typeAnnotation?: K.TSTypeAnnotationKind | null;
    }): N.TSPropertySignature;
}
export interface TSMethodSignatureBuilder {
    (key: K.ExpressionKind, parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[], typeAnnotation?: K.TSTypeAnnotationKind | null): N.TSMethodSignature;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        key: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
        optional?: boolean;
        parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
        typeAnnotation?: K.TSTypeAnnotationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSMethodSignature;
}
export interface TSTypePredicateBuilder {
    (parameterName: K.IdentifierKind | K.TSThisTypeKind, typeAnnotation: K.TSTypeAnnotationKind): N.TSTypePredicate;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameterName: K.IdentifierKind | K.TSThisTypeKind;
        typeAnnotation: K.TSTypeAnnotationKind;
    }): N.TSTypePredicate;
}
export interface TSCallSignatureDeclarationBuilder {
    (parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[], typeAnnotation?: K.TSTypeAnnotationKind | null): N.TSCallSignatureDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
        typeAnnotation?: K.TSTypeAnnotationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSCallSignatureDeclaration;
}
export interface TSConstructSignatureDeclarationBuilder {
    (parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[], typeAnnotation?: K.TSTypeAnnotationKind | null): N.TSConstructSignatureDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameters: (K.IdentifierKind | K.RestElementKind | K.ArrayPatternKind | K.ObjectPatternKind)[];
        typeAnnotation?: K.TSTypeAnnotationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSConstructSignatureDeclaration;
}
export interface TSEnumMemberBuilder {
    (id: K.IdentifierKind | K.StringLiteralKind, initializer?: K.ExpressionKind | null): N.TSEnumMember;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind | K.StringLiteralKind;
        initializer?: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSEnumMember;
}
export interface TSTypeQueryBuilder {
    (exprName: K.IdentifierKind | K.TSQualifiedNameKind | K.TSImportTypeKind): N.TSTypeQuery;
    from(params: {
        comments?: K.CommentKind[] | null;
        exprName: K.IdentifierKind | K.TSQualifiedNameKind | K.TSImportTypeKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSTypeQuery;
}
export interface TSImportTypeBuilder {
    (argument: K.StringLiteralKind, qualifier?: K.IdentifierKind | K.TSQualifiedNameKind | undefined, typeParameters?: K.TSTypeParameterInstantiationKind | null): N.TSImportType;
    from(params: {
        argument: K.StringLiteralKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        qualifier?: K.IdentifierKind | K.TSQualifiedNameKind | undefined;
        typeParameters?: K.TSTypeParameterInstantiationKind | null;
    }): N.TSImportType;
}
export interface TSTypeLiteralBuilder {
    (members: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[]): N.TSTypeLiteral;
    from(params: {
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        members: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
    }): N.TSTypeLiteral;
}
export interface TSTypeAssertionBuilder {
    (typeAnnotation: K.TSTypeKind, expression: K.ExpressionKind): N.TSTypeAssertion;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        extra?: {
            parenthesized: boolean;
        } | null;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
    }): N.TSTypeAssertion;
}
export interface TSEnumDeclarationBuilder {
    (id: K.IdentifierKind, members: K.TSEnumMemberKind[]): N.TSEnumDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        const?: boolean;
        declare?: boolean;
        id: K.IdentifierKind;
        initializer?: K.ExpressionKind | null;
        loc?: K.SourceLocationKind | null;
        members: K.TSEnumMemberKind[];
    }): N.TSEnumDeclaration;
}
export interface TSTypeAliasDeclarationBuilder {
    (id: K.IdentifierKind, typeAnnotation: K.TSTypeKind): N.TSTypeAliasDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        declare?: boolean;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
        typeAnnotation: K.TSTypeKind;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSTypeAliasDeclaration;
}
export interface TSModuleBlockBuilder {
    (body: K.StatementKind[]): N.TSModuleBlock;
    from(params: {
        body: K.StatementKind[];
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSModuleBlock;
}
export interface TSModuleDeclarationBuilder {
    (id: K.StringLiteralKind | K.IdentifierKind | K.TSQualifiedNameKind, body?: K.TSModuleBlockKind | K.TSModuleDeclarationKind | null): N.TSModuleDeclaration;
    from(params: {
        body?: K.TSModuleBlockKind | K.TSModuleDeclarationKind | null;
        comments?: K.CommentKind[] | null;
        declare?: boolean;
        global?: boolean;
        id: K.StringLiteralKind | K.IdentifierKind | K.TSQualifiedNameKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSModuleDeclaration;
}
export interface TSImportEqualsDeclarationBuilder {
    (id: K.IdentifierKind, moduleReference: K.IdentifierKind | K.TSQualifiedNameKind | K.TSExternalModuleReferenceKind): N.TSImportEqualsDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        isExport?: boolean;
        loc?: K.SourceLocationKind | null;
        moduleReference: K.IdentifierKind | K.TSQualifiedNameKind | K.TSExternalModuleReferenceKind;
    }): N.TSImportEqualsDeclaration;
}
export interface TSExternalModuleReferenceBuilder {
    (expression: K.StringLiteralKind): N.TSExternalModuleReference;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.StringLiteralKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSExternalModuleReference;
}
export interface TSExportAssignmentBuilder {
    (expression: K.ExpressionKind): N.TSExportAssignment;
    from(params: {
        comments?: K.CommentKind[] | null;
        expression: K.ExpressionKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSExportAssignment;
}
export interface TSNamespaceExportDeclarationBuilder {
    (id: K.IdentifierKind): N.TSNamespaceExportDeclaration;
    from(params: {
        comments?: K.CommentKind[] | null;
        id: K.IdentifierKind;
        loc?: K.SourceLocationKind | null;
    }): N.TSNamespaceExportDeclaration;
}
export interface TSInterfaceBodyBuilder {
    (body: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[]): N.TSInterfaceBody;
    from(params: {
        body: (K.TSCallSignatureDeclarationKind | K.TSConstructSignatureDeclarationKind | K.TSIndexSignatureKind | K.TSMethodSignatureKind | K.TSPropertySignatureKind)[];
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
    }): N.TSInterfaceBody;
}
export interface TSInterfaceDeclarationBuilder {
    (id: K.IdentifierKind | K.TSQualifiedNameKind, body: K.TSInterfaceBodyKind): N.TSInterfaceDeclaration;
    from(params: {
        body: K.TSInterfaceBodyKind;
        comments?: K.CommentKind[] | null;
        declare?: boolean;
        extends?: K.TSExpressionWithTypeArgumentsKind[] | null;
        id: K.IdentifierKind | K.TSQualifiedNameKind;
        loc?: K.SourceLocationKind | null;
        typeParameters?: K.TSTypeParameterDeclarationKind | null | undefined;
    }): N.TSInterfaceDeclaration;
}
export interface TSParameterPropertyBuilder {
    (parameter: K.IdentifierKind | K.AssignmentPatternKind): N.TSParameterProperty;
    from(params: {
        accessibility?: "public" | "private" | "protected" | undefined;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        parameter: K.IdentifierKind | K.AssignmentPatternKind;
        readonly?: boolean;
    }): N.TSParameterProperty;
}
export interface OptionalMemberExpressionBuilder {
    (object: K.ExpressionKind, property: K.IdentifierKind | K.ExpressionKind, computed?: boolean, optional?: boolean): N.OptionalMemberExpression;
    from(params: {
        comments?: K.CommentKind[] | null;
        computed?: boolean;
        loc?: K.SourceLocationKind | null;
        object: K.ExpressionKind;
        optional?: boolean;
        property: K.IdentifierKind | K.ExpressionKind;
    }): N.OptionalMemberExpression;
}
export interface OptionalCallExpressionBuilder {
    (callee: K.ExpressionKind, argumentsParam: (K.ExpressionKind | K.SpreadElementKind)[], optional?: boolean): N.OptionalCallExpression;
    from(params: {
        arguments: (K.ExpressionKind | K.SpreadElementKind)[];
        callee: K.ExpressionKind;
        comments?: K.CommentKind[] | null;
        loc?: K.SourceLocationKind | null;
        optional?: boolean;
    }): N.OptionalCallExpression;
}
export interface Builders {
    file: FileBuilder;
    program: ProgramBuilder;
    identifier: IdentifierBuilder;
    blockStatement: BlockStatementBuilder;
    emptyStatement: EmptyStatementBuilder;
    expressionStatement: ExpressionStatementBuilder;
    ifStatement: IfStatementBuilder;
    labeledStatement: LabeledStatementBuilder;
    breakStatement: BreakStatementBuilder;
    continueStatement: ContinueStatementBuilder;
    withStatement: WithStatementBuilder;
    switchStatement: SwitchStatementBuilder;
    switchCase: SwitchCaseBuilder;
    returnStatement: ReturnStatementBuilder;
    throwStatement: ThrowStatementBuilder;
    tryStatement: TryStatementBuilder;
    catchClause: CatchClauseBuilder;
    whileStatement: WhileStatementBuilder;
    doWhileStatement: DoWhileStatementBuilder;
    forStatement: ForStatementBuilder;
    variableDeclaration: VariableDeclarationBuilder;
    forInStatement: ForInStatementBuilder;
    debuggerStatement: DebuggerStatementBuilder;
    functionDeclaration: FunctionDeclarationBuilder;
    functionExpression: FunctionExpressionBuilder;
    variableDeclarator: VariableDeclaratorBuilder;
    thisExpression: ThisExpressionBuilder;
    arrayExpression: ArrayExpressionBuilder;
    objectExpression: ObjectExpressionBuilder;
    property: PropertyBuilder;
    literal: LiteralBuilder;
    sequenceExpression: SequenceExpressionBuilder;
    unaryExpression: UnaryExpressionBuilder;
    binaryExpression: BinaryExpressionBuilder;
    assignmentExpression: AssignmentExpressionBuilder;
    updateExpression: UpdateExpressionBuilder;
    logicalExpression: LogicalExpressionBuilder;
    conditionalExpression: ConditionalExpressionBuilder;
    newExpression: NewExpressionBuilder;
    callExpression: CallExpressionBuilder;
    memberExpression: MemberExpressionBuilder;
    restElement: RestElementBuilder;
    typeAnnotation: TypeAnnotationBuilder;
    tsTypeAnnotation: TSTypeAnnotationBuilder;
    spreadElementPattern: SpreadElementPatternBuilder;
    arrowFunctionExpression: ArrowFunctionExpressionBuilder;
    forOfStatement: ForOfStatementBuilder;
    yieldExpression: YieldExpressionBuilder;
    generatorExpression: GeneratorExpressionBuilder;
    comprehensionBlock: ComprehensionBlockBuilder;
    comprehensionExpression: ComprehensionExpressionBuilder;
    objectProperty: ObjectPropertyBuilder;
    propertyPattern: PropertyPatternBuilder;
    objectPattern: ObjectPatternBuilder;
    arrayPattern: ArrayPatternBuilder;
    methodDefinition: MethodDefinitionBuilder;
    spreadElement: SpreadElementBuilder;
    assignmentPattern: AssignmentPatternBuilder;
    classPropertyDefinition: ClassPropertyDefinitionBuilder;
    classProperty: ClassPropertyBuilder;
    classBody: ClassBodyBuilder;
    classDeclaration: ClassDeclarationBuilder;
    classExpression: ClassExpressionBuilder;
    importSpecifier: ImportSpecifierBuilder;
    importNamespaceSpecifier: ImportNamespaceSpecifierBuilder;
    importDefaultSpecifier: ImportDefaultSpecifierBuilder;
    importDeclaration: ImportDeclarationBuilder;
    taggedTemplateExpression: TaggedTemplateExpressionBuilder;
    templateLiteral: TemplateLiteralBuilder;
    templateElement: TemplateElementBuilder;
    spreadProperty: SpreadPropertyBuilder;
    spreadPropertyPattern: SpreadPropertyPatternBuilder;
    awaitExpression: AwaitExpressionBuilder;
    jsxAttribute: JSXAttributeBuilder;
    jsxIdentifier: JSXIdentifierBuilder;
    jsxNamespacedName: JSXNamespacedNameBuilder;
    jsxExpressionContainer: JSXExpressionContainerBuilder;
    jsxMemberExpression: JSXMemberExpressionBuilder;
    jsxSpreadAttribute: JSXSpreadAttributeBuilder;
    jsxElement: JSXElementBuilder;
    jsxOpeningElement: JSXOpeningElementBuilder;
    jsxClosingElement: JSXClosingElementBuilder;
    jsxFragment: JSXFragmentBuilder;
    jsxText: JSXTextBuilder;
    jsxOpeningFragment: JSXOpeningFragmentBuilder;
    jsxClosingFragment: JSXClosingFragmentBuilder;
    jsxEmptyExpression: JSXEmptyExpressionBuilder;
    jsxSpreadChild: JSXSpreadChildBuilder;
    typeParameterDeclaration: TypeParameterDeclarationBuilder;
    tsTypeParameterDeclaration: TSTypeParameterDeclarationBuilder;
    typeParameterInstantiation: TypeParameterInstantiationBuilder;
    tsTypeParameterInstantiation: TSTypeParameterInstantiationBuilder;
    classImplements: ClassImplementsBuilder;
    tsExpressionWithTypeArguments: TSExpressionWithTypeArgumentsBuilder;
    anyTypeAnnotation: AnyTypeAnnotationBuilder;
    emptyTypeAnnotation: EmptyTypeAnnotationBuilder;
    mixedTypeAnnotation: MixedTypeAnnotationBuilder;
    voidTypeAnnotation: VoidTypeAnnotationBuilder;
    numberTypeAnnotation: NumberTypeAnnotationBuilder;
    numberLiteralTypeAnnotation: NumberLiteralTypeAnnotationBuilder;
    numericLiteralTypeAnnotation: NumericLiteralTypeAnnotationBuilder;
    stringTypeAnnotation: StringTypeAnnotationBuilder;
    stringLiteralTypeAnnotation: StringLiteralTypeAnnotationBuilder;
    booleanTypeAnnotation: BooleanTypeAnnotationBuilder;
    booleanLiteralTypeAnnotation: BooleanLiteralTypeAnnotationBuilder;
    nullableTypeAnnotation: NullableTypeAnnotationBuilder;
    nullLiteralTypeAnnotation: NullLiteralTypeAnnotationBuilder;
    nullTypeAnnotation: NullTypeAnnotationBuilder;
    thisTypeAnnotation: ThisTypeAnnotationBuilder;
    existsTypeAnnotation: ExistsTypeAnnotationBuilder;
    existentialTypeParam: ExistentialTypeParamBuilder;
    functionTypeAnnotation: FunctionTypeAnnotationBuilder;
    functionTypeParam: FunctionTypeParamBuilder;
    arrayTypeAnnotation: ArrayTypeAnnotationBuilder;
    objectTypeAnnotation: ObjectTypeAnnotationBuilder;
    objectTypeProperty: ObjectTypePropertyBuilder;
    objectTypeSpreadProperty: ObjectTypeSpreadPropertyBuilder;
    objectTypeIndexer: ObjectTypeIndexerBuilder;
    objectTypeCallProperty: ObjectTypeCallPropertyBuilder;
    objectTypeInternalSlot: ObjectTypeInternalSlotBuilder;
    variance: VarianceBuilder;
    qualifiedTypeIdentifier: QualifiedTypeIdentifierBuilder;
    genericTypeAnnotation: GenericTypeAnnotationBuilder;
    memberTypeAnnotation: MemberTypeAnnotationBuilder;
    unionTypeAnnotation: UnionTypeAnnotationBuilder;
    intersectionTypeAnnotation: IntersectionTypeAnnotationBuilder;
    typeofTypeAnnotation: TypeofTypeAnnotationBuilder;
    typeParameter: TypeParameterBuilder;
    interfaceTypeAnnotation: InterfaceTypeAnnotationBuilder;
    interfaceExtends: InterfaceExtendsBuilder;
    interfaceDeclaration: InterfaceDeclarationBuilder;
    declareInterface: DeclareInterfaceBuilder;
    typeAlias: TypeAliasBuilder;
    opaqueType: OpaqueTypeBuilder;
    declareTypeAlias: DeclareTypeAliasBuilder;
    declareOpaqueType: DeclareOpaqueTypeBuilder;
    typeCastExpression: TypeCastExpressionBuilder;
    tupleTypeAnnotation: TupleTypeAnnotationBuilder;
    declareVariable: DeclareVariableBuilder;
    declareFunction: DeclareFunctionBuilder;
    declareClass: DeclareClassBuilder;
    declareModule: DeclareModuleBuilder;
    declareModuleExports: DeclareModuleExportsBuilder;
    declareExportDeclaration: DeclareExportDeclarationBuilder;
    exportSpecifier: ExportSpecifierBuilder;
    exportBatchSpecifier: ExportBatchSpecifierBuilder;
    declareExportAllDeclaration: DeclareExportAllDeclarationBuilder;
    inferredPredicate: InferredPredicateBuilder;
    declaredPredicate: DeclaredPredicateBuilder;
    exportDeclaration: ExportDeclarationBuilder;
    block: BlockBuilder;
    line: LineBuilder;
    noop: NoopBuilder;
    doExpression: DoExpressionBuilder;
    super: SuperBuilder;
    bindExpression: BindExpressionBuilder;
    decorator: DecoratorBuilder;
    metaProperty: MetaPropertyBuilder;
    parenthesizedExpression: ParenthesizedExpressionBuilder;
    exportDefaultDeclaration: ExportDefaultDeclarationBuilder;
    exportNamedDeclaration: ExportNamedDeclarationBuilder;
    exportNamespaceSpecifier: ExportNamespaceSpecifierBuilder;
    exportDefaultSpecifier: ExportDefaultSpecifierBuilder;
    exportAllDeclaration: ExportAllDeclarationBuilder;
    commentBlock: CommentBlockBuilder;
    commentLine: CommentLineBuilder;
    directive: DirectiveBuilder;
    directiveLiteral: DirectiveLiteralBuilder;
    interpreterDirective: InterpreterDirectiveBuilder;
    stringLiteral: StringLiteralBuilder;
    numericLiteral: NumericLiteralBuilder;
    bigIntLiteral: BigIntLiteralBuilder;
    nullLiteral: NullLiteralBuilder;
    booleanLiteral: BooleanLiteralBuilder;
    regExpLiteral: RegExpLiteralBuilder;
    objectMethod: ObjectMethodBuilder;
    classPrivateProperty: ClassPrivatePropertyBuilder;
    classMethod: ClassMethodBuilder;
    classPrivateMethod: ClassPrivateMethodBuilder;
    privateName: PrivateNameBuilder;
    restProperty: RestPropertyBuilder;
    forAwaitStatement: ForAwaitStatementBuilder;
    import: ImportBuilder;
    tsQualifiedName: TSQualifiedNameBuilder;
    tsTypeReference: TSTypeReferenceBuilder;
    tsAsExpression: TSAsExpressionBuilder;
    tsNonNullExpression: TSNonNullExpressionBuilder;
    tsAnyKeyword: TSAnyKeywordBuilder;
    tsBigIntKeyword: TSBigIntKeywordBuilder;
    tsBooleanKeyword: TSBooleanKeywordBuilder;
    tsNeverKeyword: TSNeverKeywordBuilder;
    tsNullKeyword: TSNullKeywordBuilder;
    tsNumberKeyword: TSNumberKeywordBuilder;
    tsObjectKeyword: TSObjectKeywordBuilder;
    tsStringKeyword: TSStringKeywordBuilder;
    tsSymbolKeyword: TSSymbolKeywordBuilder;
    tsUndefinedKeyword: TSUndefinedKeywordBuilder;
    tsUnknownKeyword: TSUnknownKeywordBuilder;
    tsVoidKeyword: TSVoidKeywordBuilder;
    tsThisType: TSThisTypeBuilder;
    tsArrayType: TSArrayTypeBuilder;
    tsLiteralType: TSLiteralTypeBuilder;
    tsUnionType: TSUnionTypeBuilder;
    tsIntersectionType: TSIntersectionTypeBuilder;
    tsConditionalType: TSConditionalTypeBuilder;
    tsInferType: TSInferTypeBuilder;
    tsTypeParameter: TSTypeParameterBuilder;
    tsParenthesizedType: TSParenthesizedTypeBuilder;
    tsFunctionType: TSFunctionTypeBuilder;
    tsConstructorType: TSConstructorTypeBuilder;
    tsDeclareFunction: TSDeclareFunctionBuilder;
    tsDeclareMethod: TSDeclareMethodBuilder;
    tsMappedType: TSMappedTypeBuilder;
    tsTupleType: TSTupleTypeBuilder;
    tsRestType: TSRestTypeBuilder;
    tsOptionalType: TSOptionalTypeBuilder;
    tsIndexedAccessType: TSIndexedAccessTypeBuilder;
    tsTypeOperator: TSTypeOperatorBuilder;
    tsIndexSignature: TSIndexSignatureBuilder;
    tsPropertySignature: TSPropertySignatureBuilder;
    tsMethodSignature: TSMethodSignatureBuilder;
    tsTypePredicate: TSTypePredicateBuilder;
    tsCallSignatureDeclaration: TSCallSignatureDeclarationBuilder;
    tsConstructSignatureDeclaration: TSConstructSignatureDeclarationBuilder;
    tsEnumMember: TSEnumMemberBuilder;
    tsTypeQuery: TSTypeQueryBuilder;
    tsImportType: TSImportTypeBuilder;
    tsTypeLiteral: TSTypeLiteralBuilder;
    tsTypeAssertion: TSTypeAssertionBuilder;
    tsEnumDeclaration: TSEnumDeclarationBuilder;
    tsTypeAliasDeclaration: TSTypeAliasDeclarationBuilder;
    tsModuleBlock: TSModuleBlockBuilder;
    tsModuleDeclaration: TSModuleDeclarationBuilder;
    tsImportEqualsDeclaration: TSImportEqualsDeclarationBuilder;
    tsExternalModuleReference: TSExternalModuleReferenceBuilder;
    tsExportAssignment: TSExportAssignmentBuilder;
    tsNamespaceExportDeclaration: TSNamespaceExportDeclarationBuilder;
    tsInterfaceBody: TSInterfaceBodyBuilder;
    tsInterfaceDeclaration: TSInterfaceDeclarationBuilder;
    tsParameterProperty: TSParameterPropertyBuilder;
    optionalMemberExpression: OptionalMemberExpressionBuilder;
    optionalCallExpression: OptionalCallExpressionBuilder;
    [builderName: string]: any;
}
