/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 *
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Richard Petersen <richard.petersen@open-xchange.com>
 *
 */

(function (tinymce) {
    tinymce.PluginManager.add('oxdrop', function (editor) {

        editor.on('PreInit', function (e) {
            var target = $(e.target.bodyElement),
                onDrop = function (e) {
                    // prevent dropping of html
                    var dt = e.originalEvent.dataTransfer;
                    // check dropped html because the tinymce pasteplugin doesn't do this.
                    if (_(dt.types).contains('text/html')) {
                        e.preventDefault();
                        // stopPropagation is not enough here
                        e.stopImmediatePropagation();

                        var markupString = dt.getData('text/html');
                        // remove event handlers to prevent script injection
                        markupString = markupString.replace(/\s+on\w+\s*=\s*".*?"/gi, '');
                        // remove script tags
                        markupString = markupString.replace(/<script>.*?<\/script>/gi, '');
                        // insert contend at cursor position
                        window.tinyMCE.execCommand('mceInsertContent', false, markupString);
                    }
                };

            // capture drop event to prevent bug in tinymce paste plugin when a html image is dragged
            target.on('drop', onDrop);
            require(['io.ox/core/dropzone', 'io.ox/core/notifications', 'gettext!io.ox/mail'], function (dropzone, notifications, gt) {
                var zone = new dropzone.Inplace({
                    caption: gt('Drop inline images here')
                });

                zone.on({
                    'show': function () {
                        zone.$el.css('top', (target.offset().top - target.parent().offset().top));
                    },
                    'drop': function (files) {
                        var hasNonImages = _(files).reduce(function (memo, file) {
                            return memo || !/^image/.test(file.type);
                        }, false);

                        if (hasNonImages) {
                            notifications.yell('error', 'Please only drop images here. If you want to send other files, you can send them as attachments.');
                        } else {
                            _(files).each(window.tinyMCE.activeEditor.plugins.oximage.uploadBlob);
                        }
                    }
                });

                target.after(zone.render().$el.addClass('abs'));

                zone.$el.on('remove', function () {
                    target.off('drop', onDrop);
                });
            });
        });

    });
}(window.tinymce));
