/**
 * This work is provided under the terms of the CREATIVE COMMONS PUBLIC
 * LICENSE. This work is protected by copyright and/or other applicable
 * law. Any use of the work other than as authorized under this license
 * or copyright law is prohibited.
 *
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * © 2016 OX Software GmbH, Germany. info@open-xchange.com
 *
 * @author Julian Bäume <julian.baeume@open-xchange.com>
 * @author Matthias Biggeleben <matthias.biggeleben@open-xchange.com>
 */

(function () {

    'use strict';

    //
    // Plugin functions
    //

    function onInsertEmoji(e) {
        e.preventDefault();

        var icon = $(e.target).data('icon'),
            html = '<img src="apps/themes/login/1x1.gif" rel="0" ' +
                'class="emoji ' + icon.css + '" data-emoji-unicode="' + icon.unicode + '" ' +
                'data-mce-resize="false">';

        this.editor.execCommand('mceInsertContent', false, html);
    }

    // this is called for each editor instance
    function init(ed, url) {
        var view = null, panelId = 'emoji-' + ed.id;

        // load required code now
        require(['io.ox/core/emoji/view'], function (EmojiView) {
            // create instance only once per editor
            view = new EmojiView({ editor: ed, onInsertEmoji: onInsertEmoji });
        });
        function renderView() {
            return '<div id="' + panelId + '">';
        }

        // TODO: translate title
        ed.addButton('emoji', {
            type: 'panelbutton',
            tooltip: 'Emoticons',
            icon: 'emoticons',
            panel: {
                layout: 'grid',
                role: "application",
                html: renderView,
                onPostRender: function () {
                    this.on('show', function () {
                        if ($('#' + panelId).is(':empty') && view) {
                            $('#' + panelId).append(view.$el);
                        }
                        if (view) {
                            view.toggle();
                        };
                    }).on('hide', function () {
                        if (view) {
                            view.toggle();
                        };
                    });
                }
        }

        });
    }

    window.tinymce.PluginManager.add('emoji', init);

}());
