/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Viktor Pracht <viktor.pracht@open-xchange.com>
 */

ox.gui.initToolBarNewWindowTask = function() {

    var $p = ox.gui.initToolBarNewWindow(),
        upsell = corewindow.ox.upsell;
    
    /*
     * Meta data
     */
    var meta = $.extend(ox.widgets.toolBar.meta, {
        /*
         * New Mail Window
         */
        "window_task": {
            "save": {
                title: _("Save"),
                icons: ["save.png"],
                big: true
               
            },
            "add-participant": {
                title: _("Add participant"),
                icons: ["member_add.png"],
                requires : function() {
                    return ox.api.config.get("modules.tasks.delegate_tasks") &&
                           ox.api.config.get("participants.showDialog");
                },
                big: true,
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/tasks/new/add_participants", window);
                    }
                }
            },
            "add-external-participant": {
                title: _("Add external participant"),
                icons: ["distributionlist_extcontact.png"],
                requires : function() {
                    return ox.api.config.get("modules.tasks.delegate_tasks") &&
                           ox.api.config.get("participants.showDialog");
                },
                big: true,
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/tasks/new/add_participants", window);
                    }
                }
            },
            "remove-participant": {
                title: _("Remove participant"),
                icons: ["member_remove.png"],
                selection: "participants",
                requires : function(ability) {
                    return ox.api.config.get("modules.tasks.delegate_tasks") &&
                           currentpath[1] === "participant" && 
                           ox.api.config.get("participants.showDialog") &&
                           ability.some;
                },
                big: true,
                mousedown: function(options, e) {
                    if (ox.api.config.get("participants.showDialog") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/tasks/new/remove_participants", window);
                    }
                }
            },
            "attachment-add": {
                title: _("Add attachment"),
                icons: ["attachment_add.png"],
                requires: function() {
                    return ox.api.config.get('modules.infostore.module');
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/tasks/new/add_attachment", window);
                    }
                },
                visible: upsell.visible("infostore")
            },
            "attachment-remove": {
                title: _("Remove attachment"),
                icons: ["attachment_remove.png"],
                selection: "attachments",
                requires: function(ability) {
                    return currentpath[1] === "attachment" &&
                        ox.api.config.get('modules.infostore.module') &&
                        ability.some;
                },
                mousedown: function (options, e) {
                    if (ox.api.config.get("modules.infostore.module") == false) {
                        corewindow.triggerEvent("Feature_Not_Available", "modules/tasks/new/delete_attachment", window);
                    }
                },
                visible: upsell.visible("infostore")
            },
            "cancel": {
                 title: _("Cancel"),
                 big: true,
                 icons: ["cancel.png"]
            }
        }
    });
    
    
    /*
     * Add widgets
     */
    
    // vars
    var tabs = ox.widgets.toolBar.tabs;
    var items = ox.widgets.toolBar.menuItems;
    var toolbar, tab, section;
    
    // fn
    var add = $p.add;
    
    // create toolbar instance
    toolbar = ox.widgets.toolBar.views.task = new ox.gui.TabMenu(
        $p.getOptions({
            id: "new-task-menu",
            showSectionNames: false
        })
    );
    
    // main tab
    tab = tabs.newMailWindow = new ox.gui.PanelMenu(
        "window-task-main", _("&New Task")).addTo(toolbar);
    
    // Section 1, save task
    section = new ox.gui.PanelMenuSection(_("Task")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_task, "task_new", ["save"]);

    // Section 2, add/remove participant
    if (upsell.isVisible("participants")) {
        section = new ox.gui.PanelMenuSection(_("Participants")).addTo(tab);
        add(section, ox.widgets.toolBar.meta.window_task, "task_new",
            ["add-participant", "add-external-participant", "remove-participant"]
        );
    }
    
    // Section 3, add/remove attachment
    if (upsell.isVisible("infostore") && upsell.isVisible("tasks-attachments")) {
        section = new ox.gui.PanelMenuSection(_("Attachment"), "task_newAttachmentSection").addTo(tab);
        add(section, ox.widgets.toolBar.meta.window_task, "task_new",
            ["attachment-add", "attachment-remove"]
        );
    }
    // Section 4, cancel
    section = new ox.gui.PanelMenuSection(_("Cancel")).addTo(tab);
    add(section, ox.widgets.toolBar.meta.window_task, "task_new", ["cancel"]);
    
    // add to top-level element
    toolbar.addTo(ox.widgets.toolBar.viewControl);
    
    $p.postInit();
    
    register("OX_View_Changed", function() {
        ox.ToolBarController.processSelection("default", false, [], true);
        ox.ToolBarController.processSelection("participants", false,
            tmp_participant.participantsGridBig.selection.getSelected(), true);
        ox.ToolBarController.processSelection("attachments", false,
            tmp_attachment ? tmp_attachment.liveGrid.selection.getSelected()
                           : [],
            true);
    });
    
    // event mapping
    var events = {
        "task_new-save" : "OX_SAVE_OBJECT",
        "task_new-add-participant" : "OX_Object_Add_Participant",
        "task_new-add-external-participant" : "OX_Object_Open_External",
        "task_new-remove-participant" : "OX_Object_Participant_Delete",
        "task_new-attachment-add" : "OX_Object_Add_Attachment",
        "task_new-attachment-remove" : "OX_Object_Attachment_Delete",
        "task_new-cancel" : "OX_Cancel_Object"
    };
    
    // add handler function (must return true when action taken)
    ox.ToolBarController.addHandler(function (id) {        
        // defined by event?
        if (events[id] !== undefined) {
            // auto-change tab?
            if (id === "task_new-add-participant" || id === "task_new-add-external-participant") {
                // change tab
                changeView("task_new/participant");
            } else if (id === "task_new-attachment-add") {
                // change tab
                changeView("task_new/attachment");
            }
            // trigger
            triggerEvent(events[id]);
            return true;
        }
    });
    
    ox.desktop.validate();
    
    // initial redraw to update icon state
    triggerEvent("OX_View_Changed");
    ox.api.window.core.triggerEvent("OX_Window_Toolbar_Ready", {
            handle : window.url.guid,
            type : "task"
    });
    ox.ToolBarController.processSelection("participants", false, [], true);
    ox.ToolBarController.processSelection("attachments", false, [], true);
};