/**
 * 
 * All content on this website (including text, images, source
 * code and any other original works), unless otherwise noted,
 * is licensed under a Creative Commons License.
 * 
 * http://creativecommons.org/licenses/by-nc-sa/2.5/
 * 
 * Copyright (C) 2016 OX Software GmbH
 * Mail: info@open-xchange.com 
 * 
 * @author Jan Finsel <jan.finsel@open-xchange.com>
 * 
 */

registerView("configuration/contacts/preferences",
	function () { 
		showNode("config_contact"); 
		$("config_contact").style.display="block";
        
        // toolbar
        temporary.configuration.showToolbar(
            temporary.configuration.defaultToolbar);
    },
	function() { 
		register("OX_SAVE_OBJECT",ccon_saveConfiguration);
		register("OX_Cancel_Object",ccon_cancelConfiguration);
		ccon_enter();
	},
	function() {
		//configuration_askforSave();
		unregister("OX_SAVE_OBJECT",ccon_saveConfiguration);
		unregister("OX_Cancel_Object",ccon_cancelConfiguration);
		ccon_leave();
		
	},
	function () { 
		hideNode("config_contact"); 
		$("config_contact").style.display="none"; },
	function() {
		ccon_enter();
	}
);

var ccon_init_bool=false;
var ccon_default_level1;
var ccon_rows_cardview;
register("OX_Configuration_Loaded",ccon_onconfigload);
function ccon_onconfigload() {
    addDefaultView("contacts/phonelist", _("Phone list"));
    addDefaultView("contacts/cards", _("Cards"));
}
function ccon_init() {
	ccon_default_level1= new ComboBox3(window, "ccon_default_level1", "16em", 1, true,"OX_Configuration_GUI_Changed", 5);
	var conviews=getDefaultSubviews("contacts");
	for (var i in conviews) {
		ccon_default_level1.addElement(conviews[i],i);
	}
	ccon_default_level1.getDomNode();
	
	ccon_rows_cardview= new ComboBox3(window, "ccon_rows_cardview", "16em", 0, true,"OX_Configuration_GUI_Changed", 5);
    ccon_rows_cardview.addElement(_("auto"), "auto");
    ccon_rows_cardview.addElement(noI18n("4"), 4);
    ccon_rows_cardview.addElement(noI18n("5"), 5);
    ccon_rows_cardview.addElement(noI18n("6"), 6);
    ccon_rows_cardview.addElement(noI18n("7"), 7);
	ccon_rows_cardview.getDomNode();
}
function ccon_enter() {
	if(!ccon_init_bool) {
		ccon_init();
		ccon_init_bool=true;
	}
	if(configContainsKey("gui.contacts.view")) {
		ccon_default_level1.setKey(configGetKey("gui.contacts.view"));
		ccon_rows_cardview.setKey(configGetKey("gui.contacts.cardsToViewPerColumn"));
		configuration_changed_fields["gui"]=false;
	}
	if(configContainsKey("gui.effects.hover.contacts")) {
		setIntofRadioBox("ccon_enablehovercontacts",configGetKey("gui.effects.hover.contacts"));
		configuration_changed_fields["gui"]=false;
	}	
	setConfigPath($("ccon_header"));		
}
function ccon_saveConfiguration() {
	if(configuration_changed_fields["gui"]==true) {
		configSetKey("gui.contacts.view",ccon_default_level1.getKey());
		configSetKey("gui.contacts.cardsToViewPerColumn",ccon_rows_cardview.getKey());
		configSetKey("gui.effects.hover.contacts",getBoolofInt(getValueofRadioBox("ccon_enablehovercontacts")));
		menulastviews["contacts"]=ccon_default_level1.getKey();
	}
	triggerEvent("OX_Save_Configuration",false,false);
}
function ccon_cancelConfiguration() {
	configuration_changed_fields["gui"]=false;
	ccon_enter();
}
function ccon_leave() {
}
fileloaded();