package com.openexchange.office.tools.htmldoc;

import org.json.JSONArray;

public class SlideParagraph extends Paragraph {

    private String containerId;
    private String target;

    public SlideParagraph(String containerId, String target) {
        this.containerId = containerId;
        this.target = target;
    }

    @Override
    protected final void appendHTMLCLasses(StringBuilder document) throws Exception {
        document.append(" slide");

        super.appendHTMLCLasses(document);
    }

    @Override
    protected final void appendHTMLAttributes(StringBuilder document) throws Exception {
        document.append(" data-container-id='" + containerId + "' ");
        document.append(" target='" + target + "' ");
    }

    @Override
    protected void appendHTMLStyles(StringBuilder document) throws Exception {

    }

    @Override
    public final void insert(JSONArray start, INode newChild) throws Exception {
        if (start.length() == 1) {
            if (newChild instanceof Text) {
                ((Text) newChild).disableEmptySpanStyle();
            } else {
                ((Drawing) newChild).disableEmptySpanStyle();
            }
        }
        super.insert(start, newChild);
    }
    
    @Override
    protected void addEmptySpan(StringBuilder document) {
        GenDocHelper.addEmptySpan(document, false);
    }

}
