package com.openexchange.office.tools.htmldoc;

import org.json.JSONArray;
import org.json.JSONObject;

public class Container
        extends NodeHolder
{

    private final String id;
    private final String target;
    private final int index;

    public Container(
            int index, String id, String target, boolean invisible, boolean notSelectable, JSONObject attrs)
                throws Exception
    {
        this.index = index;
        this.id = id;
        this.target = target;

        if (!"pagecontent".equals(id))
        {
            this.insert(new JSONArray().put(0), new SlideParagraph(id, target));
        }
        
        if (null != attrs) {
            JSONArray newStart = new JSONArray().put(0);
            setAttribute(newStart, newStart, attrs);
        }
    }

    public int getIndex()
    {
        return index;
    }

    @Override
    public boolean setAttribute(
        JSONArray start,
        JSONArray end,
        JSONObject attrs)
            throws Exception
    {
        //return getChildren().get(0).setAttribute(start, end, attrs);
        return super.setAttribute(start, end, attrs);
    }



    @Override
    public boolean needsEmptySpan()
    {
        return false;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
            throws Exception
    {

        if ("pagecontent".equals(id))
        {
            document.append("<div class='pagecontent'");
        }
        else
        {
            document.append("<div class='slidecontainer' data-container-id='" + id + "'");

            final JSONObject adapter = GenDocHelper.getJQueryData(getAttribute(), false);
            adapter.put("id", id);

            if (target != null)
            {
                adapter.put("target", target);
            }
            GenDocHelper.appendJQueryData(document, adapter);
        }

        document.append(">");

        super.appendContent(document);

        document.append("</div>");

        return true;
    }

}
