package com.openexchange.office.tools.htmldoc;

import org.apache.commons.lang.StringEscapeUtils;
import org.json.JSONObject;

public class ComplexField
        extends SubNode
{

    private static final String FIELDSTART = "<div contenteditable=\"false\" class=\"inline complexfield\" ";
    private static final String FIELDCLOSER = "\" ";
    private static final String FIELDID = "data-field-id=\"";
    private static final String FIELDINSTRUCTION = "data-field-instruction=\"";
    private static final String FIELDEND = "></div>";

    private String              id;
    private String              instruction;

    // ///////////////////////////////////////////////////////////

    public ComplexField(
            int logicalPosition, String id, String instruction)
    {
        super(logicalPosition, 1);

        this.instruction = instruction;
        this.id = id;
    }

    @Override
    public boolean appendContent(
        StringBuilder document)
        throws Exception
    {
        document.append(FIELDSTART);
        document.append(FIELDID + this.id + FIELDCLOSER);
        document.append(FIELDINSTRUCTION + StringEscapeUtils.escapeHtml(this.instruction) + FIELDCLOSER);

        JSONObject attrs = getAttribute();
        if (attrs == null)
        {
            attrs = new JSONObject();
        }
        
        JSONObject jq = GenDocHelper.getJQueryData(attrs);
    	jq.put("fieldId", id);
        jq.put("fieldInstructions", instruction);
        
        GenDocHelper.appendJQueryData(document, jq);
        
        document.append(FIELDEND);

        return true;
    }

    @Override
    public boolean needsEmptySpan()
    {
        return true;
    }

    @Override
    public String toString()
    {
        return "ComplexField";
    }

}
